/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.account;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.account.TLAbsPassword;
import com.github.badoualy.telegram.tl.core.TLBytes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLPassword
extends TLAbsPassword {
    public static final int CONSTRUCTOR_ID = 2081952796;
    protected TLBytes currentSalt;
    protected String hint;
    protected boolean hasRecovery;
    private final String _constructor = "account.password#7c18141c";

    public TLPassword() {
    }

    public TLPassword(TLBytes currentSalt, TLBytes newSalt, String hint, boolean hasRecovery, String emailUnconfirmedPattern) {
        this.currentSalt = currentSalt;
        this.newSalt = newSalt;
        this.hint = hint;
        this.hasRecovery = hasRecovery;
        this.emailUnconfirmedPattern = emailUnconfirmedPattern;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeTLBytes(this.currentSalt, stream);
        StreamUtils.writeTLBytes(this.newSalt, stream);
        StreamUtils.writeString(this.hint, stream);
        StreamUtils.writeBoolean(this.hasRecovery, stream);
        StreamUtils.writeString(this.emailUnconfirmedPattern, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.currentSalt = StreamUtils.readTLBytes(stream, context);
        this.newSalt = StreamUtils.readTLBytes(stream, context);
        this.hint = StreamUtils.readTLString(stream);
        this.hasRecovery = StreamUtils.readTLBool(stream);
        this.emailUnconfirmedPattern = StreamUtils.readTLString(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.computeTLBytesSerializedSize(this.currentSalt);
        size += TLObjectUtils.computeTLBytesSerializedSize(this.newSalt);
        size += TLObjectUtils.computeTLStringSerializedSize(this.hint);
        size += TLObjectUtils.SIZE_BOOLEAN;
        return size += TLObjectUtils.computeTLStringSerializedSize(this.emailUnconfirmedPattern);
    }

    public String toString() {
        return "account.password#7c18141c";
    }

    @Override
    public int getConstructorId() {
        return 2081952796;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLPassword)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLPassword o = (TLPassword)object;
        return (this.currentSalt == o.currentSalt || this.currentSalt != null && o.currentSalt != null && this.currentSalt.equals(o.currentSalt)) && (this.newSalt == o.newSalt || this.newSalt != null && o.newSalt != null && this.newSalt.equals(o.newSalt)) && (this.hint == o.hint || this.hint != null && o.hint != null && this.hint.equals(o.hint)) && this.hasRecovery == o.hasRecovery && (this.emailUnconfirmedPattern == o.emailUnconfirmedPattern || this.emailUnconfirmedPattern != null && o.emailUnconfirmedPattern != null && this.emailUnconfirmedPattern.equals(o.emailUnconfirmedPattern));
    }

    public TLBytes getCurrentSalt() {
        return this.currentSalt;
    }

    public void setCurrentSalt(TLBytes currentSalt) {
        this.currentSalt = currentSalt;
    }

    @Override
    public TLBytes getNewSalt() {
        return this.newSalt;
    }

    @Override
    public void setNewSalt(TLBytes newSalt) {
        this.newSalt = newSalt;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public boolean getHasRecovery() {
        return this.hasRecovery;
    }

    public void setHasRecovery(boolean hasRecovery) {
        this.hasRecovery = hasRecovery;
    }

    @Override
    public String getEmailUnconfirmedPattern() {
        return this.emailUnconfirmedPattern;
    }

    @Override
    public void setEmailUnconfirmedPattern(String emailUnconfirmedPattern) {
        this.emailUnconfirmedPattern = emailUnconfirmedPattern;
    }
}

