/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsDocument;
import com.github.badoualy.telegram.tl.api.TLAbsPhoto;
import com.github.badoualy.telegram.tl.api.TLAbsWebPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLWebPage
extends TLAbsWebPage {
    public static final int CONSTRUCTOR_ID = -897446185;
    protected int flags;
    protected String url;
    protected String displayUrl;
    protected String type;
    protected String siteName;
    protected String title;
    protected String description;
    protected TLAbsPhoto photo;
    protected String embedUrl;
    protected String embedType;
    protected Integer embedWidth;
    protected Integer embedHeight;
    protected Integer duration;
    protected String author;
    protected TLAbsDocument document;
    private final String _constructor = "webPage#ca820ed7";

    public TLWebPage() {
    }

    public TLWebPage(long id, String url, String displayUrl, String type, String siteName, String title, String description, TLAbsPhoto photo, String embedUrl, String embedType, Integer embedWidth, Integer embedHeight, Integer duration, String author, TLAbsDocument document) {
        this.id = id;
        this.url = url;
        this.displayUrl = displayUrl;
        this.type = type;
        this.siteName = siteName;
        this.title = title;
        this.description = description;
        this.photo = photo;
        this.embedUrl = embedUrl;
        this.embedType = embedType;
        this.embedWidth = embedWidth;
        this.embedHeight = embedHeight;
        this.duration = duration;
        this.author = author;
        this.document = document;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.type != null ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.siteName != null ? this.flags | 2 : this.flags & 0xFFFFFFFD;
        this.flags = this.title != null ? this.flags | 4 : this.flags & 0xFFFFFFFB;
        this.flags = this.description != null ? this.flags | 8 : this.flags & 0xFFFFFFF7;
        this.flags = this.photo != null ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
        this.flags = this.embedUrl != null ? this.flags | 0x20 : this.flags & 0xFFFFFFDF;
        this.flags = this.embedType != null ? this.flags | 0x20 : this.flags & 0xFFFFFFDF;
        this.flags = this.embedWidth != null ? this.flags | 0x40 : this.flags & 0xFFFFFFBF;
        this.flags = this.embedHeight != null ? this.flags | 0x40 : this.flags & 0xFFFFFFBF;
        this.flags = this.duration != null ? this.flags | 0x80 : this.flags & 0xFFFFFF7F;
        this.flags = this.author != null ? this.flags | 0x100 : this.flags & 0xFFFFFEFF;
        this.flags = this.document != null ? this.flags | 0x200 : this.flags & 0xFFFFFDFF;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeLong(this.id, stream);
        StreamUtils.writeString(this.url, stream);
        StreamUtils.writeString(this.displayUrl, stream);
        if ((this.flags & 1) != 0) {
            StreamUtils.writeString(this.type, stream);
        }
        if ((this.flags & 2) != 0) {
            StreamUtils.writeString(this.siteName, stream);
        }
        if ((this.flags & 4) != 0) {
            StreamUtils.writeString(this.title, stream);
        }
        if ((this.flags & 8) != 0) {
            StreamUtils.writeString(this.description, stream);
        }
        if ((this.flags & 0x10) != 0) {
            StreamUtils.writeTLObject(this.photo, stream);
        }
        if ((this.flags & 0x20) != 0) {
            StreamUtils.writeString(this.embedUrl, stream);
        }
        if ((this.flags & 0x20) != 0) {
            StreamUtils.writeString(this.embedType, stream);
        }
        if ((this.flags & 0x40) != 0) {
            StreamUtils.writeInt(this.embedWidth, stream);
        }
        if ((this.flags & 0x40) != 0) {
            StreamUtils.writeInt(this.embedHeight, stream);
        }
        if ((this.flags & 0x80) != 0) {
            StreamUtils.writeInt(this.duration, stream);
        }
        if ((this.flags & 0x100) != 0) {
            StreamUtils.writeString(this.author, stream);
        }
        if ((this.flags & 0x200) != 0) {
            StreamUtils.writeTLObject(this.document, stream);
        }
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.id = StreamUtils.readLong(stream);
        this.url = StreamUtils.readTLString(stream);
        this.displayUrl = StreamUtils.readTLString(stream);
        this.type = (this.flags & 1) != 0 ? StreamUtils.readTLString(stream) : null;
        this.siteName = (this.flags & 2) != 0 ? StreamUtils.readTLString(stream) : null;
        this.title = (this.flags & 4) != 0 ? StreamUtils.readTLString(stream) : null;
        this.description = (this.flags & 8) != 0 ? StreamUtils.readTLString(stream) : null;
        this.photo = (this.flags & 0x10) != 0 ? StreamUtils.readTLObject(stream, context, TLAbsPhoto.class, -1) : null;
        this.embedUrl = (this.flags & 0x20) != 0 ? StreamUtils.readTLString(stream) : null;
        this.embedType = (this.flags & 0x20) != 0 ? StreamUtils.readTLString(stream) : null;
        this.embedWidth = (this.flags & 0x40) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.embedHeight = (this.flags & 0x40) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.duration = (this.flags & 0x80) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.author = (this.flags & 0x100) != 0 ? StreamUtils.readTLString(stream) : null;
        this.document = (this.flags & 0x200) != 0 ? StreamUtils.readTLObject(stream, context, TLAbsDocument.class, -1) : null;
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.computeTLStringSerializedSize(this.url);
        size += TLObjectUtils.computeTLStringSerializedSize(this.displayUrl);
        if ((this.flags & 1) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.type);
        }
        if ((this.flags & 2) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.siteName);
        }
        if ((this.flags & 4) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.title);
        }
        if ((this.flags & 8) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.description);
        }
        if ((this.flags & 0x10) != 0) {
            size += this.photo.computeSerializedSize();
        }
        if ((this.flags & 0x20) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.embedUrl);
        }
        if ((this.flags & 0x20) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.embedType);
        }
        if ((this.flags & 0x40) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        if ((this.flags & 0x40) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        if ((this.flags & 0x80) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        if ((this.flags & 0x100) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.author);
        }
        if ((this.flags & 0x200) != 0) {
            size += this.document.computeSerializedSize();
        }
        return size;
    }

    public String toString() {
        return "webPage#ca820ed7";
    }

    @Override
    public int getConstructorId() {
        return -897446185;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLWebPage)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLWebPage o = (TLWebPage)object;
        return this.flags == o.flags && this.id == o.id && (this.url == o.url || this.url != null && o.url != null && this.url.equals(o.url)) && (this.displayUrl == o.displayUrl || this.displayUrl != null && o.displayUrl != null && this.displayUrl.equals(o.displayUrl)) && (this.type == o.type || this.type != null && o.type != null && this.type.equals(o.type)) && (this.siteName == o.siteName || this.siteName != null && o.siteName != null && this.siteName.equals(o.siteName)) && (this.title == o.title || this.title != null && o.title != null && this.title.equals(o.title)) && (this.description == o.description || this.description != null && o.description != null && this.description.equals(o.description)) && (this.photo == o.photo || this.photo != null && o.photo != null && this.photo.equals(o.photo)) && (this.embedUrl == o.embedUrl || this.embedUrl != null && o.embedUrl != null && this.embedUrl.equals(o.embedUrl)) && (this.embedType == o.embedType || this.embedType != null && o.embedType != null && this.embedType.equals(o.embedType)) && (this.embedWidth == o.embedWidth || this.embedWidth != null && o.embedWidth != null && this.embedWidth.equals(o.embedWidth)) && (this.embedHeight == o.embedHeight || this.embedHeight != null && o.embedHeight != null && this.embedHeight.equals(o.embedHeight)) && (this.duration == o.duration || this.duration != null && o.duration != null && this.duration.equals(o.duration)) && (this.author == o.author || this.author != null && o.author != null && this.author.equals(o.author)) && (this.document == o.document || this.document != null && o.document != null && this.document.equals(o.document));
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDisplayUrl() {
        return this.displayUrl;
    }

    public void setDisplayUrl(String displayUrl) {
        this.displayUrl = displayUrl;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TLAbsPhoto getPhoto() {
        return this.photo;
    }

    public void setPhoto(TLAbsPhoto photo) {
        this.photo = photo;
    }

    public String getEmbedUrl() {
        return this.embedUrl;
    }

    public void setEmbedUrl(String embedUrl) {
        this.embedUrl = embedUrl;
    }

    public String getEmbedType() {
        return this.embedType;
    }

    public void setEmbedType(String embedType) {
        this.embedType = embedType;
    }

    public Integer getEmbedWidth() {
        return this.embedWidth;
    }

    public void setEmbedWidth(Integer embedWidth) {
        this.embedWidth = embedWidth;
    }

    public Integer getEmbedHeight() {
        return this.embedHeight;
    }

    public void setEmbedHeight(Integer embedHeight) {
        this.embedHeight = embedHeight;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public TLAbsDocument getDocument() {
        return this.document;
    }

    public void setDocument(TLAbsDocument document) {
        this.document = document;
    }
}

