/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsPhotoSize;
import com.github.badoualy.telegram.tl.api.TLAbsVideo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLVideo
extends TLAbsVideo {
    public static final int CONSTRUCTOR_ID = -148338733;
    protected long accessHash;
    protected int date;
    protected int duration;
    protected String mimeType;
    protected int size;
    protected TLAbsPhotoSize thumb;
    protected int dcId;
    protected int w;
    protected int h;
    private final String _constructor = "video#f72887d3";

    public TLVideo() {
    }

    public TLVideo(long id, long accessHash, int date, int duration, String mimeType, int size, TLAbsPhotoSize thumb, int dcId, int w, int h) {
        this.id = id;
        this.accessHash = accessHash;
        this.date = date;
        this.duration = duration;
        this.mimeType = mimeType;
        this.size = size;
        this.thumb = thumb;
        this.dcId = dcId;
        this.w = w;
        this.h = h;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeLong(this.id, stream);
        StreamUtils.writeLong(this.accessHash, stream);
        StreamUtils.writeInt(this.date, stream);
        StreamUtils.writeInt(this.duration, stream);
        StreamUtils.writeString(this.mimeType, stream);
        StreamUtils.writeInt(this.size, stream);
        StreamUtils.writeTLObject(this.thumb, stream);
        StreamUtils.writeInt(this.dcId, stream);
        StreamUtils.writeInt(this.w, stream);
        StreamUtils.writeInt(this.h, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.id = StreamUtils.readLong(stream);
        this.accessHash = StreamUtils.readLong(stream);
        this.date = StreamUtils.readInt(stream);
        this.duration = StreamUtils.readInt(stream);
        this.mimeType = StreamUtils.readTLString(stream);
        this.size = StreamUtils.readInt(stream);
        this.thumb = StreamUtils.readTLObject(stream, context, TLAbsPhotoSize.class, -1);
        this.dcId = StreamUtils.readInt(stream);
        this.w = StreamUtils.readInt(stream);
        this.h = StreamUtils.readInt(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.computeTLStringSerializedSize(this.mimeType);
        size += TLObjectUtils.SIZE_INT32;
        size += this.thumb.computeSerializedSize();
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.SIZE_INT32;
    }

    public String toString() {
        return "video#f72887d3";
    }

    @Override
    public int getConstructorId() {
        return -148338733;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLVideo)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLVideo o = (TLVideo)object;
        return this.id == o.id && this.accessHash == o.accessHash && this.date == o.date && this.duration == o.duration && (this.mimeType == o.mimeType || this.mimeType != null && o.mimeType != null && this.mimeType.equals(o.mimeType)) && this.size == o.size && (this.thumb == o.thumb || this.thumb != null && o.thumb != null && this.thumb.equals(o.thumb)) && this.dcId == o.dcId && this.w == o.w && this.h == o.h;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public long getAccessHash() {
        return this.accessHash;
    }

    public void setAccessHash(long accessHash) {
        this.accessHash = accessHash;
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int date) {
        this.date = date;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public TLAbsPhotoSize getThumb() {
        return this.thumb;
    }

    public void setThumb(TLAbsPhotoSize thumb) {
        this.thumb = thumb;
    }

    public int getDcId() {
        return this.dcId;
    }

    public void setDcId(int dcId) {
        this.dcId = dcId;
    }

    public int getW() {
        return this.w;
    }

    public void setW(int w) {
        this.w = w;
    }

    public int getH() {
        return this.h;
    }

    public void setH(int h) {
        this.h = h;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public final boolean isNotEmpty() {
        return true;
    }

    @Override
    public final TLVideo getAsVideo() {
        return this;
    }
}

