/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsUser;
import com.github.badoualy.telegram.tl.api.TLAbsUserProfilePhoto;
import com.github.badoualy.telegram.tl.api.TLAbsUserStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLUser
extends TLAbsUser {
    public static final int CONSTRUCTOR_ID = -787638374;
    protected int flags;
    protected boolean self;
    protected boolean contact;
    protected boolean mutualContact;
    protected boolean deleted;
    protected boolean bot;
    protected boolean botChatHistory;
    protected boolean botNochats;
    protected boolean verified;
    protected boolean restricted;
    protected Long accessHash;
    protected String firstName;
    protected String lastName;
    protected String username;
    protected String phone;
    protected TLAbsUserProfilePhoto photo;
    protected TLAbsUserStatus status;
    protected Integer botInfoVersion;
    protected String restrictionReason;
    protected String botInlinePlaceholder;
    private final String _constructor = "user#d10d979a";

    public TLUser() {
    }

    public TLUser(boolean self, boolean contact, boolean mutualContact, boolean deleted, boolean botChatHistory, boolean botNochats, boolean verified, int id, Long accessHash, String firstName, String lastName, String username, String phone, TLAbsUserProfilePhoto photo, TLAbsUserStatus status, Integer botInfoVersion, String restrictionReason, String botInlinePlaceholder) {
        this.self = self;
        this.contact = contact;
        this.mutualContact = mutualContact;
        this.deleted = deleted;
        this.botChatHistory = botChatHistory;
        this.botNochats = botNochats;
        this.verified = verified;
        this.id = id;
        this.accessHash = accessHash;
        this.firstName = firstName;
        this.lastName = lastName;
        this.username = username;
        this.phone = phone;
        this.photo = photo;
        this.status = status;
        this.botInfoVersion = botInfoVersion;
        this.restrictionReason = restrictionReason;
        this.botInlinePlaceholder = botInlinePlaceholder;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.self ? this.flags | 0x400 : this.flags & 0xFFFFFBFF;
        this.flags = this.contact ? this.flags | 0x800 : this.flags & 0xFFFFF7FF;
        this.flags = this.mutualContact ? this.flags | 0x1000 : this.flags & 0xFFFFEFFF;
        this.flags = this.deleted ? this.flags | 0x2000 : this.flags & 0xFFFFDFFF;
        this.flags = this.botChatHistory ? this.flags | 0x8000 : this.flags & 0xFFFF7FFF;
        this.flags = this.botNochats ? this.flags | 0x10000 : this.flags & 0xFFFEFFFF;
        this.flags = this.verified ? this.flags | 0x20000 : this.flags & 0xFFFDFFFF;
        this.flags = this.accessHash != null ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.firstName != null ? this.flags | 2 : this.flags & 0xFFFFFFFD;
        this.flags = this.lastName != null ? this.flags | 4 : this.flags & 0xFFFFFFFB;
        this.flags = this.username != null ? this.flags | 8 : this.flags & 0xFFFFFFF7;
        this.flags = this.phone != null ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
        this.flags = this.photo != null ? this.flags | 0x20 : this.flags & 0xFFFFFFDF;
        this.flags = this.status != null ? this.flags | 0x40 : this.flags & 0xFFFFFFBF;
        this.flags = this.botInfoVersion != null ? this.flags | 0x4000 : this.flags & 0xFFFFBFFF;
        this.flags = this.restrictionReason != null ? this.flags | 0x40000 : this.flags & 0xFFFBFFFF;
        this.flags = this.botInlinePlaceholder != null ? this.flags | 0x80000 : this.flags & 0xFFF7FFFF;
        this.bot = (this.flags & 0x4000) != 0;
        this.restricted = (this.flags & 0x40000) != 0;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeInt(this.id, stream);
        if ((this.flags & 1) != 0) {
            StreamUtils.writeLong(this.accessHash, stream);
        }
        if ((this.flags & 2) != 0) {
            StreamUtils.writeString(this.firstName, stream);
        }
        if ((this.flags & 4) != 0) {
            StreamUtils.writeString(this.lastName, stream);
        }
        if ((this.flags & 8) != 0) {
            StreamUtils.writeString(this.username, stream);
        }
        if ((this.flags & 0x10) != 0) {
            StreamUtils.writeString(this.phone, stream);
        }
        if ((this.flags & 0x20) != 0) {
            StreamUtils.writeTLObject(this.photo, stream);
        }
        if ((this.flags & 0x40) != 0) {
            StreamUtils.writeTLObject(this.status, stream);
        }
        if ((this.flags & 0x4000) != 0) {
            StreamUtils.writeInt(this.botInfoVersion, stream);
        }
        if ((this.flags & 0x40000) != 0) {
            StreamUtils.writeString(this.restrictionReason, stream);
        }
        if ((this.flags & 0x80000) != 0) {
            StreamUtils.writeString(this.botInlinePlaceholder, stream);
        }
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.self = (this.flags & 0x400) != 0;
        this.contact = (this.flags & 0x800) != 0;
        this.mutualContact = (this.flags & 0x1000) != 0;
        this.deleted = (this.flags & 0x2000) != 0;
        this.bot = (this.flags & 0x4000) != 0;
        this.botChatHistory = (this.flags & 0x8000) != 0;
        this.botNochats = (this.flags & 0x10000) != 0;
        this.verified = (this.flags & 0x20000) != 0;
        this.restricted = (this.flags & 0x40000) != 0;
        this.id = StreamUtils.readInt(stream);
        this.accessHash = (this.flags & 1) != 0 ? Long.valueOf(StreamUtils.readLong(stream)) : null;
        this.firstName = (this.flags & 2) != 0 ? StreamUtils.readTLString(stream) : null;
        this.lastName = (this.flags & 4) != 0 ? StreamUtils.readTLString(stream) : null;
        this.username = (this.flags & 8) != 0 ? StreamUtils.readTLString(stream) : null;
        this.phone = (this.flags & 0x10) != 0 ? StreamUtils.readTLString(stream) : null;
        this.photo = (this.flags & 0x20) != 0 ? StreamUtils.readTLObject(stream, context, TLAbsUserProfilePhoto.class, -1) : null;
        this.status = (this.flags & 0x40) != 0 ? StreamUtils.readTLObject(stream, context, TLAbsUserStatus.class, -1) : null;
        this.botInfoVersion = (this.flags & 0x4000) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.restrictionReason = (this.flags & 0x40000) != 0 ? StreamUtils.readTLString(stream) : null;
        this.botInlinePlaceholder = (this.flags & 0x80000) != 0 ? StreamUtils.readTLString(stream) : null;
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        if ((this.flags & 1) != 0) {
            size += TLObjectUtils.SIZE_INT64;
        }
        if ((this.flags & 2) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.firstName);
        }
        if ((this.flags & 4) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.lastName);
        }
        if ((this.flags & 8) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.username);
        }
        if ((this.flags & 0x10) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.phone);
        }
        if ((this.flags & 0x20) != 0) {
            size += this.photo.computeSerializedSize();
        }
        if ((this.flags & 0x40) != 0) {
            size += this.status.computeSerializedSize();
        }
        if ((this.flags & 0x4000) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        if ((this.flags & 0x40000) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.restrictionReason);
        }
        if ((this.flags & 0x80000) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.botInlinePlaceholder);
        }
        return size;
    }

    public String toString() {
        return "user#d10d979a";
    }

    @Override
    public int getConstructorId() {
        return -787638374;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLUser)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLUser o = (TLUser)object;
        return this.flags == o.flags && this.self == o.self && this.contact == o.contact && this.mutualContact == o.mutualContact && this.deleted == o.deleted && this.bot == o.bot && this.botChatHistory == o.botChatHistory && this.botNochats == o.botNochats && this.verified == o.verified && this.restricted == o.restricted && this.id == o.id && (this.accessHash == o.accessHash || this.accessHash != null && o.accessHash != null && this.accessHash.equals(o.accessHash)) && (this.firstName == o.firstName || this.firstName != null && o.firstName != null && this.firstName.equals(o.firstName)) && (this.lastName == o.lastName || this.lastName != null && o.lastName != null && this.lastName.equals(o.lastName)) && (this.username == o.username || this.username != null && o.username != null && this.username.equals(o.username)) && (this.phone == o.phone || this.phone != null && o.phone != null && this.phone.equals(o.phone)) && (this.photo == o.photo || this.photo != null && o.photo != null && this.photo.equals(o.photo)) && (this.status == o.status || this.status != null && o.status != null && this.status.equals(o.status)) && (this.botInfoVersion == o.botInfoVersion || this.botInfoVersion != null && o.botInfoVersion != null && this.botInfoVersion.equals(o.botInfoVersion)) && (this.restrictionReason == o.restrictionReason || this.restrictionReason != null && o.restrictionReason != null && this.restrictionReason.equals(o.restrictionReason)) && (this.botInlinePlaceholder == o.botInlinePlaceholder || this.botInlinePlaceholder != null && o.botInlinePlaceholder != null && this.botInlinePlaceholder.equals(o.botInlinePlaceholder));
    }

    public boolean getSelf() {
        return this.self;
    }

    public void setSelf(boolean self) {
        this.self = self;
    }

    public boolean getContact() {
        return this.contact;
    }

    public void setContact(boolean contact) {
        this.contact = contact;
    }

    public boolean getMutualContact() {
        return this.mutualContact;
    }

    public void setMutualContact(boolean mutualContact) {
        this.mutualContact = mutualContact;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean getBot() {
        return this.bot;
    }

    public boolean getBotChatHistory() {
        return this.botChatHistory;
    }

    public void setBotChatHistory(boolean botChatHistory) {
        this.botChatHistory = botChatHistory;
    }

    public boolean getBotNochats() {
        return this.botNochats;
    }

    public void setBotNochats(boolean botNochats) {
        this.botNochats = botNochats;
    }

    public boolean getVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public boolean getRestricted() {
        return this.restricted;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public Long getAccessHash() {
        return this.accessHash;
    }

    public void setAccessHash(Long accessHash) {
        this.accessHash = accessHash;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public TLAbsUserProfilePhoto getPhoto() {
        return this.photo;
    }

    public void setPhoto(TLAbsUserProfilePhoto photo) {
        this.photo = photo;
    }

    public TLAbsUserStatus getStatus() {
        return this.status;
    }

    public void setStatus(TLAbsUserStatus status) {
        this.status = status;
    }

    public Integer getBotInfoVersion() {
        return this.botInfoVersion;
    }

    public void setBotInfoVersion(Integer botInfoVersion) {
        this.botInfoVersion = botInfoVersion;
    }

    public String getRestrictionReason() {
        return this.restrictionReason;
    }

    public void setRestrictionReason(String restrictionReason) {
        this.restrictionReason = restrictionReason;
    }

    public String getBotInlinePlaceholder() {
        return this.botInlinePlaceholder;
    }

    public void setBotInlinePlaceholder(String botInlinePlaceholder) {
        this.botInlinePlaceholder = botInlinePlaceholder;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public final boolean isNotEmpty() {
        return true;
    }

    @Override
    public final TLUser getAsUser() {
        return this;
    }
}

