/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsMessageEntity;
import com.github.badoualy.telegram.tl.api.TLAbsMessageMedia;
import com.github.badoualy.telegram.tl.api.TLAbsUpdates;
import com.github.badoualy.telegram.tl.core.TLVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLUpdateShortSentMessage
extends TLAbsUpdates {
    public static final int CONSTRUCTOR_ID = 301019932;
    protected int flags;
    protected boolean unread;
    protected boolean out;
    protected int id;
    protected int pts;
    protected int ptsCount;
    protected int date;
    protected TLAbsMessageMedia media;
    protected TLVector<TLAbsMessageEntity> entities;
    private final String _constructor = "updateShortSentMessage#11f1331c";

    public TLUpdateShortSentMessage() {
    }

    public TLUpdateShortSentMessage(boolean unread, boolean out, int id, int pts, int ptsCount, int date, TLAbsMessageMedia media, TLVector<TLAbsMessageEntity> entities) {
        this.unread = unread;
        this.out = out;
        this.id = id;
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.date = date;
        this.media = media;
        this.entities = entities;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.unread ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.out ? this.flags | 2 : this.flags & 0xFFFFFFFD;
        this.flags = this.media != null ? this.flags | 0x200 : this.flags & 0xFFFFFDFF;
        this.flags = this.entities != null ? this.flags | 0x80 : this.flags & 0xFFFFFF7F;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeInt(this.id, stream);
        StreamUtils.writeInt(this.pts, stream);
        StreamUtils.writeInt(this.ptsCount, stream);
        StreamUtils.writeInt(this.date, stream);
        if ((this.flags & 0x200) != 0) {
            StreamUtils.writeTLObject(this.media, stream);
        }
        if ((this.flags & 0x80) != 0) {
            StreamUtils.writeTLVector(this.entities, stream);
        }
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.unread = (this.flags & 1) != 0;
        this.out = (this.flags & 2) != 0;
        this.id = StreamUtils.readInt(stream);
        this.pts = StreamUtils.readInt(stream);
        this.ptsCount = StreamUtils.readInt(stream);
        this.date = StreamUtils.readInt(stream);
        this.media = (this.flags & 0x200) != 0 ? StreamUtils.readTLObject(stream, context, TLAbsMessageMedia.class, -1) : null;
        this.entities = (this.flags & 0x80) != 0 ? StreamUtils.readTLVector(stream, context) : null;
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        if ((this.flags & 0x200) != 0) {
            size += this.media.computeSerializedSize();
        }
        if ((this.flags & 0x80) != 0) {
            size += this.entities.computeSerializedSize();
        }
        return size;
    }

    public String toString() {
        return "updateShortSentMessage#11f1331c";
    }

    @Override
    public int getConstructorId() {
        return 301019932;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLUpdateShortSentMessage)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLUpdateShortSentMessage o = (TLUpdateShortSentMessage)object;
        return this.flags == o.flags && this.unread == o.unread && this.out == o.out && this.id == o.id && this.pts == o.pts && this.ptsCount == o.ptsCount && this.date == o.date && (this.media == o.media || this.media != null && o.media != null && this.media.equals(o.media)) && (this.entities == o.entities || this.entities != null && o.entities != null && this.entities.equals(o.entities));
    }

    public boolean getUnread() {
        return this.unread;
    }

    public void setUnread(boolean unread) {
        this.unread = unread;
    }

    public boolean getOut() {
        return this.out;
    }

    public void setOut(boolean out) {
        this.out = out;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getPts() {
        return this.pts;
    }

    public void setPts(int pts) {
        this.pts = pts;
    }

    public int getPtsCount() {
        return this.ptsCount;
    }

    public void setPtsCount(int ptsCount) {
        this.ptsCount = ptsCount;
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int date) {
        this.date = date;
    }

    public TLAbsMessageMedia getMedia() {
        return this.media;
    }

    public void setMedia(TLAbsMessageMedia media) {
        this.media = media;
    }

    public TLVector<TLAbsMessageEntity> getEntities() {
        return this.entities;
    }

    public void setEntities(TLVector<TLAbsMessageEntity> entities) {
        this.entities = entities;
    }
}

