/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsMessageEntity;
import com.github.badoualy.telegram.tl.api.TLAbsPeer;
import com.github.badoualy.telegram.tl.api.TLAbsUpdates;
import com.github.badoualy.telegram.tl.core.TLVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLUpdateShortChatMessage
extends TLAbsUpdates {
    public static final int CONSTRUCTOR_ID = 613087842;
    protected int flags;
    protected boolean unread;
    protected boolean out;
    protected boolean mentioned;
    protected boolean mediaUnread;
    protected int id;
    protected int fromId;
    protected int chatId;
    protected String message;
    protected int pts;
    protected int ptsCount;
    protected int date;
    protected TLAbsPeer fwdFromId;
    protected Integer fwdDate;
    protected Integer viaBotId;
    protected Integer replyToMsgId;
    protected TLVector<TLAbsMessageEntity> entities;
    private final String _constructor = "updateShortChatMessage#248afa62";

    public TLUpdateShortChatMessage() {
    }

    public TLUpdateShortChatMessage(boolean unread, boolean out, boolean mentioned, boolean mediaUnread, int id, int fromId, int chatId, String message, int pts, int ptsCount, int date, TLAbsPeer fwdFromId, Integer fwdDate, Integer viaBotId, Integer replyToMsgId, TLVector<TLAbsMessageEntity> entities) {
        this.unread = unread;
        this.out = out;
        this.mentioned = mentioned;
        this.mediaUnread = mediaUnread;
        this.id = id;
        this.fromId = fromId;
        this.chatId = chatId;
        this.message = message;
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.date = date;
        this.fwdFromId = fwdFromId;
        this.fwdDate = fwdDate;
        this.viaBotId = viaBotId;
        this.replyToMsgId = replyToMsgId;
        this.entities = entities;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.unread ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.out ? this.flags | 2 : this.flags & 0xFFFFFFFD;
        this.flags = this.mentioned ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
        this.flags = this.mediaUnread ? this.flags | 0x20 : this.flags & 0xFFFFFFDF;
        this.flags = this.fwdFromId != null ? this.flags | 4 : this.flags & 0xFFFFFFFB;
        this.flags = this.fwdDate != null ? this.flags | 4 : this.flags & 0xFFFFFFFB;
        this.flags = this.viaBotId != null ? this.flags | 0x800 : this.flags & 0xFFFFF7FF;
        this.flags = this.replyToMsgId != null ? this.flags | 8 : this.flags & 0xFFFFFFF7;
        this.flags = this.entities != null ? this.flags | 0x80 : this.flags & 0xFFFFFF7F;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeInt(this.id, stream);
        StreamUtils.writeInt(this.fromId, stream);
        StreamUtils.writeInt(this.chatId, stream);
        StreamUtils.writeString(this.message, stream);
        StreamUtils.writeInt(this.pts, stream);
        StreamUtils.writeInt(this.ptsCount, stream);
        StreamUtils.writeInt(this.date, stream);
        if ((this.flags & 4) != 0) {
            StreamUtils.writeTLObject(this.fwdFromId, stream);
        }
        if ((this.flags & 4) != 0) {
            StreamUtils.writeInt(this.fwdDate, stream);
        }
        if ((this.flags & 0x800) != 0) {
            StreamUtils.writeInt(this.viaBotId, stream);
        }
        if ((this.flags & 8) != 0) {
            StreamUtils.writeInt(this.replyToMsgId, stream);
        }
        if ((this.flags & 0x80) != 0) {
            StreamUtils.writeTLVector(this.entities, stream);
        }
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.unread = (this.flags & 1) != 0;
        this.out = (this.flags & 2) != 0;
        this.mentioned = (this.flags & 0x10) != 0;
        this.mediaUnread = (this.flags & 0x20) != 0;
        this.id = StreamUtils.readInt(stream);
        this.fromId = StreamUtils.readInt(stream);
        this.chatId = StreamUtils.readInt(stream);
        this.message = StreamUtils.readTLString(stream);
        this.pts = StreamUtils.readInt(stream);
        this.ptsCount = StreamUtils.readInt(stream);
        this.date = StreamUtils.readInt(stream);
        this.fwdFromId = (this.flags & 4) != 0 ? StreamUtils.readTLObject(stream, context, TLAbsPeer.class, -1) : null;
        this.fwdDate = (this.flags & 4) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.viaBotId = (this.flags & 0x800) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.replyToMsgId = (this.flags & 8) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.entities = (this.flags & 0x80) != 0 ? StreamUtils.readTLVector(stream, context) : null;
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.computeTLStringSerializedSize(this.message);
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        if ((this.flags & 4) != 0) {
            size += this.fwdFromId.computeSerializedSize();
        }
        if ((this.flags & 4) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        if ((this.flags & 0x800) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        if ((this.flags & 8) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        if ((this.flags & 0x80) != 0) {
            size += this.entities.computeSerializedSize();
        }
        return size;
    }

    public String toString() {
        return "updateShortChatMessage#248afa62";
    }

    @Override
    public int getConstructorId() {
        return 613087842;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLUpdateShortChatMessage)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLUpdateShortChatMessage o = (TLUpdateShortChatMessage)object;
        return this.flags == o.flags && this.unread == o.unread && this.out == o.out && this.mentioned == o.mentioned && this.mediaUnread == o.mediaUnread && this.id == o.id && this.fromId == o.fromId && this.chatId == o.chatId && (this.message == o.message || this.message != null && o.message != null && this.message.equals(o.message)) && this.pts == o.pts && this.ptsCount == o.ptsCount && this.date == o.date && (this.fwdFromId == o.fwdFromId || this.fwdFromId != null && o.fwdFromId != null && this.fwdFromId.equals(o.fwdFromId)) && (this.fwdDate == o.fwdDate || this.fwdDate != null && o.fwdDate != null && this.fwdDate.equals(o.fwdDate)) && (this.viaBotId == o.viaBotId || this.viaBotId != null && o.viaBotId != null && this.viaBotId.equals(o.viaBotId)) && (this.replyToMsgId == o.replyToMsgId || this.replyToMsgId != null && o.replyToMsgId != null && this.replyToMsgId.equals(o.replyToMsgId)) && (this.entities == o.entities || this.entities != null && o.entities != null && this.entities.equals(o.entities));
    }

    public boolean getUnread() {
        return this.unread;
    }

    public void setUnread(boolean unread) {
        this.unread = unread;
    }

    public boolean getOut() {
        return this.out;
    }

    public void setOut(boolean out) {
        this.out = out;
    }

    public boolean getMentioned() {
        return this.mentioned;
    }

    public void setMentioned(boolean mentioned) {
        this.mentioned = mentioned;
    }

    public boolean getMediaUnread() {
        return this.mediaUnread;
    }

    public void setMediaUnread(boolean mediaUnread) {
        this.mediaUnread = mediaUnread;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getFromId() {
        return this.fromId;
    }

    public void setFromId(int fromId) {
        this.fromId = fromId;
    }

    public int getChatId() {
        return this.chatId;
    }

    public void setChatId(int chatId) {
        this.chatId = chatId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getPts() {
        return this.pts;
    }

    public void setPts(int pts) {
        this.pts = pts;
    }

    public int getPtsCount() {
        return this.ptsCount;
    }

    public void setPtsCount(int ptsCount) {
        this.ptsCount = ptsCount;
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int date) {
        this.date = date;
    }

    public TLAbsPeer getFwdFromId() {
        return this.fwdFromId;
    }

    public void setFwdFromId(TLAbsPeer fwdFromId) {
        this.fwdFromId = fwdFromId;
    }

    public Integer getFwdDate() {
        return this.fwdDate;
    }

    public void setFwdDate(Integer fwdDate) {
        this.fwdDate = fwdDate;
    }

    public Integer getViaBotId() {
        return this.viaBotId;
    }

    public void setViaBotId(Integer viaBotId) {
        this.viaBotId = viaBotId;
    }

    public Integer getReplyToMsgId() {
        return this.replyToMsgId;
    }

    public void setReplyToMsgId(Integer replyToMsgId) {
        this.replyToMsgId = replyToMsgId;
    }

    public TLVector<TLAbsMessageEntity> getEntities() {
        return this.entities;
    }

    public void setEntities(TLVector<TLAbsMessageEntity> entities) {
        this.entities = entities;
    }
}

