/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLStickerSet
extends TLObject {
    public static final int CONSTRUCTOR_ID = -852477119;
    protected int flags;
    protected boolean installed;
    protected boolean disabled;
    protected boolean official;
    protected long id;
    protected long accessHash;
    protected String title;
    protected String shortName;
    protected int count;
    protected int hash;
    private final String _constructor = "stickerSet#cd303b41";

    public TLStickerSet() {
    }

    public TLStickerSet(boolean installed, boolean disabled, boolean official, long id, long accessHash, String title, String shortName, int count, int hash) {
        this.installed = installed;
        this.disabled = disabled;
        this.official = official;
        this.id = id;
        this.accessHash = accessHash;
        this.title = title;
        this.shortName = shortName;
        this.count = count;
        this.hash = hash;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.installed ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.disabled ? this.flags | 2 : this.flags & 0xFFFFFFFD;
        this.flags = this.official ? this.flags | 4 : this.flags & 0xFFFFFFFB;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeLong(this.id, stream);
        StreamUtils.writeLong(this.accessHash, stream);
        StreamUtils.writeString(this.title, stream);
        StreamUtils.writeString(this.shortName, stream);
        StreamUtils.writeInt(this.count, stream);
        StreamUtils.writeInt(this.hash, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.installed = (this.flags & 1) != 0;
        this.disabled = (this.flags & 2) != 0;
        this.official = (this.flags & 4) != 0;
        this.id = StreamUtils.readLong(stream);
        this.accessHash = StreamUtils.readLong(stream);
        this.title = StreamUtils.readTLString(stream);
        this.shortName = StreamUtils.readTLString(stream);
        this.count = StreamUtils.readInt(stream);
        this.hash = StreamUtils.readInt(stream);
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.computeTLStringSerializedSize(this.title);
        size += TLObjectUtils.computeTLStringSerializedSize(this.shortName);
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.SIZE_INT32;
    }

    public String toString() {
        return "stickerSet#cd303b41";
    }

    @Override
    public int getConstructorId() {
        return -852477119;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLStickerSet)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLStickerSet o = (TLStickerSet)object;
        return this.flags == o.flags && this.installed == o.installed && this.disabled == o.disabled && this.official == o.official && this.id == o.id && this.accessHash == o.accessHash && (this.title == o.title || this.title != null && o.title != null && this.title.equals(o.title)) && (this.shortName == o.shortName || this.shortName != null && o.shortName != null && this.shortName.equals(o.shortName)) && this.count == o.count && this.hash == o.hash;
    }

    public boolean getInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean getOfficial() {
        return this.official;
    }

    public void setOfficial(boolean official) {
        this.official = official;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getAccessHash() {
        return this.accessHash;
    }

    public void setAccessHash(long accessHash) {
        this.accessHash = accessHash;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getHash() {
        return this.hash;
    }

    public void setHash(int hash) {
        this.hash = hash;
    }
}

