/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsReplyMarkup;
import com.github.badoualy.telegram.tl.api.TLKeyboardButtonRow;
import com.github.badoualy.telegram.tl.core.TLVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLReplyKeyboardMarkup
extends TLAbsReplyMarkup {
    public static final int CONSTRUCTOR_ID = 889353612;
    protected boolean resize;
    protected boolean singleUse;
    protected TLVector<TLKeyboardButtonRow> rows;
    private final String _constructor = "replyKeyboardMarkup#3502758c";

    public TLReplyKeyboardMarkup() {
    }

    public TLReplyKeyboardMarkup(boolean resize, boolean singleUse, boolean selective, TLVector<TLKeyboardButtonRow> rows) {
        this.resize = resize;
        this.singleUse = singleUse;
        this.selective = selective;
        this.rows = rows;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.resize ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.singleUse ? this.flags | 2 : this.flags & 0xFFFFFFFD;
        this.flags = this.selective ? this.flags | 4 : this.flags & 0xFFFFFFFB;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeTLVector(this.rows, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.resize = (this.flags & 1) != 0;
        this.singleUse = (this.flags & 2) != 0;
        this.selective = (this.flags & 4) != 0;
        this.rows = StreamUtils.readTLVector(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        return size += this.rows.computeSerializedSize();
    }

    public String toString() {
        return "replyKeyboardMarkup#3502758c";
    }

    @Override
    public int getConstructorId() {
        return 889353612;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLReplyKeyboardMarkup)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLReplyKeyboardMarkup o = (TLReplyKeyboardMarkup)object;
        return this.flags == o.flags && this.resize == o.resize && this.singleUse == o.singleUse && this.selective == o.selective && (this.rows == o.rows || this.rows != null && o.rows != null && this.rows.equals(o.rows));
    }

    public boolean getResize() {
        return this.resize;
    }

    public void setResize(boolean resize) {
        this.resize = resize;
    }

    public boolean getSingleUse() {
        return this.singleUse;
    }

    public void setSingleUse(boolean singleUse) {
        this.singleUse = singleUse;
    }

    @Override
    public boolean getSelective() {
        return this.selective;
    }

    @Override
    public void setSelective(boolean selective) {
        this.selective = selective;
    }

    public TLVector<TLKeyboardButtonRow> getRows() {
        return this.rows;
    }

    public void setRows(TLVector<TLKeyboardButtonRow> rows) {
        this.rows = rows;
    }
}

