/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsFileLocation;
import com.github.badoualy.telegram.tl.api.TLAbsPhotoSize;
import com.github.badoualy.telegram.tl.core.TLBytes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLPhotoCachedSize
extends TLAbsPhotoSize {
    public static final int CONSTRUCTOR_ID = -374917894;
    protected TLAbsFileLocation location;
    protected int w;
    protected int h;
    protected TLBytes bytes;
    private final String _constructor = "photoCachedSize#e9a734fa";

    public TLPhotoCachedSize() {
    }

    public TLPhotoCachedSize(String type, TLAbsFileLocation location, int w, int h, TLBytes bytes) {
        this.type = type;
        this.location = location;
        this.w = w;
        this.h = h;
        this.bytes = bytes;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeString(this.type, stream);
        StreamUtils.writeTLObject(this.location, stream);
        StreamUtils.writeInt(this.w, stream);
        StreamUtils.writeInt(this.h, stream);
        StreamUtils.writeTLBytes(this.bytes, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.type = StreamUtils.readTLString(stream);
        this.location = StreamUtils.readTLObject(stream, context, TLAbsFileLocation.class, -1);
        this.w = StreamUtils.readInt(stream);
        this.h = StreamUtils.readInt(stream);
        this.bytes = StreamUtils.readTLBytes(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.computeTLStringSerializedSize(this.type);
        size += this.location.computeSerializedSize();
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.computeTLBytesSerializedSize(this.bytes);
    }

    public String toString() {
        return "photoCachedSize#e9a734fa";
    }

    @Override
    public int getConstructorId() {
        return -374917894;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLPhotoCachedSize)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLPhotoCachedSize o = (TLPhotoCachedSize)object;
        return (this.type == o.type || this.type != null && o.type != null && this.type.equals(o.type)) && (this.location == o.location || this.location != null && o.location != null && this.location.equals(o.location)) && this.w == o.w && this.h == o.h && (this.bytes == o.bytes || this.bytes != null && o.bytes != null && this.bytes.equals(o.bytes));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public TLAbsFileLocation getLocation() {
        return this.location;
    }

    public void setLocation(TLAbsFileLocation location) {
        this.location = location;
    }

    public int getW() {
        return this.w;
    }

    public void setW(int w) {
        this.w = w;
    }

    public int getH() {
        return this.h;
    }

    public void setH(int h) {
        this.h = h;
    }

    public TLBytes getBytes() {
        return this.bytes;
    }

    public void setBytes(TLBytes bytes) {
        this.bytes = bytes;
    }
}

