/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsPhoto;
import com.github.badoualy.telegram.tl.api.TLAbsPhotoSize;
import com.github.badoualy.telegram.tl.core.TLVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLPhoto
extends TLAbsPhoto {
    public static final int CONSTRUCTOR_ID = -840088834;
    protected long accessHash;
    protected int date;
    protected TLVector<TLAbsPhotoSize> sizes;
    private final String _constructor = "photo#cded42fe";

    public TLPhoto() {
    }

    public TLPhoto(long id, long accessHash, int date, TLVector<TLAbsPhotoSize> sizes) {
        this.id = id;
        this.accessHash = accessHash;
        this.date = date;
        this.sizes = sizes;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeLong(this.id, stream);
        StreamUtils.writeLong(this.accessHash, stream);
        StreamUtils.writeInt(this.date, stream);
        StreamUtils.writeTLVector(this.sizes, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.id = StreamUtils.readLong(stream);
        this.accessHash = StreamUtils.readLong(stream);
        this.date = StreamUtils.readInt(stream);
        this.sizes = StreamUtils.readTLVector(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT32;
        return size += this.sizes.computeSerializedSize();
    }

    public String toString() {
        return "photo#cded42fe";
    }

    @Override
    public int getConstructorId() {
        return -840088834;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLPhoto)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLPhoto o = (TLPhoto)object;
        return this.id == o.id && this.accessHash == o.accessHash && this.date == o.date && (this.sizes == o.sizes || this.sizes != null && o.sizes != null && this.sizes.equals(o.sizes));
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public long getAccessHash() {
        return this.accessHash;
    }

    public void setAccessHash(long accessHash) {
        this.accessHash = accessHash;
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int date) {
        this.date = date;
    }

    public TLVector<TLAbsPhotoSize> getSizes() {
        return this.sizes;
    }

    public void setSizes(TLVector<TLAbsPhotoSize> sizes) {
        this.sizes = sizes;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public final boolean isNotEmpty() {
        return true;
    }

    @Override
    public final TLPhoto getAsPhoto() {
        return this;
    }
}

