/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsMessage;
import com.github.badoualy.telegram.tl.api.TLAbsMessageAction;
import com.github.badoualy.telegram.tl.api.TLAbsPeer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLMessageService
extends TLAbsMessage {
    public static final int CONSTRUCTOR_ID = -1066691065;
    protected int flags;
    protected boolean unread;
    protected boolean out;
    protected boolean mentioned;
    protected boolean mediaUnread;
    protected Integer fromId;
    protected TLAbsPeer toId;
    protected int date;
    protected TLAbsMessageAction action;
    private final String _constructor = "messageService#c06b9607";

    public TLMessageService() {
    }

    public TLMessageService(boolean unread, boolean out, boolean mentioned, boolean mediaUnread, int id, Integer fromId, TLAbsPeer toId, int date, TLAbsMessageAction action) {
        this.unread = unread;
        this.out = out;
        this.mentioned = mentioned;
        this.mediaUnread = mediaUnread;
        this.id = id;
        this.fromId = fromId;
        this.toId = toId;
        this.date = date;
        this.action = action;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.unread ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.out ? this.flags | 2 : this.flags & 0xFFFFFFFD;
        this.flags = this.mentioned ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
        this.flags = this.mediaUnread ? this.flags | 0x20 : this.flags & 0xFFFFFFDF;
        this.flags = this.fromId != null ? this.flags | 0x100 : this.flags & 0xFFFFFEFF;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeInt(this.id, stream);
        if ((this.flags & 0x100) != 0) {
            StreamUtils.writeInt(this.fromId, stream);
        }
        StreamUtils.writeTLObject(this.toId, stream);
        StreamUtils.writeInt(this.date, stream);
        StreamUtils.writeTLObject(this.action, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.unread = (this.flags & 1) != 0;
        this.out = (this.flags & 2) != 0;
        this.mentioned = (this.flags & 0x10) != 0;
        this.mediaUnread = (this.flags & 0x20) != 0;
        this.id = StreamUtils.readInt(stream);
        this.fromId = (this.flags & 0x100) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.toId = StreamUtils.readTLObject(stream, context, TLAbsPeer.class, -1);
        this.date = StreamUtils.readInt(stream);
        this.action = StreamUtils.readTLObject(stream, context, TLAbsMessageAction.class, -1);
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        if ((this.flags & 0x100) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        size += this.toId.computeSerializedSize();
        size += TLObjectUtils.SIZE_INT32;
        return size += this.action.computeSerializedSize();
    }

    public String toString() {
        return "messageService#c06b9607";
    }

    @Override
    public int getConstructorId() {
        return -1066691065;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLMessageService)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLMessageService o = (TLMessageService)object;
        return this.flags == o.flags && this.unread == o.unread && this.out == o.out && this.mentioned == o.mentioned && this.mediaUnread == o.mediaUnread && this.id == o.id && (this.fromId == o.fromId || this.fromId != null && o.fromId != null && this.fromId.equals(o.fromId)) && (this.toId == o.toId || this.toId != null && o.toId != null && this.toId.equals(o.toId)) && this.date == o.date && (this.action == o.action || this.action != null && o.action != null && this.action.equals(o.action));
    }

    public boolean getUnread() {
        return this.unread;
    }

    public void setUnread(boolean unread) {
        this.unread = unread;
    }

    public boolean getOut() {
        return this.out;
    }

    public void setOut(boolean out) {
        this.out = out;
    }

    public boolean getMentioned() {
        return this.mentioned;
    }

    public void setMentioned(boolean mentioned) {
        this.mentioned = mentioned;
    }

    public boolean getMediaUnread() {
        return this.mediaUnread;
    }

    public void setMediaUnread(boolean mediaUnread) {
        this.mediaUnread = mediaUnread;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public Integer getFromId() {
        return this.fromId;
    }

    public void setFromId(Integer fromId) {
        this.fromId = fromId;
    }

    public TLAbsPeer getToId() {
        return this.toId;
    }

    public void setToId(TLAbsPeer toId) {
        this.toId = toId;
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int date) {
        this.date = date;
    }

    public TLAbsMessageAction getAction() {
        return this.action;
    }

    public void setAction(TLAbsMessageAction action) {
        this.action = action;
    }
}

