/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLMessageRange
extends TLObject {
    public static final int CONSTRUCTOR_ID = 182649427;
    protected int minId;
    protected int maxId;
    private final String _constructor = "messageRange#ae30253";

    public TLMessageRange() {
    }

    public TLMessageRange(int minId, int maxId) {
        this.minId = minId;
        this.maxId = maxId;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeInt(this.minId, stream);
        StreamUtils.writeInt(this.maxId, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.minId = StreamUtils.readInt(stream);
        this.maxId = StreamUtils.readInt(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.SIZE_INT32;
    }

    public String toString() {
        return "messageRange#ae30253";
    }

    @Override
    public int getConstructorId() {
        return 182649427;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLMessageRange)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLMessageRange o = (TLMessageRange)object;
        return this.minId == o.minId && this.maxId == o.maxId;
    }

    public int getMinId() {
        return this.minId;
    }

    public void setMinId(int minId) {
        this.minId = minId;
    }

    public int getMaxId() {
        return this.maxId;
    }

    public void setMaxId(int maxId) {
        this.maxId = maxId;
    }
}

