/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsDocument;
import com.github.badoualy.telegram.tl.api.TLAbsMessageMedia;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLMessageMediaDocument
extends TLAbsMessageMedia {
    public static final int CONSTRUCTOR_ID = -203411800;
    protected TLAbsDocument document;
    protected String caption;
    private final String _constructor = "messageMediaDocument#f3e02ea8";

    public TLMessageMediaDocument() {
    }

    public TLMessageMediaDocument(TLAbsDocument document, String caption) {
        this.document = document;
        this.caption = caption;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeTLObject(this.document, stream);
        StreamUtils.writeString(this.caption, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.document = StreamUtils.readTLObject(stream, context, TLAbsDocument.class, -1);
        this.caption = StreamUtils.readTLString(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += this.document.computeSerializedSize();
        return size += TLObjectUtils.computeTLStringSerializedSize(this.caption);
    }

    public String toString() {
        return "messageMediaDocument#f3e02ea8";
    }

    @Override
    public int getConstructorId() {
        return -203411800;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLMessageMediaDocument)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLMessageMediaDocument o = (TLMessageMediaDocument)object;
        return (this.document == o.document || this.document != null && o.document != null && this.document.equals(o.document)) && (this.caption == o.caption || this.caption != null && o.caption != null && this.caption.equals(o.caption));
    }

    public TLAbsDocument getDocument() {
        return this.document;
    }

    public void setDocument(TLAbsDocument document) {
        this.document = document;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }
}

