/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsMessage;
import com.github.badoualy.telegram.tl.api.TLAbsMessageEntity;
import com.github.badoualy.telegram.tl.api.TLAbsMessageMedia;
import com.github.badoualy.telegram.tl.api.TLAbsPeer;
import com.github.badoualy.telegram.tl.api.TLAbsReplyMarkup;
import com.github.badoualy.telegram.tl.core.TLVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLMessage
extends TLAbsMessage {
    public static final int CONSTRUCTOR_ID = -913120932;
    protected int flags;
    protected boolean unread;
    protected boolean out;
    protected boolean mentioned;
    protected boolean mediaUnread;
    protected Integer fromId;
    protected TLAbsPeer toId;
    protected TLAbsPeer fwdFromId;
    protected Integer fwdDate;
    protected Integer viaBotId;
    protected Integer replyToMsgId;
    protected int date;
    protected String message;
    protected TLAbsMessageMedia media;
    protected TLAbsReplyMarkup replyMarkup;
    protected TLVector<TLAbsMessageEntity> entities;
    protected Integer views;
    private final String _constructor = "message#c992e15c";

    public TLMessage() {
    }

    public TLMessage(boolean unread, boolean out, boolean mentioned, boolean mediaUnread, int id, Integer fromId, TLAbsPeer toId, TLAbsPeer fwdFromId, Integer fwdDate, Integer viaBotId, Integer replyToMsgId, int date, String message, TLAbsMessageMedia media, TLAbsReplyMarkup replyMarkup, TLVector<TLAbsMessageEntity> entities, Integer views) {
        this.unread = unread;
        this.out = out;
        this.mentioned = mentioned;
        this.mediaUnread = mediaUnread;
        this.id = id;
        this.fromId = fromId;
        this.toId = toId;
        this.fwdFromId = fwdFromId;
        this.fwdDate = fwdDate;
        this.viaBotId = viaBotId;
        this.replyToMsgId = replyToMsgId;
        this.date = date;
        this.message = message;
        this.media = media;
        this.replyMarkup = replyMarkup;
        this.entities = entities;
        this.views = views;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.unread ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.out ? this.flags | 2 : this.flags & 0xFFFFFFFD;
        this.flags = this.mentioned ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
        this.flags = this.mediaUnread ? this.flags | 0x20 : this.flags & 0xFFFFFFDF;
        this.flags = this.fromId != null ? this.flags | 0x100 : this.flags & 0xFFFFFEFF;
        this.flags = this.fwdFromId != null ? this.flags | 4 : this.flags & 0xFFFFFFFB;
        this.flags = this.fwdDate != null ? this.flags | 4 : this.flags & 0xFFFFFFFB;
        this.flags = this.viaBotId != null ? this.flags | 0x800 : this.flags & 0xFFFFF7FF;
        this.flags = this.replyToMsgId != null ? this.flags | 8 : this.flags & 0xFFFFFFF7;
        this.flags = this.media != null ? this.flags | 0x200 : this.flags & 0xFFFFFDFF;
        this.flags = this.replyMarkup != null ? this.flags | 0x40 : this.flags & 0xFFFFFFBF;
        this.flags = this.entities != null ? this.flags | 0x80 : this.flags & 0xFFFFFF7F;
        this.flags = this.views != null ? this.flags | 0x400 : this.flags & 0xFFFFFBFF;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeInt(this.id, stream);
        if ((this.flags & 0x100) != 0) {
            StreamUtils.writeInt(this.fromId, stream);
        }
        StreamUtils.writeTLObject(this.toId, stream);
        if ((this.flags & 4) != 0) {
            StreamUtils.writeTLObject(this.fwdFromId, stream);
        }
        if ((this.flags & 4) != 0) {
            StreamUtils.writeInt(this.fwdDate, stream);
        }
        if ((this.flags & 0x800) != 0) {
            StreamUtils.writeInt(this.viaBotId, stream);
        }
        if ((this.flags & 8) != 0) {
            StreamUtils.writeInt(this.replyToMsgId, stream);
        }
        StreamUtils.writeInt(this.date, stream);
        StreamUtils.writeString(this.message, stream);
        if ((this.flags & 0x200) != 0) {
            StreamUtils.writeTLObject(this.media, stream);
        }
        if ((this.flags & 0x40) != 0) {
            StreamUtils.writeTLObject(this.replyMarkup, stream);
        }
        if ((this.flags & 0x80) != 0) {
            StreamUtils.writeTLVector(this.entities, stream);
        }
        if ((this.flags & 0x400) != 0) {
            StreamUtils.writeInt(this.views, stream);
        }
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.unread = (this.flags & 1) != 0;
        this.out = (this.flags & 2) != 0;
        this.mentioned = (this.flags & 0x10) != 0;
        this.mediaUnread = (this.flags & 0x20) != 0;
        this.id = StreamUtils.readInt(stream);
        this.fromId = (this.flags & 0x100) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.toId = StreamUtils.readTLObject(stream, context, TLAbsPeer.class, -1);
        this.fwdFromId = (this.flags & 4) != 0 ? StreamUtils.readTLObject(stream, context, TLAbsPeer.class, -1) : null;
        this.fwdDate = (this.flags & 4) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.viaBotId = (this.flags & 0x800) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.replyToMsgId = (this.flags & 8) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.date = StreamUtils.readInt(stream);
        this.message = StreamUtils.readTLString(stream);
        this.media = (this.flags & 0x200) != 0 ? StreamUtils.readTLObject(stream, context, TLAbsMessageMedia.class, -1) : null;
        this.replyMarkup = (this.flags & 0x40) != 0 ? StreamUtils.readTLObject(stream, context, TLAbsReplyMarkup.class, -1) : null;
        this.entities = (this.flags & 0x80) != 0 ? StreamUtils.readTLVector(stream, context) : null;
        this.views = (this.flags & 0x400) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        if ((this.flags & 0x100) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        size += this.toId.computeSerializedSize();
        if ((this.flags & 4) != 0) {
            size += this.fwdFromId.computeSerializedSize();
        }
        if ((this.flags & 4) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        if ((this.flags & 0x800) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        if ((this.flags & 8) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.computeTLStringSerializedSize(this.message);
        if ((this.flags & 0x200) != 0) {
            size += this.media.computeSerializedSize();
        }
        if ((this.flags & 0x40) != 0) {
            size += this.replyMarkup.computeSerializedSize();
        }
        if ((this.flags & 0x80) != 0) {
            size += this.entities.computeSerializedSize();
        }
        if ((this.flags & 0x400) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        return size;
    }

    public String toString() {
        return "message#c992e15c";
    }

    @Override
    public int getConstructorId() {
        return -913120932;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLMessage)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLMessage o = (TLMessage)object;
        return this.flags == o.flags && this.unread == o.unread && this.out == o.out && this.mentioned == o.mentioned && this.mediaUnread == o.mediaUnread && this.id == o.id && (this.fromId == o.fromId || this.fromId != null && o.fromId != null && this.fromId.equals(o.fromId)) && (this.toId == o.toId || this.toId != null && o.toId != null && this.toId.equals(o.toId)) && (this.fwdFromId == o.fwdFromId || this.fwdFromId != null && o.fwdFromId != null && this.fwdFromId.equals(o.fwdFromId)) && (this.fwdDate == o.fwdDate || this.fwdDate != null && o.fwdDate != null && this.fwdDate.equals(o.fwdDate)) && (this.viaBotId == o.viaBotId || this.viaBotId != null && o.viaBotId != null && this.viaBotId.equals(o.viaBotId)) && (this.replyToMsgId == o.replyToMsgId || this.replyToMsgId != null && o.replyToMsgId != null && this.replyToMsgId.equals(o.replyToMsgId)) && this.date == o.date && (this.message == o.message || this.message != null && o.message != null && this.message.equals(o.message)) && (this.media == o.media || this.media != null && o.media != null && this.media.equals(o.media)) && (this.replyMarkup == o.replyMarkup || this.replyMarkup != null && o.replyMarkup != null && this.replyMarkup.equals(o.replyMarkup)) && (this.entities == o.entities || this.entities != null && o.entities != null && this.entities.equals(o.entities)) && (this.views == o.views || this.views != null && o.views != null && this.views.equals(o.views));
    }

    public boolean getUnread() {
        return this.unread;
    }

    public void setUnread(boolean unread) {
        this.unread = unread;
    }

    public boolean getOut() {
        return this.out;
    }

    public void setOut(boolean out) {
        this.out = out;
    }

    public boolean getMentioned() {
        return this.mentioned;
    }

    public void setMentioned(boolean mentioned) {
        this.mentioned = mentioned;
    }

    public boolean getMediaUnread() {
        return this.mediaUnread;
    }

    public void setMediaUnread(boolean mediaUnread) {
        this.mediaUnread = mediaUnread;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public Integer getFromId() {
        return this.fromId;
    }

    public void setFromId(Integer fromId) {
        this.fromId = fromId;
    }

    public TLAbsPeer getToId() {
        return this.toId;
    }

    public void setToId(TLAbsPeer toId) {
        this.toId = toId;
    }

    public TLAbsPeer getFwdFromId() {
        return this.fwdFromId;
    }

    public void setFwdFromId(TLAbsPeer fwdFromId) {
        this.fwdFromId = fwdFromId;
    }

    public Integer getFwdDate() {
        return this.fwdDate;
    }

    public void setFwdDate(Integer fwdDate) {
        this.fwdDate = fwdDate;
    }

    public Integer getViaBotId() {
        return this.viaBotId;
    }

    public void setViaBotId(Integer viaBotId) {
        this.viaBotId = viaBotId;
    }

    public Integer getReplyToMsgId() {
        return this.replyToMsgId;
    }

    public void setReplyToMsgId(Integer replyToMsgId) {
        this.replyToMsgId = replyToMsgId;
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int date) {
        this.date = date;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public TLAbsMessageMedia getMedia() {
        return this.media;
    }

    public void setMedia(TLAbsMessageMedia media) {
        this.media = media;
    }

    public TLAbsReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public void setReplyMarkup(TLAbsReplyMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    public TLVector<TLAbsMessageEntity> getEntities() {
        return this.entities;
    }

    public void setEntities(TLVector<TLAbsMessageEntity> entities) {
        this.entities = entities;
    }

    public Integer getViews() {
        return this.views;
    }

    public void setViews(Integer views) {
        this.views = views;
    }
}

