/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsInputPeer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLInputPeerChannel
extends TLAbsInputPeer {
    public static final int CONSTRUCTOR_ID = 548253432;
    protected int channelId;
    protected long accessHash;
    private final String _constructor = "inputPeerChannel#20adaef8";

    public TLInputPeerChannel() {
    }

    public TLInputPeerChannel(int channelId, long accessHash) {
        this.channelId = channelId;
        this.accessHash = accessHash;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeInt(this.channelId, stream);
        StreamUtils.writeLong(this.accessHash, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.channelId = StreamUtils.readInt(stream);
        this.accessHash = StreamUtils.readLong(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.SIZE_INT64;
    }

    public String toString() {
        return "inputPeerChannel#20adaef8";
    }

    @Override
    public int getConstructorId() {
        return 548253432;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLInputPeerChannel)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLInputPeerChannel o = (TLInputPeerChannel)object;
        return this.channelId == o.channelId && this.accessHash == o.accessHash;
    }

    public int getChannelId() {
        return this.channelId;
    }

    public void setChannelId(int channelId) {
        this.channelId = channelId;
    }

    public long getAccessHash() {
        return this.accessHash;
    }

    public void setAccessHash(long accessHash) {
        this.accessHash = accessHash;
    }
}

