/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsDocumentAttribute;
import com.github.badoualy.telegram.tl.api.TLAbsInputFile;
import com.github.badoualy.telegram.tl.api.TLAbsInputMedia;
import com.github.badoualy.telegram.tl.core.TLVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLInputMediaUploadedDocument
extends TLAbsInputMedia {
    public static final int CONSTRUCTOR_ID = 495530093;
    protected TLAbsInputFile file;
    protected String mimeType;
    protected TLVector<TLAbsDocumentAttribute> attributes;
    protected String caption;
    private final String _constructor = "inputMediaUploadedDocument#1d89306d";

    public TLInputMediaUploadedDocument() {
    }

    public TLInputMediaUploadedDocument(TLAbsInputFile file, String mimeType, TLVector<TLAbsDocumentAttribute> attributes, String caption) {
        this.file = file;
        this.mimeType = mimeType;
        this.attributes = attributes;
        this.caption = caption;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeTLObject(this.file, stream);
        StreamUtils.writeString(this.mimeType, stream);
        StreamUtils.writeTLVector(this.attributes, stream);
        StreamUtils.writeString(this.caption, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.file = StreamUtils.readTLObject(stream, context, TLAbsInputFile.class, -1);
        this.mimeType = StreamUtils.readTLString(stream);
        this.attributes = StreamUtils.readTLVector(stream, context);
        this.caption = StreamUtils.readTLString(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += this.file.computeSerializedSize();
        size += TLObjectUtils.computeTLStringSerializedSize(this.mimeType);
        size += this.attributes.computeSerializedSize();
        return size += TLObjectUtils.computeTLStringSerializedSize(this.caption);
    }

    public String toString() {
        return "inputMediaUploadedDocument#1d89306d";
    }

    @Override
    public int getConstructorId() {
        return 495530093;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLInputMediaUploadedDocument)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLInputMediaUploadedDocument o = (TLInputMediaUploadedDocument)object;
        return (this.file == o.file || this.file != null && o.file != null && this.file.equals(o.file)) && (this.mimeType == o.mimeType || this.mimeType != null && o.mimeType != null && this.mimeType.equals(o.mimeType)) && (this.attributes == o.attributes || this.attributes != null && o.attributes != null && this.attributes.equals(o.attributes)) && (this.caption == o.caption || this.caption != null && o.caption != null && this.caption.equals(o.caption));
    }

    public TLAbsInputFile getFile() {
        return this.file;
    }

    public void setFile(TLAbsInputFile file) {
        this.file = file;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public TLVector<TLAbsDocumentAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(TLVector<TLAbsDocumentAttribute> attributes) {
        this.attributes = attributes;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }
}

