/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsInputDocument;
import com.github.badoualy.telegram.tl.api.TLAbsInputMedia;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLInputMediaDocument
extends TLAbsInputMedia {
    public static final int CONSTRUCTOR_ID = 444068508;
    protected TLAbsInputDocument id;
    protected String caption;
    private final String _constructor = "inputMediaDocument#1a77f29c";

    public TLInputMediaDocument() {
    }

    public TLInputMediaDocument(TLAbsInputDocument id, String caption) {
        this.id = id;
        this.caption = caption;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeTLObject(this.id, stream);
        StreamUtils.writeString(this.caption, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.id = StreamUtils.readTLObject(stream, context, TLAbsInputDocument.class, -1);
        this.caption = StreamUtils.readTLString(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += this.id.computeSerializedSize();
        return size += TLObjectUtils.computeTLStringSerializedSize(this.caption);
    }

    public String toString() {
        return "inputMediaDocument#1a77f29c";
    }

    @Override
    public int getConstructorId() {
        return 444068508;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLInputMediaDocument)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLInputMediaDocument o = (TLInputMediaDocument)object;
        return (this.id == o.id || this.id != null && o.id != null && this.id.equals(o.id)) && (this.caption == o.caption || this.caption != null && o.caption != null && this.caption.equals(o.caption));
    }

    public TLAbsInputDocument getId() {
        return this.id;
    }

    public void setId(TLAbsInputDocument id) {
        this.id = id;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }
}

