/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsInputFileLocation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLInputFileLocation
extends TLAbsInputFileLocation {
    public static final int CONSTRUCTOR_ID = 342061462;
    protected long volumeId;
    protected int localId;
    protected long secret;
    private final String _constructor = "inputFileLocation#14637196";

    public TLInputFileLocation() {
    }

    public TLInputFileLocation(long volumeId, int localId, long secret) {
        this.volumeId = volumeId;
        this.localId = localId;
        this.secret = secret;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeLong(this.volumeId, stream);
        StreamUtils.writeInt(this.localId, stream);
        StreamUtils.writeLong(this.secret, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.volumeId = StreamUtils.readLong(stream);
        this.localId = StreamUtils.readInt(stream);
        this.secret = StreamUtils.readLong(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.SIZE_INT64;
    }

    public String toString() {
        return "inputFileLocation#14637196";
    }

    @Override
    public int getConstructorId() {
        return 342061462;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLInputFileLocation)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLInputFileLocation o = (TLInputFileLocation)object;
        return this.volumeId == o.volumeId && this.localId == o.localId && this.secret == o.secret;
    }

    public long getVolumeId() {
        return this.volumeId;
    }

    public void setVolumeId(long volumeId) {
        this.volumeId = volumeId;
    }

    public int getLocalId() {
        return this.localId;
    }

    public void setLocalId(int localId) {
        this.localId = localId;
    }

    public long getSecret() {
        return this.secret;
    }

    public void setSecret(long secret) {
        this.secret = secret;
    }
}

