/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsInputFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLInputFileBig
extends TLAbsInputFile {
    public static final int CONSTRUCTOR_ID = -95482955;
    private final String _constructor = "inputFileBig#fa4f0bb5";

    public TLInputFileBig() {
    }

    public TLInputFileBig(long id, int parts, String name) {
        this.id = id;
        this.parts = parts;
        this.name = name;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeLong(this.id, stream);
        StreamUtils.writeInt(this.parts, stream);
        StreamUtils.writeString(this.name, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.id = StreamUtils.readLong(stream);
        this.parts = StreamUtils.readInt(stream);
        this.name = StreamUtils.readTLString(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.computeTLStringSerializedSize(this.name);
    }

    public String toString() {
        return "inputFileBig#fa4f0bb5";
    }

    @Override
    public int getConstructorId() {
        return -95482955;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLInputFileBig)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLInputFileBig o = (TLInputFileBig)object;
        return this.id == o.id && this.parts == o.parts && (this.name == o.name || this.name != null && o.name != null && this.name.equals(o.name));
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public int getParts() {
        return this.parts;
    }

    @Override
    public void setParts(int parts) {
        this.parts = parts;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

