/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsInputFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLInputFile
extends TLAbsInputFile {
    public static final int CONSTRUCTOR_ID = -181407105;
    protected String md5Checksum;
    private final String _constructor = "inputFile#f52ff27f";

    public TLInputFile() {
    }

    public TLInputFile(long id, int parts, String name, String md5Checksum) {
        this.id = id;
        this.parts = parts;
        this.name = name;
        this.md5Checksum = md5Checksum;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeLong(this.id, stream);
        StreamUtils.writeInt(this.parts, stream);
        StreamUtils.writeString(this.name, stream);
        StreamUtils.writeString(this.md5Checksum, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.id = StreamUtils.readLong(stream);
        this.parts = StreamUtils.readInt(stream);
        this.name = StreamUtils.readTLString(stream);
        this.md5Checksum = StreamUtils.readTLString(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.computeTLStringSerializedSize(this.name);
        return size += TLObjectUtils.computeTLStringSerializedSize(this.md5Checksum);
    }

    public String toString() {
        return "inputFile#f52ff27f";
    }

    @Override
    public int getConstructorId() {
        return -181407105;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLInputFile)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLInputFile o = (TLInputFile)object;
        return this.id == o.id && this.parts == o.parts && (this.name == o.name || this.name != null && o.name != null && this.name.equals(o.name)) && (this.md5Checksum == o.md5Checksum || this.md5Checksum != null && o.md5Checksum != null && this.md5Checksum.equals(o.md5Checksum));
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public int getParts() {
        return this.parts;
    }

    @Override
    public void setParts(int parts) {
        this.parts = parts;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getMd5Checksum() {
        return this.md5Checksum;
    }

    public void setMd5Checksum(String md5Checksum) {
        this.md5Checksum = md5Checksum;
    }
}

