/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsInputEncryptedFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLInputEncryptedFileUploaded
extends TLAbsInputEncryptedFile {
    public static final int CONSTRUCTOR_ID = 1690108678;
    protected long id;
    protected int parts;
    protected String md5Checksum;
    protected int keyFingerprint;
    private final String _constructor = "inputEncryptedFileUploaded#64bd0306";

    public TLInputEncryptedFileUploaded() {
    }

    public TLInputEncryptedFileUploaded(long id, int parts, String md5Checksum, int keyFingerprint) {
        this.id = id;
        this.parts = parts;
        this.md5Checksum = md5Checksum;
        this.keyFingerprint = keyFingerprint;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeLong(this.id, stream);
        StreamUtils.writeInt(this.parts, stream);
        StreamUtils.writeString(this.md5Checksum, stream);
        StreamUtils.writeInt(this.keyFingerprint, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.id = StreamUtils.readLong(stream);
        this.parts = StreamUtils.readInt(stream);
        this.md5Checksum = StreamUtils.readTLString(stream);
        this.keyFingerprint = StreamUtils.readInt(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.computeTLStringSerializedSize(this.md5Checksum);
        return size += TLObjectUtils.SIZE_INT32;
    }

    public String toString() {
        return "inputEncryptedFileUploaded#64bd0306";
    }

    @Override
    public int getConstructorId() {
        return 1690108678;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLInputEncryptedFileUploaded)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLInputEncryptedFileUploaded o = (TLInputEncryptedFileUploaded)object;
        return this.id == o.id && this.parts == o.parts && (this.md5Checksum == o.md5Checksum || this.md5Checksum != null && o.md5Checksum != null && this.md5Checksum.equals(o.md5Checksum)) && this.keyFingerprint == o.keyFingerprint;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getParts() {
        return this.parts;
    }

    public void setParts(int parts) {
        this.parts = parts;
    }

    public String getMd5Checksum() {
        return this.md5Checksum;
    }

    public void setMd5Checksum(String md5Checksum) {
        this.md5Checksum = md5Checksum;
    }

    public int getKeyFingerprint() {
        return this.keyFingerprint;
    }

    public void setKeyFingerprint(int keyFingerprint) {
        this.keyFingerprint = keyFingerprint;
    }
}

