/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsInputFileLocation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLInputDocumentFileLocation
extends TLAbsInputFileLocation {
    public static final int CONSTRUCTOR_ID = 1313188841;
    protected long id;
    protected long accessHash;
    private final String _constructor = "inputDocumentFileLocation#4e45abe9";

    public TLInputDocumentFileLocation() {
    }

    public TLInputDocumentFileLocation(long id, long accessHash) {
        this.id = id;
        this.accessHash = accessHash;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeLong(this.id, stream);
        StreamUtils.writeLong(this.accessHash, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.id = StreamUtils.readLong(stream);
        this.accessHash = StreamUtils.readLong(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT64;
        return size += TLObjectUtils.SIZE_INT64;
    }

    public String toString() {
        return "inputDocumentFileLocation#4e45abe9";
    }

    @Override
    public int getConstructorId() {
        return 1313188841;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLInputDocumentFileLocation)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLInputDocumentFileLocation o = (TLInputDocumentFileLocation)object;
        return this.id == o.id && this.accessHash == o.accessHash;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getAccessHash() {
        return this.accessHash;
    }

    public void setAccessHash(long accessHash) {
        this.accessHash = accessHash;
    }
}

