/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLInputAppEvent
extends TLObject {
    public static final int CONSTRUCTOR_ID = 1996904104;
    protected double time;
    protected String type;
    protected long peer;
    protected String data;
    private final String _constructor = "inputAppEvent#770656a8";

    public TLInputAppEvent() {
    }

    public TLInputAppEvent(double time, String type, long peer, String data) {
        this.time = time;
        this.type = type;
        this.peer = peer;
        this.data = data;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeDouble(this.time, stream);
        StreamUtils.writeString(this.type, stream);
        StreamUtils.writeLong(this.peer, stream);
        StreamUtils.writeString(this.data, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.time = StreamUtils.readDouble(stream);
        this.type = StreamUtils.readTLString(stream);
        this.peer = StreamUtils.readLong(stream);
        this.data = StreamUtils.readTLString(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_DOUBLE;
        size += TLObjectUtils.computeTLStringSerializedSize(this.type);
        size += TLObjectUtils.SIZE_INT64;
        return size += TLObjectUtils.computeTLStringSerializedSize(this.data);
    }

    public String toString() {
        return "inputAppEvent#770656a8";
    }

    @Override
    public int getConstructorId() {
        return 1996904104;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLInputAppEvent)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLInputAppEvent o = (TLInputAppEvent)object;
        return this.time == o.time && (this.type == o.type || this.type != null && o.type != null && this.type.equals(o.type)) && this.peer == o.peer && (this.data == o.data || this.data != null && o.data != null && this.data.equals(o.data));
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double time) {
        this.time = time;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public long getPeer() {
        return this.peer;
    }

    public void setPeer(long peer) {
        this.peer = peer;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }
}

