/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsEncryptedMessage;
import com.github.badoualy.telegram.tl.core.TLBytes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLEncryptedMessageService
extends TLAbsEncryptedMessage {
    public static final int CONSTRUCTOR_ID = 594758406;
    private final String _constructor = "encryptedMessageService#23734b06";

    public TLEncryptedMessageService() {
    }

    public TLEncryptedMessageService(long randomId, int chatId, int date, TLBytes bytes) {
        this.randomId = randomId;
        this.chatId = chatId;
        this.date = date;
        this.bytes = bytes;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeLong(this.randomId, stream);
        StreamUtils.writeInt(this.chatId, stream);
        StreamUtils.writeInt(this.date, stream);
        StreamUtils.writeTLBytes(this.bytes, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.randomId = StreamUtils.readLong(stream);
        this.chatId = StreamUtils.readInt(stream);
        this.date = StreamUtils.readInt(stream);
        this.bytes = StreamUtils.readTLBytes(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.computeTLBytesSerializedSize(this.bytes);
    }

    public String toString() {
        return "encryptedMessageService#23734b06";
    }

    @Override
    public int getConstructorId() {
        return 594758406;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLEncryptedMessageService)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLEncryptedMessageService o = (TLEncryptedMessageService)object;
        return this.randomId == o.randomId && this.chatId == o.chatId && this.date == o.date && (this.bytes == o.bytes || this.bytes != null && o.bytes != null && this.bytes.equals(o.bytes));
    }

    @Override
    public long getRandomId() {
        return this.randomId;
    }

    @Override
    public void setRandomId(long randomId) {
        this.randomId = randomId;
    }

    @Override
    public int getChatId() {
        return this.chatId;
    }

    @Override
    public void setChatId(int chatId) {
        this.chatId = chatId;
    }

    @Override
    public int getDate() {
        return this.date;
    }

    @Override
    public void setDate(int date) {
        this.date = date;
    }

    @Override
    public TLBytes getBytes() {
        return this.bytes;
    }

    @Override
    public void setBytes(TLBytes bytes) {
        this.bytes = bytes;
    }
}

