/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsEncryptedFile;
import com.github.badoualy.telegram.tl.api.TLAbsEncryptedMessage;
import com.github.badoualy.telegram.tl.core.TLBytes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLEncryptedMessage
extends TLAbsEncryptedMessage {
    public static final int CONSTRUCTOR_ID = -317144808;
    protected TLAbsEncryptedFile file;
    private final String _constructor = "encryptedMessage#ed18c118";

    public TLEncryptedMessage() {
    }

    public TLEncryptedMessage(long randomId, int chatId, int date, TLBytes bytes, TLAbsEncryptedFile file) {
        this.randomId = randomId;
        this.chatId = chatId;
        this.date = date;
        this.bytes = bytes;
        this.file = file;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeLong(this.randomId, stream);
        StreamUtils.writeInt(this.chatId, stream);
        StreamUtils.writeInt(this.date, stream);
        StreamUtils.writeTLBytes(this.bytes, stream);
        StreamUtils.writeTLObject(this.file, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.randomId = StreamUtils.readLong(stream);
        this.chatId = StreamUtils.readInt(stream);
        this.date = StreamUtils.readInt(stream);
        this.bytes = StreamUtils.readTLBytes(stream, context);
        this.file = StreamUtils.readTLObject(stream, context, TLAbsEncryptedFile.class, -1);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.computeTLBytesSerializedSize(this.bytes);
        return size += this.file.computeSerializedSize();
    }

    public String toString() {
        return "encryptedMessage#ed18c118";
    }

    @Override
    public int getConstructorId() {
        return -317144808;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLEncryptedMessage)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLEncryptedMessage o = (TLEncryptedMessage)object;
        return this.randomId == o.randomId && this.chatId == o.chatId && this.date == o.date && (this.bytes == o.bytes || this.bytes != null && o.bytes != null && this.bytes.equals(o.bytes)) && (this.file == o.file || this.file != null && o.file != null && this.file.equals(o.file));
    }

    @Override
    public long getRandomId() {
        return this.randomId;
    }

    @Override
    public void setRandomId(long randomId) {
        this.randomId = randomId;
    }

    @Override
    public int getChatId() {
        return this.chatId;
    }

    @Override
    public void setChatId(int chatId) {
        this.chatId = chatId;
    }

    @Override
    public int getDate() {
        return this.date;
    }

    @Override
    public void setDate(int date) {
        this.date = date;
    }

    @Override
    public TLBytes getBytes() {
        return this.bytes;
    }

    @Override
    public void setBytes(TLBytes bytes) {
        this.bytes = bytes;
    }

    public TLAbsEncryptedFile getFile() {
        return this.file;
    }

    public void setFile(TLAbsEncryptedFile file) {
        this.file = file;
    }
}

