/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsEncryptedFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLEncryptedFile
extends TLAbsEncryptedFile {
    public static final int CONSTRUCTOR_ID = 1248893260;
    protected long id;
    protected long accessHash;
    protected int size;
    protected int dcId;
    protected int keyFingerprint;
    private final String _constructor = "encryptedFile#4a70994c";

    public TLEncryptedFile() {
    }

    public TLEncryptedFile(long id, long accessHash, int size, int dcId, int keyFingerprint) {
        this.id = id;
        this.accessHash = accessHash;
        this.size = size;
        this.dcId = dcId;
        this.keyFingerprint = keyFingerprint;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeLong(this.id, stream);
        StreamUtils.writeLong(this.accessHash, stream);
        StreamUtils.writeInt(this.size, stream);
        StreamUtils.writeInt(this.dcId, stream);
        StreamUtils.writeInt(this.keyFingerprint, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.id = StreamUtils.readLong(stream);
        this.accessHash = StreamUtils.readLong(stream);
        this.size = StreamUtils.readInt(stream);
        this.dcId = StreamUtils.readInt(stream);
        this.keyFingerprint = StreamUtils.readInt(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.SIZE_INT32;
    }

    public String toString() {
        return "encryptedFile#4a70994c";
    }

    @Override
    public int getConstructorId() {
        return 1248893260;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLEncryptedFile)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLEncryptedFile o = (TLEncryptedFile)object;
        return this.id == o.id && this.accessHash == o.accessHash && this.size == o.size && this.dcId == o.dcId && this.keyFingerprint == o.keyFingerprint;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getAccessHash() {
        return this.accessHash;
    }

    public void setAccessHash(long accessHash) {
        this.accessHash = accessHash;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getDcId() {
        return this.dcId;
    }

    public void setDcId(int dcId) {
        this.dcId = dcId;
    }

    public int getKeyFingerprint() {
        return this.keyFingerprint;
    }

    public void setKeyFingerprint(int keyFingerprint) {
        this.keyFingerprint = keyFingerprint;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public final boolean isNotEmpty() {
        return true;
    }

    @Override
    public final TLEncryptedFile getAsEncryptedFile() {
        return this;
    }
}

