/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsEncryptedChat;
import com.github.badoualy.telegram.tl.core.TLBytes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLEncryptedChat
extends TLAbsEncryptedChat {
    public static final int CONSTRUCTOR_ID = -94974410;
    protected long accessHash;
    protected int date;
    protected int adminId;
    protected int participantId;
    protected TLBytes gAOrB;
    protected long keyFingerprint;
    private final String _constructor = "encryptedChat#fa56ce36";

    public TLEncryptedChat() {
    }

    public TLEncryptedChat(int id, long accessHash, int date, int adminId, int participantId, TLBytes gAOrB, long keyFingerprint) {
        this.id = id;
        this.accessHash = accessHash;
        this.date = date;
        this.adminId = adminId;
        this.participantId = participantId;
        this.gAOrB = gAOrB;
        this.keyFingerprint = keyFingerprint;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeInt(this.id, stream);
        StreamUtils.writeLong(this.accessHash, stream);
        StreamUtils.writeInt(this.date, stream);
        StreamUtils.writeInt(this.adminId, stream);
        StreamUtils.writeInt(this.participantId, stream);
        StreamUtils.writeTLBytes(this.gAOrB, stream);
        StreamUtils.writeLong(this.keyFingerprint, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.id = StreamUtils.readInt(stream);
        this.accessHash = StreamUtils.readLong(stream);
        this.date = StreamUtils.readInt(stream);
        this.adminId = StreamUtils.readInt(stream);
        this.participantId = StreamUtils.readInt(stream);
        this.gAOrB = StreamUtils.readTLBytes(stream, context);
        this.keyFingerprint = StreamUtils.readLong(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.computeTLBytesSerializedSize(this.gAOrB);
        return size += TLObjectUtils.SIZE_INT64;
    }

    public String toString() {
        return "encryptedChat#fa56ce36";
    }

    @Override
    public int getConstructorId() {
        return -94974410;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLEncryptedChat)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLEncryptedChat o = (TLEncryptedChat)object;
        return this.id == o.id && this.accessHash == o.accessHash && this.date == o.date && this.adminId == o.adminId && this.participantId == o.participantId && (this.gAOrB == o.gAOrB || this.gAOrB != null && o.gAOrB != null && this.gAOrB.equals(o.gAOrB)) && this.keyFingerprint == o.keyFingerprint;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public long getAccessHash() {
        return this.accessHash;
    }

    public void setAccessHash(long accessHash) {
        this.accessHash = accessHash;
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int date) {
        this.date = date;
    }

    public int getAdminId() {
        return this.adminId;
    }

    public void setAdminId(int adminId) {
        this.adminId = adminId;
    }

    public int getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(int participantId) {
        this.participantId = participantId;
    }

    public TLBytes getGAOrB() {
        return this.gAOrB;
    }

    public void setGAOrB(TLBytes gAOrB) {
        this.gAOrB = gAOrB;
    }

    public long getKeyFingerprint() {
        return this.keyFingerprint;
    }

    public void setKeyFingerprint(long keyFingerprint) {
        this.keyFingerprint = keyFingerprint;
    }
}

