/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsDocument;
import com.github.badoualy.telegram.tl.api.TLAbsDocumentAttribute;
import com.github.badoualy.telegram.tl.api.TLAbsPhotoSize;
import com.github.badoualy.telegram.tl.core.TLVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLDocument
extends TLAbsDocument {
    public static final int CONSTRUCTOR_ID = -106717361;
    protected long accessHash;
    protected int date;
    protected String mimeType;
    protected int size;
    protected TLAbsPhotoSize thumb;
    protected int dcId;
    protected TLVector<TLAbsDocumentAttribute> attributes;
    private final String _constructor = "document#f9a39f4f";

    public TLDocument() {
    }

    public TLDocument(long id, long accessHash, int date, String mimeType, int size, TLAbsPhotoSize thumb, int dcId, TLVector<TLAbsDocumentAttribute> attributes) {
        this.id = id;
        this.accessHash = accessHash;
        this.date = date;
        this.mimeType = mimeType;
        this.size = size;
        this.thumb = thumb;
        this.dcId = dcId;
        this.attributes = attributes;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeLong(this.id, stream);
        StreamUtils.writeLong(this.accessHash, stream);
        StreamUtils.writeInt(this.date, stream);
        StreamUtils.writeString(this.mimeType, stream);
        StreamUtils.writeInt(this.size, stream);
        StreamUtils.writeTLObject(this.thumb, stream);
        StreamUtils.writeInt(this.dcId, stream);
        StreamUtils.writeTLVector(this.attributes, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.id = StreamUtils.readLong(stream);
        this.accessHash = StreamUtils.readLong(stream);
        this.date = StreamUtils.readInt(stream);
        this.mimeType = StreamUtils.readTLString(stream);
        this.size = StreamUtils.readInt(stream);
        this.thumb = StreamUtils.readTLObject(stream, context, TLAbsPhotoSize.class, -1);
        this.dcId = StreamUtils.readInt(stream);
        this.attributes = StreamUtils.readTLVector(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.computeTLStringSerializedSize(this.mimeType);
        size += TLObjectUtils.SIZE_INT32;
        size += this.thumb.computeSerializedSize();
        size += TLObjectUtils.SIZE_INT32;
        return size += this.attributes.computeSerializedSize();
    }

    public String toString() {
        return "document#f9a39f4f";
    }

    @Override
    public int getConstructorId() {
        return -106717361;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLDocument)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLDocument o = (TLDocument)object;
        return this.id == o.id && this.accessHash == o.accessHash && this.date == o.date && (this.mimeType == o.mimeType || this.mimeType != null && o.mimeType != null && this.mimeType.equals(o.mimeType)) && this.size == o.size && (this.thumb == o.thumb || this.thumb != null && o.thumb != null && this.thumb.equals(o.thumb)) && this.dcId == o.dcId && (this.attributes == o.attributes || this.attributes != null && o.attributes != null && this.attributes.equals(o.attributes));
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public long getAccessHash() {
        return this.accessHash;
    }

    public void setAccessHash(long accessHash) {
        this.accessHash = accessHash;
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int date) {
        this.date = date;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public TLAbsPhotoSize getThumb() {
        return this.thumb;
    }

    public void setThumb(TLAbsPhotoSize thumb) {
        this.thumb = thumb;
    }

    public int getDcId() {
        return this.dcId;
    }

    public void setDcId(int dcId) {
        this.dcId = dcId;
    }

    public TLVector<TLAbsDocumentAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(TLVector<TLAbsDocumentAttribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public final boolean isNotEmpty() {
        return true;
    }

    @Override
    public final TLDocument getAsDocument() {
        return this;
    }
}

