/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsDialog;
import com.github.badoualy.telegram.tl.api.TLAbsPeer;
import com.github.badoualy.telegram.tl.api.TLAbsPeerNotifySettings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLDialogChannel
extends TLAbsDialog {
    public static final int CONSTRUCTOR_ID = 1535415986;
    protected int topImportantMessage;
    protected int unreadImportantCount;
    protected int pts;
    private final String _constructor = "dialogChannel#5b8496b2";

    public TLDialogChannel() {
    }

    public TLDialogChannel(TLAbsPeer peer, int topMessage, int topImportantMessage, int readInboxMaxId, int unreadCount, int unreadImportantCount, TLAbsPeerNotifySettings notifySettings, int pts) {
        this.peer = peer;
        this.topMessage = topMessage;
        this.topImportantMessage = topImportantMessage;
        this.readInboxMaxId = readInboxMaxId;
        this.unreadCount = unreadCount;
        this.unreadImportantCount = unreadImportantCount;
        this.notifySettings = notifySettings;
        this.pts = pts;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeTLObject(this.peer, stream);
        StreamUtils.writeInt(this.topMessage, stream);
        StreamUtils.writeInt(this.topImportantMessage, stream);
        StreamUtils.writeInt(this.readInboxMaxId, stream);
        StreamUtils.writeInt(this.unreadCount, stream);
        StreamUtils.writeInt(this.unreadImportantCount, stream);
        StreamUtils.writeTLObject(this.notifySettings, stream);
        StreamUtils.writeInt(this.pts, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.peer = StreamUtils.readTLObject(stream, context, TLAbsPeer.class, -1);
        this.topMessage = StreamUtils.readInt(stream);
        this.topImportantMessage = StreamUtils.readInt(stream);
        this.readInboxMaxId = StreamUtils.readInt(stream);
        this.unreadCount = StreamUtils.readInt(stream);
        this.unreadImportantCount = StreamUtils.readInt(stream);
        this.notifySettings = StreamUtils.readTLObject(stream, context, TLAbsPeerNotifySettings.class, -1);
        this.pts = StreamUtils.readInt(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += this.peer.computeSerializedSize();
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += this.notifySettings.computeSerializedSize();
        return size += TLObjectUtils.SIZE_INT32;
    }

    public String toString() {
        return "dialogChannel#5b8496b2";
    }

    @Override
    public int getConstructorId() {
        return 1535415986;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLDialogChannel)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLDialogChannel o = (TLDialogChannel)object;
        return (this.peer == o.peer || this.peer != null && o.peer != null && this.peer.equals(o.peer)) && this.topMessage == o.topMessage && this.topImportantMessage == o.topImportantMessage && this.readInboxMaxId == o.readInboxMaxId && this.unreadCount == o.unreadCount && this.unreadImportantCount == o.unreadImportantCount && (this.notifySettings == o.notifySettings || this.notifySettings != null && o.notifySettings != null && this.notifySettings.equals(o.notifySettings)) && this.pts == o.pts;
    }

    @Override
    public TLAbsPeer getPeer() {
        return this.peer;
    }

    @Override
    public void setPeer(TLAbsPeer peer) {
        this.peer = peer;
    }

    @Override
    public int getTopMessage() {
        return this.topMessage;
    }

    @Override
    public void setTopMessage(int topMessage) {
        this.topMessage = topMessage;
    }

    public int getTopImportantMessage() {
        return this.topImportantMessage;
    }

    public void setTopImportantMessage(int topImportantMessage) {
        this.topImportantMessage = topImportantMessage;
    }

    @Override
    public int getReadInboxMaxId() {
        return this.readInboxMaxId;
    }

    @Override
    public void setReadInboxMaxId(int readInboxMaxId) {
        this.readInboxMaxId = readInboxMaxId;
    }

    @Override
    public int getUnreadCount() {
        return this.unreadCount;
    }

    @Override
    public void setUnreadCount(int unreadCount) {
        this.unreadCount = unreadCount;
    }

    public int getUnreadImportantCount() {
        return this.unreadImportantCount;
    }

    public void setUnreadImportantCount(int unreadImportantCount) {
        this.unreadImportantCount = unreadImportantCount;
    }

    @Override
    public TLAbsPeerNotifySettings getNotifySettings() {
        return this.notifySettings;
    }

    @Override
    public void setNotifySettings(TLAbsPeerNotifySettings notifySettings) {
        this.notifySettings = notifySettings;
    }

    public int getPts() {
        return this.pts;
    }

    public void setPts(int pts) {
        this.pts = pts;
    }
}

