/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsDialog;
import com.github.badoualy.telegram.tl.api.TLAbsPeer;
import com.github.badoualy.telegram.tl.api.TLAbsPeerNotifySettings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLDialog
extends TLAbsDialog {
    public static final int CONSTRUCTOR_ID = -1042448310;
    private final String _constructor = "dialog#c1dd804a";

    public TLDialog() {
    }

    public TLDialog(TLAbsPeer peer, int topMessage, int readInboxMaxId, int unreadCount, TLAbsPeerNotifySettings notifySettings) {
        this.peer = peer;
        this.topMessage = topMessage;
        this.readInboxMaxId = readInboxMaxId;
        this.unreadCount = unreadCount;
        this.notifySettings = notifySettings;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeTLObject(this.peer, stream);
        StreamUtils.writeInt(this.topMessage, stream);
        StreamUtils.writeInt(this.readInboxMaxId, stream);
        StreamUtils.writeInt(this.unreadCount, stream);
        StreamUtils.writeTLObject(this.notifySettings, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.peer = StreamUtils.readTLObject(stream, context, TLAbsPeer.class, -1);
        this.topMessage = StreamUtils.readInt(stream);
        this.readInboxMaxId = StreamUtils.readInt(stream);
        this.unreadCount = StreamUtils.readInt(stream);
        this.notifySettings = StreamUtils.readTLObject(stream, context, TLAbsPeerNotifySettings.class, -1);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += this.peer.computeSerializedSize();
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        return size += this.notifySettings.computeSerializedSize();
    }

    public String toString() {
        return "dialog#c1dd804a";
    }

    @Override
    public int getConstructorId() {
        return -1042448310;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLDialog)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLDialog o = (TLDialog)object;
        return (this.peer == o.peer || this.peer != null && o.peer != null && this.peer.equals(o.peer)) && this.topMessage == o.topMessage && this.readInboxMaxId == o.readInboxMaxId && this.unreadCount == o.unreadCount && (this.notifySettings == o.notifySettings || this.notifySettings != null && o.notifySettings != null && this.notifySettings.equals(o.notifySettings));
    }

    @Override
    public TLAbsPeer getPeer() {
        return this.peer;
    }

    @Override
    public void setPeer(TLAbsPeer peer) {
        this.peer = peer;
    }

    @Override
    public int getTopMessage() {
        return this.topMessage;
    }

    @Override
    public void setTopMessage(int topMessage) {
        this.topMessage = topMessage;
    }

    @Override
    public int getReadInboxMaxId() {
        return this.readInboxMaxId;
    }

    @Override
    public void setReadInboxMaxId(int readInboxMaxId) {
        this.readInboxMaxId = readInboxMaxId;
    }

    @Override
    public int getUnreadCount() {
        return this.unreadCount;
    }

    @Override
    public void setUnreadCount(int unreadCount) {
        this.unreadCount = unreadCount;
    }

    @Override
    public TLAbsPeerNotifySettings getNotifySettings() {
        return this.notifySettings;
    }

    @Override
    public void setNotifySettings(TLAbsPeerNotifySettings notifySettings) {
        this.notifySettings = notifySettings;
    }
}

