/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLDcOption
extends TLObject {
    public static final int CONSTRUCTOR_ID = 98092748;
    protected int flags;
    protected boolean ipv6;
    protected boolean mediaOnly;
    protected int id;
    protected String ipAddress;
    protected int port;
    private final String _constructor = "dcOption#5d8c6cc";

    public TLDcOption() {
    }

    public TLDcOption(boolean ipv6, boolean mediaOnly, int id, String ipAddress, int port) {
        this.ipv6 = ipv6;
        this.mediaOnly = mediaOnly;
        this.id = id;
        this.ipAddress = ipAddress;
        this.port = port;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.ipv6 ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.mediaOnly ? this.flags | 2 : this.flags & 0xFFFFFFFD;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeInt(this.id, stream);
        StreamUtils.writeString(this.ipAddress, stream);
        StreamUtils.writeInt(this.port, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.ipv6 = (this.flags & 1) != 0;
        this.mediaOnly = (this.flags & 2) != 0;
        this.id = StreamUtils.readInt(stream);
        this.ipAddress = StreamUtils.readTLString(stream);
        this.port = StreamUtils.readInt(stream);
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.computeTLStringSerializedSize(this.ipAddress);
        return size += TLObjectUtils.SIZE_INT32;
    }

    public String toString() {
        return "dcOption#5d8c6cc";
    }

    @Override
    public int getConstructorId() {
        return 98092748;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLDcOption)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLDcOption o = (TLDcOption)object;
        return this.flags == o.flags && this.ipv6 == o.ipv6 && this.mediaOnly == o.mediaOnly && this.id == o.id && (this.ipAddress == o.ipAddress || this.ipAddress != null && o.ipAddress != null && this.ipAddress.equals(o.ipAddress)) && this.port == o.port;
    }

    public boolean getIpv6() {
        return this.ipv6;
    }

    public void setIpv6(boolean ipv6) {
        this.ipv6 = ipv6;
    }

    public boolean getMediaOnly() {
        return this.mediaOnly;
    }

    public void setMediaOnly(boolean mediaOnly) {
        this.mediaOnly = mediaOnly;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

