/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsChatParticipant;
import com.github.badoualy.telegram.tl.api.TLAbsChatParticipants;
import com.github.badoualy.telegram.tl.core.TLVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLChatParticipants
extends TLAbsChatParticipants {
    public static final int CONSTRUCTOR_ID = 1061556205;
    protected TLVector<TLAbsChatParticipant> participants;
    protected int version;
    private final String _constructor = "chatParticipants#3f460fed";

    public TLChatParticipants() {
    }

    public TLChatParticipants(int chatId, TLVector<TLAbsChatParticipant> participants, int version) {
        this.chatId = chatId;
        this.participants = participants;
        this.version = version;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeInt(this.chatId, stream);
        StreamUtils.writeTLVector(this.participants, stream);
        StreamUtils.writeInt(this.version, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.chatId = StreamUtils.readInt(stream);
        this.participants = StreamUtils.readTLVector(stream, context);
        this.version = StreamUtils.readInt(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += this.participants.computeSerializedSize();
        return size += TLObjectUtils.SIZE_INT32;
    }

    public String toString() {
        return "chatParticipants#3f460fed";
    }

    @Override
    public int getConstructorId() {
        return 1061556205;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLChatParticipants)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLChatParticipants o = (TLChatParticipants)object;
        return this.chatId == o.chatId && (this.participants == o.participants || this.participants != null && o.participants != null && this.participants.equals(o.participants)) && this.version == o.version;
    }

    @Override
    public int getChatId() {
        return this.chatId;
    }

    @Override
    public void setChatId(int chatId) {
        this.chatId = chatId;
    }

    public TLVector<TLAbsChatParticipant> getParticipants() {
        return this.participants;
    }

    public void setParticipants(TLVector<TLAbsChatParticipant> participants) {
        this.participants = participants;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

