/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsChatInvite;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLChatInvite
extends TLAbsChatInvite {
    public static final int CONSTRUCTOR_ID = -1813406880;
    protected int flags;
    protected boolean channel;
    protected boolean broadcast;
    protected boolean _public;
    protected boolean megagroup;
    protected String title;
    private final String _constructor = "chatInvite#93e99b60";

    public TLChatInvite() {
    }

    public TLChatInvite(boolean channel, boolean broadcast, boolean _public, boolean megagroup, String title) {
        this.channel = channel;
        this.broadcast = broadcast;
        this._public = _public;
        this.megagroup = megagroup;
        this.title = title;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.channel ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.broadcast ? this.flags | 2 : this.flags & 0xFFFFFFFD;
        this.flags = this._public ? this.flags | 4 : this.flags & 0xFFFFFFFB;
        this.flags = this.megagroup ? this.flags | 8 : this.flags & 0xFFFFFFF7;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeString(this.title, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.channel = (this.flags & 1) != 0;
        this.broadcast = (this.flags & 2) != 0;
        this._public = (this.flags & 4) != 0;
        this.megagroup = (this.flags & 8) != 0;
        this.title = StreamUtils.readTLString(stream);
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.computeTLStringSerializedSize(this.title);
    }

    public String toString() {
        return "chatInvite#93e99b60";
    }

    @Override
    public int getConstructorId() {
        return -1813406880;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLChatInvite)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLChatInvite o = (TLChatInvite)object;
        return this.flags == o.flags && this.channel == o.channel && this.broadcast == o.broadcast && this._public == o._public && this.megagroup == o.megagroup && (this.title == o.title || this.title != null && o.title != null && this.title.equals(o.title));
    }

    public boolean getChannel() {
        return this.channel;
    }

    public void setChannel(boolean channel) {
        this.channel = channel;
    }

    public boolean getBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public boolean getPublic() {
        return this._public;
    }

    public void setPublic(boolean _public) {
        this._public = _public;
    }

    public boolean getMegagroup() {
        return this.megagroup;
    }

    public void setMegagroup(boolean megagroup) {
        this.megagroup = megagroup;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

