/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsChat;
import com.github.badoualy.telegram.tl.api.TLAbsChatPhoto;
import com.github.badoualy.telegram.tl.api.TLAbsInputChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLChat
extends TLAbsChat {
    public static final int CONSTRUCTOR_ID = -652419756;
    protected int flags;
    protected boolean creator;
    protected boolean kicked;
    protected boolean left;
    protected boolean adminsEnabled;
    protected boolean admin;
    protected boolean deactivated;
    protected String title;
    protected TLAbsChatPhoto photo;
    protected int participantsCount;
    protected int date;
    protected int version;
    protected TLAbsInputChannel migratedTo;
    private final String _constructor = "chat#d91cdd54";

    public TLChat() {
    }

    public TLChat(boolean creator, boolean kicked, boolean left, boolean adminsEnabled, boolean admin, boolean deactivated, int id, String title, TLAbsChatPhoto photo, int participantsCount, int date, int version, TLAbsInputChannel migratedTo) {
        this.creator = creator;
        this.kicked = kicked;
        this.left = left;
        this.adminsEnabled = adminsEnabled;
        this.admin = admin;
        this.deactivated = deactivated;
        this.id = id;
        this.title = title;
        this.photo = photo;
        this.participantsCount = participantsCount;
        this.date = date;
        this.version = version;
        this.migratedTo = migratedTo;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.creator ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.kicked ? this.flags | 2 : this.flags & 0xFFFFFFFD;
        this.flags = this.left ? this.flags | 4 : this.flags & 0xFFFFFFFB;
        this.flags = this.adminsEnabled ? this.flags | 8 : this.flags & 0xFFFFFFF7;
        this.flags = this.admin ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
        this.flags = this.deactivated ? this.flags | 0x20 : this.flags & 0xFFFFFFDF;
        this.flags = this.migratedTo != null ? this.flags | 0x40 : this.flags & 0xFFFFFFBF;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeInt(this.id, stream);
        StreamUtils.writeString(this.title, stream);
        StreamUtils.writeTLObject(this.photo, stream);
        StreamUtils.writeInt(this.participantsCount, stream);
        StreamUtils.writeInt(this.date, stream);
        StreamUtils.writeInt(this.version, stream);
        if ((this.flags & 0x40) != 0) {
            StreamUtils.writeTLObject(this.migratedTo, stream);
        }
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.creator = (this.flags & 1) != 0;
        this.kicked = (this.flags & 2) != 0;
        this.left = (this.flags & 4) != 0;
        this.adminsEnabled = (this.flags & 8) != 0;
        this.admin = (this.flags & 0x10) != 0;
        this.deactivated = (this.flags & 0x20) != 0;
        this.id = StreamUtils.readInt(stream);
        this.title = StreamUtils.readTLString(stream);
        this.photo = StreamUtils.readTLObject(stream, context, TLAbsChatPhoto.class, -1);
        this.participantsCount = StreamUtils.readInt(stream);
        this.date = StreamUtils.readInt(stream);
        this.version = StreamUtils.readInt(stream);
        this.migratedTo = (this.flags & 0x40) != 0 ? StreamUtils.readTLObject(stream, context, TLAbsInputChannel.class, -1) : null;
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.computeTLStringSerializedSize(this.title);
        size += this.photo.computeSerializedSize();
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        if ((this.flags & 0x40) != 0) {
            size += this.migratedTo.computeSerializedSize();
        }
        return size;
    }

    public String toString() {
        return "chat#d91cdd54";
    }

    @Override
    public int getConstructorId() {
        return -652419756;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLChat)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLChat o = (TLChat)object;
        return this.flags == o.flags && this.creator == o.creator && this.kicked == o.kicked && this.left == o.left && this.adminsEnabled == o.adminsEnabled && this.admin == o.admin && this.deactivated == o.deactivated && this.id == o.id && (this.title == o.title || this.title != null && o.title != null && this.title.equals(o.title)) && (this.photo == o.photo || this.photo != null && o.photo != null && this.photo.equals(o.photo)) && this.participantsCount == o.participantsCount && this.date == o.date && this.version == o.version && (this.migratedTo == o.migratedTo || this.migratedTo != null && o.migratedTo != null && this.migratedTo.equals(o.migratedTo));
    }

    public boolean getCreator() {
        return this.creator;
    }

    public void setCreator(boolean creator) {
        this.creator = creator;
    }

    public boolean getKicked() {
        return this.kicked;
    }

    public void setKicked(boolean kicked) {
        this.kicked = kicked;
    }

    public boolean getLeft() {
        return this.left;
    }

    public void setLeft(boolean left) {
        this.left = left;
    }

    public boolean getAdminsEnabled() {
        return this.adminsEnabled;
    }

    public void setAdminsEnabled(boolean adminsEnabled) {
        this.adminsEnabled = adminsEnabled;
    }

    public boolean getAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public boolean getDeactivated() {
        return this.deactivated;
    }

    public void setDeactivated(boolean deactivated) {
        this.deactivated = deactivated;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public TLAbsChatPhoto getPhoto() {
        return this.photo;
    }

    public void setPhoto(TLAbsChatPhoto photo) {
        this.photo = photo;
    }

    public int getParticipantsCount() {
        return this.participantsCount;
    }

    public void setParticipantsCount(int participantsCount) {
        this.participantsCount = participantsCount;
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int date) {
        this.date = date;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public TLAbsInputChannel getMigratedTo() {
        return this.migratedTo;
    }

    public void setMigratedTo(TLAbsInputChannel migratedTo) {
        this.migratedTo = migratedTo;
    }
}

