/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsChannelMessagesFilter;
import com.github.badoualy.telegram.tl.api.TLMessageRange;
import com.github.badoualy.telegram.tl.core.TLVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLChannelMessagesFilter
extends TLAbsChannelMessagesFilter {
    public static final int CONSTRUCTOR_ID = -847783593;
    protected int flags;
    protected boolean importantOnly;
    protected boolean excludeNewMessages;
    protected TLVector<TLMessageRange> ranges;
    private final String _constructor = "channelMessagesFilter#cd77d957";

    public TLChannelMessagesFilter() {
    }

    public TLChannelMessagesFilter(boolean importantOnly, boolean excludeNewMessages, TLVector<TLMessageRange> ranges) {
        this.importantOnly = importantOnly;
        this.excludeNewMessages = excludeNewMessages;
        this.ranges = ranges;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.importantOnly ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.excludeNewMessages ? this.flags | 2 : this.flags & 0xFFFFFFFD;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeTLVector(this.ranges, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.importantOnly = (this.flags & 1) != 0;
        this.excludeNewMessages = (this.flags & 2) != 0;
        this.ranges = StreamUtils.readTLVector(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        return size += this.ranges.computeSerializedSize();
    }

    public String toString() {
        return "channelMessagesFilter#cd77d957";
    }

    @Override
    public int getConstructorId() {
        return -847783593;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLChannelMessagesFilter)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLChannelMessagesFilter o = (TLChannelMessagesFilter)object;
        return this.flags == o.flags && this.importantOnly == o.importantOnly && this.excludeNewMessages == o.excludeNewMessages && (this.ranges == o.ranges || this.ranges != null && o.ranges != null && this.ranges.equals(o.ranges));
    }

    public boolean getImportantOnly() {
        return this.importantOnly;
    }

    public void setImportantOnly(boolean importantOnly) {
        this.importantOnly = importantOnly;
    }

    public boolean getExcludeNewMessages() {
        return this.excludeNewMessages;
    }

    public void setExcludeNewMessages(boolean excludeNewMessages) {
        this.excludeNewMessages = excludeNewMessages;
    }

    public TLVector<TLMessageRange> getRanges() {
        return this.ranges;
    }

    public void setRanges(TLVector<TLMessageRange> ranges) {
        this.ranges = ranges;
    }
}

