/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsBotInfo;
import com.github.badoualy.telegram.tl.api.TLAbsChatFull;
import com.github.badoualy.telegram.tl.api.TLAbsExportedChatInvite;
import com.github.badoualy.telegram.tl.api.TLAbsPeerNotifySettings;
import com.github.badoualy.telegram.tl.api.TLAbsPhoto;
import com.github.badoualy.telegram.tl.core.TLVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLChannelFull
extends TLAbsChatFull {
    public static final int CONSTRUCTOR_ID = -1640751649;
    protected int flags;
    protected boolean canViewParticipants;
    protected String about;
    protected Integer participantsCount;
    protected Integer adminsCount;
    protected Integer kickedCount;
    protected int readInboxMaxId;
    protected int unreadCount;
    protected int unreadImportantCount;
    protected Integer migratedFromChatId;
    protected Integer migratedFromMaxId;
    private final String _constructor = "channelFull#9e341ddf";

    public TLChannelFull() {
    }

    public TLChannelFull(boolean canViewParticipants, int id, String about, Integer participantsCount, Integer adminsCount, Integer kickedCount, int readInboxMaxId, int unreadCount, int unreadImportantCount, TLAbsPhoto chatPhoto, TLAbsPeerNotifySettings notifySettings, TLAbsExportedChatInvite exportedInvite, TLVector<TLAbsBotInfo> botInfo, Integer migratedFromChatId, Integer migratedFromMaxId) {
        this.canViewParticipants = canViewParticipants;
        this.id = id;
        this.about = about;
        this.participantsCount = participantsCount;
        this.adminsCount = adminsCount;
        this.kickedCount = kickedCount;
        this.readInboxMaxId = readInboxMaxId;
        this.unreadCount = unreadCount;
        this.unreadImportantCount = unreadImportantCount;
        this.chatPhoto = chatPhoto;
        this.notifySettings = notifySettings;
        this.exportedInvite = exportedInvite;
        this.botInfo = botInfo;
        this.migratedFromChatId = migratedFromChatId;
        this.migratedFromMaxId = migratedFromMaxId;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.canViewParticipants ? this.flags | 8 : this.flags & 0xFFFFFFF7;
        this.flags = this.participantsCount != null ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.adminsCount != null ? this.flags | 2 : this.flags & 0xFFFFFFFD;
        this.flags = this.kickedCount != null ? this.flags | 4 : this.flags & 0xFFFFFFFB;
        this.flags = this.migratedFromChatId != null ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
        this.flags = this.migratedFromMaxId != null ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeInt(this.id, stream);
        StreamUtils.writeString(this.about, stream);
        if ((this.flags & 1) != 0) {
            StreamUtils.writeInt(this.participantsCount, stream);
        }
        if ((this.flags & 2) != 0) {
            StreamUtils.writeInt(this.adminsCount, stream);
        }
        if ((this.flags & 4) != 0) {
            StreamUtils.writeInt(this.kickedCount, stream);
        }
        StreamUtils.writeInt(this.readInboxMaxId, stream);
        StreamUtils.writeInt(this.unreadCount, stream);
        StreamUtils.writeInt(this.unreadImportantCount, stream);
        StreamUtils.writeTLObject(this.chatPhoto, stream);
        StreamUtils.writeTLObject(this.notifySettings, stream);
        StreamUtils.writeTLObject(this.exportedInvite, stream);
        StreamUtils.writeTLVector(this.botInfo, stream);
        if ((this.flags & 0x10) != 0) {
            StreamUtils.writeInt(this.migratedFromChatId, stream);
        }
        if ((this.flags & 0x10) != 0) {
            StreamUtils.writeInt(this.migratedFromMaxId, stream);
        }
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.canViewParticipants = (this.flags & 8) != 0;
        this.id = StreamUtils.readInt(stream);
        this.about = StreamUtils.readTLString(stream);
        this.participantsCount = (this.flags & 1) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.adminsCount = (this.flags & 2) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.kickedCount = (this.flags & 4) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.readInboxMaxId = StreamUtils.readInt(stream);
        this.unreadCount = StreamUtils.readInt(stream);
        this.unreadImportantCount = StreamUtils.readInt(stream);
        this.chatPhoto = StreamUtils.readTLObject(stream, context, TLAbsPhoto.class, -1);
        this.notifySettings = StreamUtils.readTLObject(stream, context, TLAbsPeerNotifySettings.class, -1);
        this.exportedInvite = StreamUtils.readTLObject(stream, context, TLAbsExportedChatInvite.class, -1);
        this.botInfo = StreamUtils.readTLVector(stream, context);
        this.migratedFromChatId = (this.flags & 0x10) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.migratedFromMaxId = (this.flags & 0x10) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.computeTLStringSerializedSize(this.about);
        if ((this.flags & 1) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        if ((this.flags & 2) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        if ((this.flags & 4) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += this.chatPhoto.computeSerializedSize();
        size += this.notifySettings.computeSerializedSize();
        size += this.exportedInvite.computeSerializedSize();
        size += this.botInfo.computeSerializedSize();
        if ((this.flags & 0x10) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        if ((this.flags & 0x10) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        return size;
    }

    public String toString() {
        return "channelFull#9e341ddf";
    }

    @Override
    public int getConstructorId() {
        return -1640751649;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLChannelFull)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLChannelFull o = (TLChannelFull)object;
        return this.flags == o.flags && this.canViewParticipants == o.canViewParticipants && this.id == o.id && (this.about == o.about || this.about != null && o.about != null && this.about.equals(o.about)) && (this.participantsCount == o.participantsCount || this.participantsCount != null && o.participantsCount != null && this.participantsCount.equals(o.participantsCount)) && (this.adminsCount == o.adminsCount || this.adminsCount != null && o.adminsCount != null && this.adminsCount.equals(o.adminsCount)) && (this.kickedCount == o.kickedCount || this.kickedCount != null && o.kickedCount != null && this.kickedCount.equals(o.kickedCount)) && this.readInboxMaxId == o.readInboxMaxId && this.unreadCount == o.unreadCount && this.unreadImportantCount == o.unreadImportantCount && (this.chatPhoto == o.chatPhoto || this.chatPhoto != null && o.chatPhoto != null && this.chatPhoto.equals(o.chatPhoto)) && (this.notifySettings == o.notifySettings || this.notifySettings != null && o.notifySettings != null && this.notifySettings.equals(o.notifySettings)) && (this.exportedInvite == o.exportedInvite || this.exportedInvite != null && o.exportedInvite != null && this.exportedInvite.equals(o.exportedInvite)) && (this.botInfo == o.botInfo || this.botInfo != null && o.botInfo != null && this.botInfo.equals(o.botInfo)) && (this.migratedFromChatId == o.migratedFromChatId || this.migratedFromChatId != null && o.migratedFromChatId != null && this.migratedFromChatId.equals(o.migratedFromChatId)) && (this.migratedFromMaxId == o.migratedFromMaxId || this.migratedFromMaxId != null && o.migratedFromMaxId != null && this.migratedFromMaxId.equals(o.migratedFromMaxId));
    }

    public boolean getCanViewParticipants() {
        return this.canViewParticipants;
    }

    public void setCanViewParticipants(boolean canViewParticipants) {
        this.canViewParticipants = canViewParticipants;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public String getAbout() {
        return this.about;
    }

    public void setAbout(String about) {
        this.about = about;
    }

    public Integer getParticipantsCount() {
        return this.participantsCount;
    }

    public void setParticipantsCount(Integer participantsCount) {
        this.participantsCount = participantsCount;
    }

    public Integer getAdminsCount() {
        return this.adminsCount;
    }

    public void setAdminsCount(Integer adminsCount) {
        this.adminsCount = adminsCount;
    }

    public Integer getKickedCount() {
        return this.kickedCount;
    }

    public void setKickedCount(Integer kickedCount) {
        this.kickedCount = kickedCount;
    }

    public int getReadInboxMaxId() {
        return this.readInboxMaxId;
    }

    public void setReadInboxMaxId(int readInboxMaxId) {
        this.readInboxMaxId = readInboxMaxId;
    }

    public int getUnreadCount() {
        return this.unreadCount;
    }

    public void setUnreadCount(int unreadCount) {
        this.unreadCount = unreadCount;
    }

    public int getUnreadImportantCount() {
        return this.unreadImportantCount;
    }

    public void setUnreadImportantCount(int unreadImportantCount) {
        this.unreadImportantCount = unreadImportantCount;
    }

    @Override
    public TLAbsPhoto getChatPhoto() {
        return this.chatPhoto;
    }

    @Override
    public void setChatPhoto(TLAbsPhoto chatPhoto) {
        this.chatPhoto = chatPhoto;
    }

    @Override
    public TLAbsPeerNotifySettings getNotifySettings() {
        return this.notifySettings;
    }

    @Override
    public void setNotifySettings(TLAbsPeerNotifySettings notifySettings) {
        this.notifySettings = notifySettings;
    }

    @Override
    public TLAbsExportedChatInvite getExportedInvite() {
        return this.exportedInvite;
    }

    @Override
    public void setExportedInvite(TLAbsExportedChatInvite exportedInvite) {
        this.exportedInvite = exportedInvite;
    }

    @Override
    public TLVector<TLAbsBotInfo> getBotInfo() {
        return this.botInfo;
    }

    @Override
    public void setBotInfo(TLVector<TLAbsBotInfo> botInfo) {
        this.botInfo = botInfo;
    }

    public Integer getMigratedFromChatId() {
        return this.migratedFromChatId;
    }

    public void setMigratedFromChatId(Integer migratedFromChatId) {
        this.migratedFromChatId = migratedFromChatId;
    }

    public Integer getMigratedFromMaxId() {
        return this.migratedFromMaxId;
    }

    public void setMigratedFromMaxId(Integer migratedFromMaxId) {
        this.migratedFromMaxId = migratedFromMaxId;
    }
}

