/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsChat;
import com.github.badoualy.telegram.tl.api.TLAbsChatPhoto;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLChannel
extends TLAbsChat {
    public static final int CONSTRUCTOR_ID = 1260090630;
    protected int flags;
    protected boolean creator;
    protected boolean kicked;
    protected boolean left;
    protected boolean editor;
    protected boolean moderator;
    protected boolean broadcast;
    protected boolean verified;
    protected boolean megagroup;
    protected boolean restricted;
    protected long accessHash;
    protected String title;
    protected String username;
    protected TLAbsChatPhoto photo;
    protected int date;
    protected int version;
    protected String restrictionReason;
    private final String _constructor = "channel#4b1b7506";

    public TLChannel() {
    }

    public TLChannel(boolean creator, boolean kicked, boolean left, boolean editor, boolean moderator, boolean broadcast, boolean verified, boolean megagroup, int id, long accessHash, String title, String username, TLAbsChatPhoto photo, int date, int version, String restrictionReason) {
        this.creator = creator;
        this.kicked = kicked;
        this.left = left;
        this.editor = editor;
        this.moderator = moderator;
        this.broadcast = broadcast;
        this.verified = verified;
        this.megagroup = megagroup;
        this.id = id;
        this.accessHash = accessHash;
        this.title = title;
        this.username = username;
        this.photo = photo;
        this.date = date;
        this.version = version;
        this.restrictionReason = restrictionReason;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.creator ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.kicked ? this.flags | 2 : this.flags & 0xFFFFFFFD;
        this.flags = this.left ? this.flags | 4 : this.flags & 0xFFFFFFFB;
        this.flags = this.editor ? this.flags | 8 : this.flags & 0xFFFFFFF7;
        this.flags = this.moderator ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
        this.flags = this.broadcast ? this.flags | 0x20 : this.flags & 0xFFFFFFDF;
        this.flags = this.verified ? this.flags | 0x80 : this.flags & 0xFFFFFF7F;
        this.flags = this.megagroup ? this.flags | 0x100 : this.flags & 0xFFFFFEFF;
        this.flags = this.username != null ? this.flags | 0x40 : this.flags & 0xFFFFFFBF;
        this.flags = this.restrictionReason != null ? this.flags | 0x200 : this.flags & 0xFFFFFDFF;
        this.restricted = (this.flags & 0x200) != 0;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeInt(this.id, stream);
        StreamUtils.writeLong(this.accessHash, stream);
        StreamUtils.writeString(this.title, stream);
        if ((this.flags & 0x40) != 0) {
            StreamUtils.writeString(this.username, stream);
        }
        StreamUtils.writeTLObject(this.photo, stream);
        StreamUtils.writeInt(this.date, stream);
        StreamUtils.writeInt(this.version, stream);
        if ((this.flags & 0x200) != 0) {
            StreamUtils.writeString(this.restrictionReason, stream);
        }
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.creator = (this.flags & 1) != 0;
        this.kicked = (this.flags & 2) != 0;
        this.left = (this.flags & 4) != 0;
        this.editor = (this.flags & 8) != 0;
        this.moderator = (this.flags & 0x10) != 0;
        this.broadcast = (this.flags & 0x20) != 0;
        this.verified = (this.flags & 0x80) != 0;
        this.megagroup = (this.flags & 0x100) != 0;
        this.restricted = (this.flags & 0x200) != 0;
        this.id = StreamUtils.readInt(stream);
        this.accessHash = StreamUtils.readLong(stream);
        this.title = StreamUtils.readTLString(stream);
        this.username = (this.flags & 0x40) != 0 ? StreamUtils.readTLString(stream) : null;
        this.photo = StreamUtils.readTLObject(stream, context, TLAbsChatPhoto.class, -1);
        this.date = StreamUtils.readInt(stream);
        this.version = StreamUtils.readInt(stream);
        this.restrictionReason = (this.flags & 0x200) != 0 ? StreamUtils.readTLString(stream) : null;
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.computeTLStringSerializedSize(this.title);
        if ((this.flags & 0x40) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.username);
        }
        size += this.photo.computeSerializedSize();
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        if ((this.flags & 0x200) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.restrictionReason);
        }
        return size;
    }

    public String toString() {
        return "channel#4b1b7506";
    }

    @Override
    public int getConstructorId() {
        return 1260090630;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLChannel)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLChannel o = (TLChannel)object;
        return this.flags == o.flags && this.creator == o.creator && this.kicked == o.kicked && this.left == o.left && this.editor == o.editor && this.moderator == o.moderator && this.broadcast == o.broadcast && this.verified == o.verified && this.megagroup == o.megagroup && this.restricted == o.restricted && this.id == o.id && this.accessHash == o.accessHash && (this.title == o.title || this.title != null && o.title != null && this.title.equals(o.title)) && (this.username == o.username || this.username != null && o.username != null && this.username.equals(o.username)) && (this.photo == o.photo || this.photo != null && o.photo != null && this.photo.equals(o.photo)) && this.date == o.date && this.version == o.version && (this.restrictionReason == o.restrictionReason || this.restrictionReason != null && o.restrictionReason != null && this.restrictionReason.equals(o.restrictionReason));
    }

    public boolean getCreator() {
        return this.creator;
    }

    public void setCreator(boolean creator) {
        this.creator = creator;
    }

    public boolean getKicked() {
        return this.kicked;
    }

    public void setKicked(boolean kicked) {
        this.kicked = kicked;
    }

    public boolean getLeft() {
        return this.left;
    }

    public void setLeft(boolean left) {
        this.left = left;
    }

    public boolean getEditor() {
        return this.editor;
    }

    public void setEditor(boolean editor) {
        this.editor = editor;
    }

    public boolean getModerator() {
        return this.moderator;
    }

    public void setModerator(boolean moderator) {
        this.moderator = moderator;
    }

    public boolean getBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public boolean getVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public boolean getMegagroup() {
        return this.megagroup;
    }

    public void setMegagroup(boolean megagroup) {
        this.megagroup = megagroup;
    }

    public boolean getRestricted() {
        return this.restricted;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public long getAccessHash() {
        return this.accessHash;
    }

    public void setAccessHash(long accessHash) {
        this.accessHash = accessHash;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public TLAbsChatPhoto getPhoto() {
        return this.photo;
    }

    public void setPhoto(TLAbsChatPhoto photo) {
        this.photo = photo;
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int date) {
        this.date = date;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getRestrictionReason() {
        return this.restrictionReason;
    }

    public void setRestrictionReason(String restrictionReason) {
        this.restrictionReason = restrictionReason;
    }
}

