/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsBotInlineMessage;
import com.github.badoualy.telegram.tl.api.TLAbsBotInlineResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLBotInlineResult
extends TLAbsBotInlineResult {
    public static final int CONSTRUCTOR_ID = -1679053127;
    protected int flags;
    protected String title;
    protected String description;
    protected String url;
    protected String thumbUrl;
    protected String contentUrl;
    protected String contentType;
    protected Integer w;
    protected Integer h;
    protected Integer duration;
    private final String _constructor = "botInlineResult#9bebaeb9";

    public TLBotInlineResult() {
    }

    public TLBotInlineResult(String id, String type, String title, String description, String url, String thumbUrl, String contentUrl, String contentType, Integer w, Integer h, Integer duration, TLAbsBotInlineMessage sendMessage) {
        this.id = id;
        this.type = type;
        this.title = title;
        this.description = description;
        this.url = url;
        this.thumbUrl = thumbUrl;
        this.contentUrl = contentUrl;
        this.contentType = contentType;
        this.w = w;
        this.h = h;
        this.duration = duration;
        this.sendMessage = sendMessage;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.title != null ? this.flags | 2 : this.flags & 0xFFFFFFFD;
        this.flags = this.description != null ? this.flags | 4 : this.flags & 0xFFFFFFFB;
        this.flags = this.url != null ? this.flags | 8 : this.flags & 0xFFFFFFF7;
        this.flags = this.thumbUrl != null ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
        this.flags = this.contentUrl != null ? this.flags | 0x20 : this.flags & 0xFFFFFFDF;
        this.flags = this.contentType != null ? this.flags | 0x20 : this.flags & 0xFFFFFFDF;
        this.flags = this.w != null ? this.flags | 0x40 : this.flags & 0xFFFFFFBF;
        this.flags = this.h != null ? this.flags | 0x40 : this.flags & 0xFFFFFFBF;
        this.flags = this.duration != null ? this.flags | 0x80 : this.flags & 0xFFFFFF7F;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeString(this.id, stream);
        StreamUtils.writeString(this.type, stream);
        if ((this.flags & 2) != 0) {
            StreamUtils.writeString(this.title, stream);
        }
        if ((this.flags & 4) != 0) {
            StreamUtils.writeString(this.description, stream);
        }
        if ((this.flags & 8) != 0) {
            StreamUtils.writeString(this.url, stream);
        }
        if ((this.flags & 0x10) != 0) {
            StreamUtils.writeString(this.thumbUrl, stream);
        }
        if ((this.flags & 0x20) != 0) {
            StreamUtils.writeString(this.contentUrl, stream);
        }
        if ((this.flags & 0x20) != 0) {
            StreamUtils.writeString(this.contentType, stream);
        }
        if ((this.flags & 0x40) != 0) {
            StreamUtils.writeInt(this.w, stream);
        }
        if ((this.flags & 0x40) != 0) {
            StreamUtils.writeInt(this.h, stream);
        }
        if ((this.flags & 0x80) != 0) {
            StreamUtils.writeInt(this.duration, stream);
        }
        StreamUtils.writeTLObject(this.sendMessage, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.id = StreamUtils.readTLString(stream);
        this.type = StreamUtils.readTLString(stream);
        this.title = (this.flags & 2) != 0 ? StreamUtils.readTLString(stream) : null;
        this.description = (this.flags & 4) != 0 ? StreamUtils.readTLString(stream) : null;
        this.url = (this.flags & 8) != 0 ? StreamUtils.readTLString(stream) : null;
        this.thumbUrl = (this.flags & 0x10) != 0 ? StreamUtils.readTLString(stream) : null;
        this.contentUrl = (this.flags & 0x20) != 0 ? StreamUtils.readTLString(stream) : null;
        this.contentType = (this.flags & 0x20) != 0 ? StreamUtils.readTLString(stream) : null;
        this.w = (this.flags & 0x40) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.h = (this.flags & 0x40) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.duration = (this.flags & 0x80) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.sendMessage = StreamUtils.readTLObject(stream, context, TLAbsBotInlineMessage.class, -1);
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.computeTLStringSerializedSize(this.id);
        size += TLObjectUtils.computeTLStringSerializedSize(this.type);
        if ((this.flags & 2) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.title);
        }
        if ((this.flags & 4) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.description);
        }
        if ((this.flags & 8) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.url);
        }
        if ((this.flags & 0x10) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.thumbUrl);
        }
        if ((this.flags & 0x20) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.contentUrl);
        }
        if ((this.flags & 0x20) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.contentType);
        }
        if ((this.flags & 0x40) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        if ((this.flags & 0x40) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        if ((this.flags & 0x80) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        return size += this.sendMessage.computeSerializedSize();
    }

    public String toString() {
        return "botInlineResult#9bebaeb9";
    }

    @Override
    public int getConstructorId() {
        return -1679053127;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLBotInlineResult)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLBotInlineResult o = (TLBotInlineResult)object;
        return this.flags == o.flags && (this.id == o.id || this.id != null && o.id != null && this.id.equals(o.id)) && (this.type == o.type || this.type != null && o.type != null && this.type.equals(o.type)) && (this.title == o.title || this.title != null && o.title != null && this.title.equals(o.title)) && (this.description == o.description || this.description != null && o.description != null && this.description.equals(o.description)) && (this.url == o.url || this.url != null && o.url != null && this.url.equals(o.url)) && (this.thumbUrl == o.thumbUrl || this.thumbUrl != null && o.thumbUrl != null && this.thumbUrl.equals(o.thumbUrl)) && (this.contentUrl == o.contentUrl || this.contentUrl != null && o.contentUrl != null && this.contentUrl.equals(o.contentUrl)) && (this.contentType == o.contentType || this.contentType != null && o.contentType != null && this.contentType.equals(o.contentType)) && (this.w == o.w || this.w != null && o.w != null && this.w.equals(o.w)) && (this.h == o.h || this.h != null && o.h != null && this.h.equals(o.h)) && (this.duration == o.duration || this.duration != null && o.duration != null && this.duration.equals(o.duration)) && (this.sendMessage == o.sendMessage || this.sendMessage != null && o.sendMessage != null && this.sendMessage.equals(o.sendMessage));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public void setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
    }

    public String getContentUrl() {
        return this.contentUrl;
    }

    public void setContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Integer getW() {
        return this.w;
    }

    public void setW(Integer w) {
        this.w = w;
    }

    public Integer getH() {
        return this.h;
    }

    public void setH(Integer h) {
        this.h = h;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    @Override
    public TLAbsBotInlineMessage getSendMessage() {
        return this.sendMessage;
    }

    @Override
    public void setSendMessage(TLAbsBotInlineMessage sendMessage) {
        this.sendMessage = sendMessage;
    }
}

