/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsBotInlineMessage;
import com.github.badoualy.telegram.tl.api.TLAbsMessageEntity;
import com.github.badoualy.telegram.tl.core.TLVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLBotInlineMessageText
extends TLAbsBotInlineMessage {
    public static final int CONSTRUCTOR_ID = -1520330839;
    protected int flags;
    protected boolean noWebpage;
    protected String message;
    protected TLVector<TLAbsMessageEntity> entities;
    private final String _constructor = "botInlineMessageText#a56197a9";

    public TLBotInlineMessageText() {
    }

    public TLBotInlineMessageText(boolean noWebpage, String message, TLVector<TLAbsMessageEntity> entities) {
        this.noWebpage = noWebpage;
        this.message = message;
        this.entities = entities;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.noWebpage ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.entities != null ? this.flags | 2 : this.flags & 0xFFFFFFFD;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeString(this.message, stream);
        if ((this.flags & 2) != 0) {
            StreamUtils.writeTLVector(this.entities, stream);
        }
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.noWebpage = (this.flags & 1) != 0;
        this.message = StreamUtils.readTLString(stream);
        this.entities = (this.flags & 2) != 0 ? StreamUtils.readTLVector(stream, context) : null;
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.computeTLStringSerializedSize(this.message);
        if ((this.flags & 2) != 0) {
            size += this.entities.computeSerializedSize();
        }
        return size;
    }

    public String toString() {
        return "botInlineMessageText#a56197a9";
    }

    @Override
    public int getConstructorId() {
        return -1520330839;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLBotInlineMessageText)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLBotInlineMessageText o = (TLBotInlineMessageText)object;
        return this.flags == o.flags && this.noWebpage == o.noWebpage && (this.message == o.message || this.message != null && o.message != null && this.message.equals(o.message)) && (this.entities == o.entities || this.entities != null && o.entities != null && this.entities.equals(o.entities));
    }

    public boolean getNoWebpage() {
        return this.noWebpage;
    }

    public void setNoWebpage(boolean noWebpage) {
        this.noWebpage = noWebpage;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public TLVector<TLAbsMessageEntity> getEntities() {
        return this.entities;
    }

    public void setEntities(TLVector<TLAbsMessageEntity> entities) {
        this.entities = entities;
    }
}

