/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsBotInfo;
import com.github.badoualy.telegram.tl.api.TLBotCommand;
import com.github.badoualy.telegram.tl.core.TLVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLBotInfo
extends TLAbsBotInfo {
    public static final int CONSTRUCTOR_ID = 164583517;
    protected int userId;
    protected int version;
    protected String shareText;
    protected String description;
    protected TLVector<TLBotCommand> commands;
    private final String _constructor = "botInfo#9cf585d";

    public TLBotInfo() {
    }

    public TLBotInfo(int userId, int version, String shareText, String description, TLVector<TLBotCommand> commands) {
        this.userId = userId;
        this.version = version;
        this.shareText = shareText;
        this.description = description;
        this.commands = commands;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeInt(this.userId, stream);
        StreamUtils.writeInt(this.version, stream);
        StreamUtils.writeString(this.shareText, stream);
        StreamUtils.writeString(this.description, stream);
        StreamUtils.writeTLVector(this.commands, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.userId = StreamUtils.readInt(stream);
        this.version = StreamUtils.readInt(stream);
        this.shareText = StreamUtils.readTLString(stream);
        this.description = StreamUtils.readTLString(stream);
        this.commands = StreamUtils.readTLVector(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.computeTLStringSerializedSize(this.shareText);
        size += TLObjectUtils.computeTLStringSerializedSize(this.description);
        return size += this.commands.computeSerializedSize();
    }

    public String toString() {
        return "botInfo#9cf585d";
    }

    @Override
    public int getConstructorId() {
        return 164583517;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLBotInfo)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLBotInfo o = (TLBotInfo)object;
        return this.userId == o.userId && this.version == o.version && (this.shareText == o.shareText || this.shareText != null && o.shareText != null && this.shareText.equals(o.shareText)) && (this.description == o.description || this.description != null && o.description != null && this.description.equals(o.description)) && (this.commands == o.commands || this.commands != null && o.commands != null && this.commands.equals(o.commands));
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getShareText() {
        return this.shareText;
    }

    public void setShareText(String shareText) {
        this.shareText = shareText;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TLVector<TLBotCommand> getCommands() {
        return this.commands;
    }

    public void setCommands(TLVector<TLBotCommand> commands) {
        this.commands = commands;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public final boolean isNotEmpty() {
        return true;
    }

    @Override
    public final TLBotInfo getAsBotInfo() {
        return this;
    }
}

