/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsAudio;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLAudio
extends TLAbsAudio {
    public static final int CONSTRUCTOR_ID = -102543275;
    protected long accessHash;
    protected int date;
    protected int duration;
    protected String mimeType;
    protected int size;
    protected int dcId;
    private final String _constructor = "audio#f9e35055";

    public TLAudio() {
    }

    public TLAudio(long id, long accessHash, int date, int duration, String mimeType, int size, int dcId) {
        this.id = id;
        this.accessHash = accessHash;
        this.date = date;
        this.duration = duration;
        this.mimeType = mimeType;
        this.size = size;
        this.dcId = dcId;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeLong(this.id, stream);
        StreamUtils.writeLong(this.accessHash, stream);
        StreamUtils.writeInt(this.date, stream);
        StreamUtils.writeInt(this.duration, stream);
        StreamUtils.writeString(this.mimeType, stream);
        StreamUtils.writeInt(this.size, stream);
        StreamUtils.writeInt(this.dcId, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.id = StreamUtils.readLong(stream);
        this.accessHash = StreamUtils.readLong(stream);
        this.date = StreamUtils.readInt(stream);
        this.duration = StreamUtils.readInt(stream);
        this.mimeType = StreamUtils.readTLString(stream);
        this.size = StreamUtils.readInt(stream);
        this.dcId = StreamUtils.readInt(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.computeTLStringSerializedSize(this.mimeType);
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.SIZE_INT32;
    }

    public String toString() {
        return "audio#f9e35055";
    }

    @Override
    public int getConstructorId() {
        return -102543275;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLAudio)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLAudio o = (TLAudio)object;
        return this.id == o.id && this.accessHash == o.accessHash && this.date == o.date && this.duration == o.duration && (this.mimeType == o.mimeType || this.mimeType != null && o.mimeType != null && this.mimeType.equals(o.mimeType)) && this.size == o.size && this.dcId == o.dcId;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public long getAccessHash() {
        return this.accessHash;
    }

    public void setAccessHash(long accessHash) {
        this.accessHash = accessHash;
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int date) {
        this.date = date;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getDcId() {
        return this.dcId;
    }

    public void setDcId(int dcId) {
        this.dcId = dcId;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public final boolean isNotEmpty() {
        return true;
    }

    @Override
    public final TLAudio getAsAudio() {
        return this;
    }
}

