/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl;

import com.github.badoualy.telegram.tl.core.TLBytes;
import java.nio.charset.Charset;

public final class TLObjectUtils {
    public static int SIZE_INT32;
    public static int SIZE_CONSTRUCTOR_ID;
    public static int SIZE_BOOLEAN;
    public static int SIZE_INT64;
    public static int SIZE_DOUBLE;

    private TLObjectUtils() {
    }

    public static int computeTLBytesSerializedSize(int length) {
        int size = length + (length >= 254 ? 4 : 1);
        int offset = size % 4;
        if (offset != 0) {
            size += 4 - offset;
        }
        return size;
    }

    public static int computeTLBytesSerializedSize(TLBytes bytes) {
        return TLObjectUtils.computeTLBytesSerializedSize(bytes.getLength());
    }

    public static int computeTLStringSerializedSize(String string) {
        return TLObjectUtils.computeTLBytesSerializedSize(string.getBytes(Charset.forName("UTF-8")).length);
    }

    static {
        SIZE_BOOLEAN = SIZE_CONSTRUCTOR_ID = (SIZE_INT32 = 4);
        SIZE_INT64 = 8;
        SIZE_DOUBLE = 8;
    }
}

