/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.core.TLBool;
import com.github.badoualy.telegram.tl.core.TLGzipObject;
import com.github.badoualy.telegram.tl.core.TLIntVector;
import com.github.badoualy.telegram.tl.core.TLLongVector;
import com.github.badoualy.telegram.tl.core.TLObject;
import com.github.badoualy.telegram.tl.core.TLStringVector;
import com.github.badoualy.telegram.tl.core.TLVector;
import com.github.badoualy.telegram.tl.exception.DeserializationException;
import com.github.badoualy.telegram.tl.exception.InvalidConstructorIdException;
import com.github.badoualy.telegram.tl.exception.UnsupportedConstructorException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;

public abstract class TLContext {
    private HashMap<Integer, Class> registeredClasses;

    @Deprecated
    public TLContext() {
        this.registeredClasses = new HashMap();
        this.init();
    }

    public TLContext(int size) {
        this.registeredClasses = new HashMap(size);
        this.init();
    }

    protected abstract void init();

    public final boolean isSupportedObject(TLObject object) {
        return this.isSupportedObject(object.getConstructorId());
    }

    public final boolean isSupportedObject(int constructorId) {
        return this.registeredClasses.containsKey(constructorId);
    }

    public final <T extends TLObject> void registerClass(int constructorId, Class<T> clazz) {
        this.registeredClasses.put(constructorId, clazz);
    }

    public final TLObject deserializeMessage(byte[] data) throws IOException {
        return this.deserializeMessage(data, null, -1);
    }

    public final <T extends TLObject> T deserializeMessage(byte[] data, Class<T> clazz, int constructorId) throws IOException {
        return this.deserializeMessage(new ByteArrayInputStream(data), clazz, constructorId);
    }

    public final TLObject deserializeMessage(InputStream stream) throws IOException {
        return this.deserializeMessage(stream, null, -1);
    }

    public final <T extends TLObject> T deserializeMessage(InputStream stream, Class<T> clazz, int constructorId) throws DeserializationException, IOException {
        int realConstructorId = StreamUtils.readInt(stream);
        if (constructorId != -1 && realConstructorId != constructorId) {
            throw new InvalidConstructorIdException(realConstructorId, constructorId);
        }
        if (constructorId == -1) {
            constructorId = realConstructorId;
            clazz = null;
        }
        if (constructorId == 812830625) {
            return (T)this.deserializeMessage(this.unzipStream(stream));
        }
        if (constructorId == -1720552011) {
            return (T)TLBool.TRUE;
        }
        if (constructorId == -1132882121) {
            return (T)TLBool.FALSE;
        }
        if (constructorId == 481674261) {
            return (T)this.deserializeVectorBody(stream, new TLVector());
        }
        try {
            if (clazz == null && (clazz = this.registeredClasses.get(constructorId)) == null) {
                throw new UnsupportedConstructorException(constructorId);
            }
            TLObject message = (TLObject)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            message.deserializeBody(stream, this);
            return (T)message;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to deserialize data. This error should not happen", e);
        }
    }

    public final TLVector deserializeVector(InputStream stream) throws IOException {
        return this.deserializeVector(stream, new TLVector());
    }

    public final TLIntVector deserializeIntVector(InputStream stream) throws IOException {
        return (TLIntVector)this.deserializeVector(stream, new TLIntVector());
    }

    public final TLLongVector deserializeLongVector(InputStream stream) throws IOException {
        return (TLLongVector)this.deserializeVector(stream, new TLLongVector());
    }

    public final TLStringVector deserializeStringVector(InputStream stream) throws IOException {
        return (TLStringVector)this.deserializeVector(stream, new TLStringVector());
    }

    private TLVector<?> deserializeVector(InputStream stream, TLVector<?> vector) throws IOException {
        int constructorId = StreamUtils.readInt(stream);
        if (constructorId == 812830625) {
            return this.deserializeVector(this.unzipStream(stream));
        }
        if (constructorId == 481674261) {
            return this.deserializeVectorBody(stream, vector);
        }
        throw new InvalidConstructorIdException(constructorId, 481674261);
    }

    private TLVector<?> deserializeVectorBody(InputStream stream, TLVector<?> vector) throws IOException {
        vector.deserializeBody(stream, this);
        return vector;
    }

    private InputStream unzipStream(InputStream stream) throws IOException {
        TLGzipObject obj = new TLGzipObject();
        obj.deserializeBody(stream, this);
        ByteArrayInputStream packedDataStream = new ByteArrayInputStream(obj.getPackedData());
        return new BufferedInputStream(new GZIPInputStream(packedDataStream));
    }
}

