/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.mtproto.transport;

import com.github.badoualy.telegram.mtproto.DataCenter;
import com.github.badoualy.telegram.mtproto.transport.MTProtoConnection;
import com.github.badoualy.telegram.mtproto.util.Log;
import com.github.badoualy.telegram.tl.ByteBufferUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001a\u001a\u00020\u001bH\u0017J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0017J\b\u0010\u001f\u001a\u00020\tH\u0016J&\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00072\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u001dH\u0017J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\n \u0012*\u0004\u0018\u00010*0*2\u0006\u0010+\u001a\u00020\tH\u0016J\n\u0010,\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u0011H\u0002J\u0010\u0010/\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001dH\u0017R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/github/badoualy/telegram/mtproto/transport/MTProtoTcpConnection;", "Lcom/github/badoualy/telegram/mtproto/transport/MTProtoConnection;", "id", "", "ip", "", "port", "", "abridgedProtocol", "", "(JLjava/lang/String;IZ)V", "TAG", "getId", "()J", "getIp", "()Ljava/lang/String;", "msgHeaderBuffer", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "msgLengthBuffer", "getPort", "()I", "selectionKey", "Ljava/nio/channels/SelectionKey;", "socketChannel", "Ljava/nio/channels/SocketChannel;", "close", "", "executeMethod", "", "request", "isOpen", "readBytes", "length", "recycledBuffer", "order", "Ljava/nio/ByteOrder;", "readMessage", "register", "selector", "Ljava/nio/channels/Selector;", "setBlocking", "Ljava/nio/channels/SelectableChannel;", "blocking", "unregister", "writeBytes", "buffer", "writeMessage", "mtproto-compileKotlin"})
public final class MTProtoTcpConnection
implements MTProtoConnection {
    private final String TAG;
    private SocketChannel socketChannel;
    private final ByteBuffer msgHeaderBuffer;
    private final ByteBuffer msgLengthBuffer;
    private SelectionKey selectionKey;
    private final long id;
    @NotNull
    private final String ip;
    private final int port;

    @Override
    @NotNull
    public byte[] readMessage() throws IOException {
        int length = ByteBufferUtils.readByteAsInt((ByteBuffer)MTProtoTcpConnection.readBytes$default(this, 1, this.msgHeaderBuffer, null, 4, null));
        if (length == 127) {
            length = ByteBufferUtils.readInt24((ByteBuffer)MTProtoTcpConnection.readBytes$default(this, 3, this.msgLengthBuffer, null, 4, null));
        }
        Log.Companion.d$default(Log.Companion, this.TAG, "About to read a message of length " + length * 4, 0, 4, null);
        ByteBuffer buffer = MTProtoTcpConnection.readBytes$default(this, length * 4, null, null, 6, null);
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes, 0, buffer.remaining());
        return bytes;
    }

    @Override
    public void writeMessage(@NotNull byte[] request) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        int length = request.length / 4;
        int headerLength = length >= 127 ? 4 : 1;
        int totalLength = request.length + headerLength;
        ByteBuffer buffer = ByteBuffer.allocate(totalLength);
        if (headerLength == 4) {
            ByteBufferUtils.writeByte((int)127, (ByteBuffer)buffer);
            ByteBufferUtils.writeInt24((int)length, (ByteBuffer)buffer);
        } else {
            ByteBufferUtils.writeByte((int)length, (ByteBuffer)buffer);
        }
        buffer.put(request);
        buffer.flip();
        ByteBuffer byteBuffer = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
        this.writeBytes(byteBuffer);
    }

    @Override
    @NotNull
    public byte[] executeMethod(@NotNull byte[] request) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        this.writeMessage(request);
        return this.readMessage();
    }

    @Override
    @NotNull
    public SelectionKey register(@NotNull Selector selector) {
        Intrinsics.checkParameterIsNotNull((Object)selector, (String)"selector");
        this.socketChannel.configureBlocking(false);
        SelectionKey selectionKey = this.selectionKey = this.socketChannel.register(selector, 1);
        if (selectionKey == null) {
            Intrinsics.throwNpe();
        }
        return selectionKey;
    }

    @Override
    @Nullable
    public SelectionKey unregister() {
        Unit unit;
        SelectionKey selectionKey = this.selectionKey;
        Selector selector = selectionKey != null ? selectionKey.selector() : null;
        SelectionKey selectionKey2 = this.selectionKey;
        if (selectionKey2 != null) {
            selectionKey2.cancel();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        Selector selector2 = selector;
        Selector selector3 = selector2 != null ? selector2.wakeup() : null;
        this.socketChannel.configureBlocking(true);
        return this.selectionKey;
    }

    @Override
    public SelectableChannel setBlocking(boolean blocking) {
        return this.socketChannel.configureBlocking(blocking);
    }

    @Override
    public void close() throws IOException {
        Log.Companion.d$default(Log.Companion, this.TAG, "Closing connection", 0, 4, null);
        this.socketChannel.close();
    }

    @Override
    public boolean isOpen() {
        return this.socketChannel.isOpen() && this.socketChannel.isConnected();
    }

    private final ByteBuffer readBytes(int length, ByteBuffer recycledBuffer, ByteOrder order) {
        int read;
        ByteBuffer byteBuffer = recycledBuffer;
        Buffer buffer = byteBuffer != null ? byteBuffer.clear() : null;
        ByteBuffer byteBuffer2 = recycledBuffer;
        if (byteBuffer2 == null) {
            byteBuffer2 = ByteBuffer.allocate(length);
        }
        ByteBuffer buffer2 = byteBuffer2;
        buffer2.order(order);
        for (int totalRead = 0; totalRead < length; totalRead += read) {
            read = this.socketChannel.read(buffer2);
            if (read != -1) continue;
            throw (Throwable)new IOException("Reached end-of-stream");
        }
        buffer2.flip();
        ByteBuffer byteBuffer3 = buffer2;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer3, (String)"buffer");
        return byteBuffer3;
    }

    static /* bridge */ /* synthetic */ ByteBuffer readBytes$default(MTProtoTcpConnection mTProtoTcpConnection, int n, ByteBuffer byteBuffer, ByteOrder byteOrder, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readBytes");
        }
        if ((n2 & 2) != 0) {
            byteBuffer = null;
        }
        if ((n2 & 4) != 0) {
            ByteOrder byteOrder2 = ByteOrder.BIG_ENDIAN;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteOrder2, (String)"ByteOrder.BIG_ENDIAN");
            byteOrder = byteOrder2;
        }
        return mTProtoTcpConnection.readBytes(n, byteBuffer, byteOrder);
    }

    private final void writeBytes(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            this.socketChannel.write(buffer);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getIp() {
        return this.ip;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @JvmOverloads
    public MTProtoTcpConnection(long id, @NotNull String ip, int port, boolean abridgedProtocol) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)ip, (String)"ip");
        this.id = id;
        this.ip = ip;
        this.port = port;
        this.TAG = "MTProtoTcpConnection#" + this.getId();
        this.msgHeaderBuffer = ByteBuffer.allocate(1);
        this.msgLengthBuffer = ByteBuffer.allocate(3);
        int attempt = 0;
        while (true) {
            Intrinsics.checkExpressionValueIsNotNull((Object)SocketChannel.open(), (String)"SocketChannel.open()");
            this.socketChannel = this.socketChannel;
            this.socketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
            this.socketChannel.configureBlocking(true);
            try {
                this.socketChannel.connect(new InetSocketAddress(this.getIp(), this.getPort()));
                this.socketChannel.finishConnect();
                if (abridgedProtocol) {
                    this.socketChannel.write(ByteBuffer.wrap(new byte[]{(byte)239}));
                }
                Log.Companion.d$default(Log.Companion, this.TAG, "Connected to " + this.getIp() + ":" + this.getPort() + " " + this.socketChannel.isConnected() + " " + this.socketChannel.isOpen(), 0, 4, null);
            }
            catch (Exception e) {
                if (attempt++ < 1) continue;
            }
            break;
        }
    }

    @JvmOverloads
    public /* synthetic */ MTProtoTcpConnection(long l, String string, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) throws IOException {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        this(l, string, n, bl);
    }

    @JvmOverloads
    public MTProtoTcpConnection(long id, @NotNull String ip, int port) throws IOException {
        this(id, ip, port, false, 8, null);
    }

    @Override
    @NotNull
    public DataCenter getDataCenter() {
        return MTProtoConnection.DefaultImpls.getDataCenter(this);
    }
}

