/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.mtproto.time;

import com.github.badoualy.telegram.mtproto.DataCenter;
import com.github.badoualy.telegram.mtproto.util.Log;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0005J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0006J\u0016\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0006R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/github/badoualy/telegram/mtproto/time/TimeOverlord;", "", "()V", "deltaMap", "Ljava/util/HashMap;", "Lcom/github/badoualy/telegram/mtproto/DataCenter;", "", "localTime", "getLocalTime", "()J", "generateMessageId", "dataCenter", "getServerTime", "setServerTime", "", "serverTime", "synchronizeTime", "messageId", "mtproto-compileKotlin"})
public final class TimeOverlord {
    private static final HashMap<DataCenter, Long> deltaMap;
    public static final TimeOverlord INSTANCE;

    private final long getLocalTime() {
        return System.currentTimeMillis();
    }

    public final long getServerTime(@NotNull DataCenter dataCenter) {
        Intrinsics.checkParameterIsNotNull((Object)dataCenter, (String)"dataCenter");
        return this.getLocalTime() + ((Number)deltaMap.getOrDefault(dataCenter, 0L)).longValue();
    }

    public final long generateMessageId(@NotNull DataCenter dataCenter) {
        Intrinsics.checkParameterIsNotNull((Object)dataCenter, (String)"dataCenter");
        return this.getServerTime(dataCenter) / (long)1000 << 32;
    }

    public final void setServerTime(@NotNull DataCenter dataCenter, long serverTime) {
        Intrinsics.checkParameterIsNotNull((Object)dataCenter, (String)"dataCenter");
        deltaMap.put(dataCenter, serverTime - this.getLocalTime());
        Log.Companion.e$default(Log.Companion, "TimeOverlord", "New time delta is " + deltaMap.get(dataCenter), null, 0, 12, null);
    }

    public final void synchronizeTime(@NotNull DataCenter dataCenter, long messageId) {
        Intrinsics.checkParameterIsNotNull((Object)dataCenter, (String)"dataCenter");
        this.setServerTime(dataCenter, (messageId >>> 32) * (long)1000);
    }

    private TimeOverlord() {
        INSTANCE = this;
        deltaMap = new HashMap();
    }

    static {
        new TimeOverlord();
    }
}

