/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.mtproto.auth;

import com.github.badoualy.telegram.mtproto.DataCenter;
import com.github.badoualy.telegram.mtproto.auth.AuthKey;
import com.github.badoualy.telegram.mtproto.auth.AuthResult;
import com.github.badoualy.telegram.mtproto.auth.TempAuthKey;
import com.github.badoualy.telegram.mtproto.exception.AuthorizationException;
import com.github.badoualy.telegram.mtproto.exception.FingerprintNotFoundException;
import com.github.badoualy.telegram.mtproto.exception.SecurityException;
import com.github.badoualy.telegram.mtproto.secure.CryptoUtils;
import com.github.badoualy.telegram.mtproto.secure.Key;
import com.github.badoualy.telegram.mtproto.secure.RandomUtils;
import com.github.badoualy.telegram.mtproto.secure.pq.PQSolver;
import com.github.badoualy.telegram.mtproto.time.TimeOverlord;
import com.github.badoualy.telegram.mtproto.tl.auth.ClientDhInner;
import com.github.badoualy.telegram.mtproto.tl.auth.DhGenFailure;
import com.github.badoualy.telegram.mtproto.tl.auth.DhGenOk;
import com.github.badoualy.telegram.mtproto.tl.auth.DhGenResult;
import com.github.badoualy.telegram.mtproto.tl.auth.DhGenRetry;
import com.github.badoualy.telegram.mtproto.tl.auth.PQInner;
import com.github.badoualy.telegram.mtproto.tl.auth.PQInnerTemp;
import com.github.badoualy.telegram.mtproto.tl.auth.ReqDhParams;
import com.github.badoualy.telegram.mtproto.tl.auth.ReqPQ;
import com.github.badoualy.telegram.mtproto.tl.auth.ReqSetDhClientParams;
import com.github.badoualy.telegram.mtproto.tl.auth.ResPQ;
import com.github.badoualy.telegram.mtproto.tl.auth.ServerDhFailure;
import com.github.badoualy.telegram.mtproto.tl.auth.ServerDhInner;
import com.github.badoualy.telegram.mtproto.tl.auth.ServerDhOk;
import com.github.badoualy.telegram.mtproto.tl.auth.ServerDhParams;
import com.github.badoualy.telegram.mtproto.tl.auth.TlAuthContext;
import com.github.badoualy.telegram.mtproto.transport.MTProtoConnection;
import com.github.badoualy.telegram.mtproto.transport.MTProtoTcpConnection;
import com.github.badoualy.telegram.mtproto.util.Log;
import com.github.badoualy.telegram.mtproto.util.Pair;
import com.github.badoualy.telegram.mtproto.util.SolvedPQ;
import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0003J4\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0003J\u001a\u0010 \u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\"\u001a\u00020\u0004H\u0007J%\u0010#\u001a\u0002H$\"\b\b\u0000\u0010$*\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H$0'H\u0003\u00a2\u0006\u0002\u0010(J6\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020*0\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020-2\b\b\u0001\u0010.\u001a\u00020*H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/github/badoualy/telegram/mtproto/auth/AuthKeyCreation;", "", "()V", "AUTH_ATTEMPT_COUNT", "", "AUTH_RETRY_COUNT", "TAG", "", "TEMPORARY_KEY_DEFAULT_EXPIRE_DELAY", "authContext", "Lcom/github/badoualy/telegram/mtproto/tl/auth/TlAuthContext;", "connection", "Lcom/github/badoualy/telegram/mtproto/transport/MTProtoConnection;", "tmpKeyExpireDelay", "createAuthKey", "Lcom/github/badoualy/telegram/mtproto/auth/AuthResult;", "dataCenter", "Lcom/github/badoualy/telegram/mtproto/DataCenter;", "createAuthKeyInternal", "tmpKey", "", "createKey", "createStep4Request", "Lcom/github/badoualy/telegram/mtproto/util/Pair;", "Lcom/github/badoualy/telegram/mtproto/tl/auth/ReqDhParams;", "", "resPQ", "Lcom/github/badoualy/telegram/mtproto/tl/auth/ResPQ;", "pq", "Lcom/github/badoualy/telegram/mtproto/util/SolvedPQ;", "publicKey", "Lcom/github/badoualy/telegram/mtproto/secure/Key;", "createTmpAuthKey", "", "expireDelay", "executeMethod", "T", "Lcom/github/badoualy/telegram/tl/core/TLObject;", "method", "Lcom/github/badoualy/telegram/tl/core/TLMethod;", "(Lcom/github/badoualy/telegram/tl/core/TLMethod;)Lcom/github/badoualy/telegram/tl/core/TLObject;", "lastStep", "", "newNonce", "serverDhOk", "Lcom/github/badoualy/telegram/mtproto/tl/auth/ServerDhOk;", "step4Duration", "mtproto-compileKotlin"})
public final class AuthKeyCreation {
    private static final String TAG = "AuthKeyCreation";
    private static final int AUTH_ATTEMPT_COUNT = 5;
    private static final int AUTH_RETRY_COUNT = 5;
    private static final int TEMPORARY_KEY_DEFAULT_EXPIRE_DELAY = 86400;
    private static MTProtoConnection connection;
    private static final TlAuthContext authContext;
    private static int tmpKeyExpireDelay;
    public static final AuthKeyCreation INSTANCE;

    @JvmStatic
    @Nullable
    public static final AuthResult createAuthKey(@NotNull DataCenter dataCenter) {
        Intrinsics.checkParameterIsNotNull((Object)dataCenter, (String)"dataCenter");
        return INSTANCE.createAuthKeyInternal(dataCenter, false);
    }

    @JvmStatic
    @JvmOverloads
    public static final void createTmpAuthKey(@NotNull DataCenter dataCenter, int expireDelay) {
        Intrinsics.checkParameterIsNotNull((Object)dataCenter, (String)"dataCenter");
        tmpKeyExpireDelay = expireDelay;
        INSTANCE.createAuthKeyInternal(dataCenter, true);
    }

    @JvmStatic
    @JvmOverloads
    public static /* bridge */ /* synthetic */ void createTmpAuthKey$default(DataCenter dataCenter, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createTmpAuthKey");
        }
        if ((n2 & 2) != 0) {
            n = TEMPORARY_KEY_DEFAULT_EXPIRE_DELAY;
        }
        AuthKeyCreation.createTmpAuthKey(dataCenter, n);
    }

    @JvmStatic
    @JvmOverloads
    public static void createTmpAuthKey(@NotNull DataCenter dataCenter) {
        AuthKeyCreation.createTmpAuthKey$default(dataCenter, 0, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final AuthResult createAuthKeyInternal(DataCenter dataCenter, boolean tmpKey) {
        long start2 = System.currentTimeMillis();
        int n = 0;
        int n2 = AUTH_ATTEMPT_COUNT - 1;
        if (n <= n2) {
            while (true) {
                void $receiver$iv;
                Throwable e12;
                void $receiver$iv2;
                void i;
                try {
                    connection = new MTProtoTcpConnection(-1L, dataCenter.getIp(), dataCenter.getPort(), false, 8, null);
                    AuthResult authResult = this.createKey(tmpKey);
                    Log.Companion.d$default(Log.Companion, TAG, "Key created after " + (int)(i + true) + " attempt in " + (System.currentTimeMillis() - start2) + " ms", 0, 4, null);
                    connection = null;
                    return authResult;
                }
                catch (FingerprintNotFoundException e) {
                    try {
                        MTProtoConnection mTProtoConnection = connection;
                        if (mTProtoConnection == null) {
                            Intrinsics.throwNpe();
                        }
                        mTProtoConnection.close();
                    }
                    catch (IOException e12) {
                        Throwable throwable = e12;
                        void v1 = $receiver$iv2;
                        if (v1 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                        }
                        ((Throwable)v1).printStackTrace();
                    }
                    e12 = e;
                    void v2 = $receiver$iv;
                    if (v2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                    }
                    ((Throwable)v2).printStackTrace();
                }
                catch (IOException e) {
                    try {
                        MTProtoConnection mTProtoConnection = connection;
                        if (mTProtoConnection == null) {
                            Intrinsics.throwNpe();
                        }
                        mTProtoConnection.close();
                    }
                    catch (IOException e13) {
                        Throwable $i$f$printStackTrace = e13;
                        void v4 = $receiver$iv2;
                        if (v4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                        }
                        ((Throwable)v4).printStackTrace();
                    }
                    e12 = e;
                    void v5 = $receiver$iv;
                    if (v5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                    }
                    ((Throwable)v5).printStackTrace();
                }
                if (i == n2) break;
                ++i;
            }
        }
        Log.Companion.e$default(Log.Companion, TAG, "Key creation failed " + AUTH_ATTEMPT_COUNT + " times", null, 0, 12, null);
        connection = null;
        return null;
    }

    private final <T extends TLObject> T executeMethod(TLMethod<T> method) throws IOException {
        MTProtoConnection mTProtoConnection = connection;
        if (mTProtoConnection == null) {
            Intrinsics.throwNpe();
        }
        long requestMessageId = TimeOverlord.INSTANCE.generateMessageId(mTProtoConnection.getDataCenter());
        byte[] data = method.serialize();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtils.writeLong((long)0L, (OutputStream)out);
        StreamUtils.writeLong((long)requestMessageId, (OutputStream)out);
        StreamUtils.writeInt((int)data.length, (OutputStream)out);
        StreamUtils.writeByteArray((byte[])data, (OutputStream)out);
        MTProtoConnection mTProtoConnection2 = connection;
        if (mTProtoConnection2 == null) {
            Intrinsics.throwNpe();
        }
        byte[] byArray = out.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"out.toByteArray()");
        byte[] response = mTProtoConnection2.executeMethod(byArray);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(response);
        long authId = StreamUtils.readLong((InputStream)inputStream);
        if (authId == 0L) {
            long messageId = StreamUtils.readLong((InputStream)inputStream);
            int length = StreamUtils.readInt((InputStream)inputStream);
            byte[] messageResponse = StreamUtils.readBytes((int)length, (InputStream)inputStream);
            TLObject tLObject = method.deserializeResponse(messageResponse, (TLContext)authContext);
            Intrinsics.checkExpressionValueIsNotNull((Object)tLObject, (String)"method.deserializeRespon\u2026ageResponse, authContext)");
            return (T)tLObject;
        }
        throw (Throwable)new IOException("Auth id must be equal to zero");
    }

    private final Pair<ReqDhParams, byte[]> createStep4Request(ResPQ resPQ, SolvedPQ pq, Key publicKey2, boolean tmpKey) throws IOException {
        PQInner pQInner;
        byte[] newNonce = RandomUtils.Companion.randomInt256();
        if (tmpKey) {
            byte[] byArray = resPQ.getPq();
            byte[] byArray2 = CryptoUtils.fromBigInt(pq.getP());
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"fromBigInt(pq.p)");
            byte[] byArray3 = CryptoUtils.fromBigInt(pq.getQ());
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"fromBigInt(pq.q)");
            pQInner = new PQInnerTemp(byArray, byArray2, byArray3, resPQ.getNonce(), resPQ.getServerNonce(), newNonce, tmpKeyExpireDelay);
        } else {
            byte[] byArray = resPQ.getPq();
            byte[] byArray4 = CryptoUtils.fromBigInt(pq.getP());
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"fromBigInt(pq.p)");
            byte[] byArray5 = CryptoUtils.fromBigInt(pq.getQ());
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray5, (String)"fromBigInt(pq.q)");
            pQInner = new PQInner(byArray, byArray4, byArray5, resPQ.getNonce(), resPQ.getServerNonce(), newNonce);
        }
        PQInner pqInnerData = pQInner;
        byte[] data = pqInnerData.serialize();
        byte[] hash = CryptoUtils.SHA1(data);
        int paddingSize = 255 - (data.length + hash.length);
        byte[] padding = paddingSize > 0 ? RandomUtils.Companion.randomByteArray(paddingSize) : new byte[]{};
        byte[] dataWithHash = CryptoUtils.concat(hash, data, padding);
        byte[] encryptedData = CryptoUtils.RSA(dataWithHash, publicKey2.getPublicKey(), publicKey2.getExponent());
        byte[] byArray = resPQ.getNonce();
        byte[] byArray6 = resPQ.getServerNonce();
        byte[] byArray7 = CryptoUtils.fromBigInt(pq.getP());
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray7, (String)"fromBigInt(pq.p)");
        byte[] byArray8 = CryptoUtils.fromBigInt(pq.getQ());
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray8, (String)"fromBigInt(pq.q)");
        long l = publicKey2.getFingerprint();
        Intrinsics.checkExpressionValueIsNotNull((Object)encryptedData, (String)"encryptedData");
        ReqDhParams reqDhParams = new ReqDhParams(byArray, byArray6, byArray7, byArray8, l, encryptedData);
        return Pair.Companion.create(reqDhParams, newNonce);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<byte[], Long> lastStep(ResPQ resPQ, byte[] newNonce, ServerDhOk serverDhOk, long step4Duration) throws IOException {
        byte[] encryptedAnswer = serverDhOk.getEncryptedAnswer();
        byte[] tmpAesKey = CryptoUtils.concat(CryptoUtils.SHA1(newNonce, resPQ.getServerNonce()), CryptoUtils.substring(CryptoUtils.SHA1(resPQ.getServerNonce(), newNonce), 0, 12));
        byte[] tmpAesIv = CryptoUtils.concat(CryptoUtils.concat(CryptoUtils.substring(CryptoUtils.SHA1(resPQ.getServerNonce(), newNonce), 12, 8), CryptoUtils.SHA1(newNonce, newNonce)), CryptoUtils.substring(newNonce, 0, 4));
        byte[] answer = CryptoUtils.AES256IGEDecrypt(encryptedAnswer, tmpAesIv, tmpAesKey);
        ByteArrayInputStream stream = new ByteArrayInputStream(answer);
        byte[] answerHash = StreamUtils.readBytes((int)20, (InputStream)stream);
        TLObject tLObject = authContext.deserializeMessage(stream);
        if (tLObject == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.github.badoualy.telegram.mtproto.tl.auth.ServerDhInner");
        }
        ServerDhInner dhInner = (ServerDhInner)tLObject;
        if (!Arrays.equals(answerHash, CryptoUtils.SHA1(dhInner.serialize()))) {
            throw (Throwable)new SecurityException();
        }
        MTProtoConnection mTProtoConnection = connection;
        if (mTProtoConnection == null) {
            Intrinsics.throwNpe();
        }
        TimeOverlord.INSTANCE.setServerTime(mTProtoConnection.getDataCenter(), (long)dhInner.getServerTime() * 1000L);
        int n = 0;
        int n2 = AUTH_RETRY_COUNT - 1;
        if (n <= n2) {
            while (true) {
                byte[] newNonceHash;
                void i;
                BigInteger b = CryptoUtils.loadBigInt(RandomUtils.Companion.randomByteArray(256));
                BigInteger g = new BigInteger(String.valueOf(dhInner.getG()));
                BigInteger dhPrime = CryptoUtils.loadBigInt(dhInner.getDhPrime());
                BigInteger gb = g.modPow(b, dhPrime);
                BigInteger authKeyVal = CryptoUtils.loadBigInt(dhInner.getG_a()).modPow(b, dhPrime);
                byte[] authKey = CryptoUtils.alignKeyZero(CryptoUtils.fromBigInt(authKeyVal), 256);
                byte[] authAuxHash = CryptoUtils.substring(CryptoUtils.SHA1(authKey), 0, 8);
                byte[] byArray = resPQ.getNonce();
                byte[] byArray2 = resPQ.getServerNonce();
                long l = (long)i;
                byte[] byArray3 = CryptoUtils.fromBigInt(gb);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"fromBigInt(gb)");
                ClientDhInner clientDHInner = new ClientDhInner(byArray, byArray2, l, byArray3);
                byte[] innerData = clientDHInner.serialize();
                byte[] innerDataWithHash = CryptoUtils.align(CryptoUtils.concat(CryptoUtils.SHA1(innerData), innerData), 16);
                byte[] dataWithHashEnc = CryptoUtils.AES256IGEEncrypt(innerDataWithHash, tmpAesIv, tmpAesKey);
                byte[] byArray4 = resPQ.getNonce();
                byte[] byArray5 = resPQ.getServerNonce();
                Intrinsics.checkExpressionValueIsNotNull((Object)dataWithHashEnc, (String)"dataWithHashEnc");
                DhGenResult result = (DhGenResult)((Object)this.executeMethod(new ReqSetDhClientParams(byArray4, byArray5, dataWithHashEnc)));
                if (result instanceof DhGenOk) {
                    newNonceHash = CryptoUtils.substring(CryptoUtils.SHA1(newNonce, {1}, authAuxHash), 4, 16);
                    if (!Arrays.equals(result.getNewNonceHash(), newNonceHash)) {
                        throw (Throwable)new SecurityException();
                    }
                    long serverSalt = StreamUtils.readLong((byte[])CryptoUtils.xor(CryptoUtils.substring(newNonce, 0, 8), CryptoUtils.substring(resPQ.getServerNonce(), 0, 8)), (int)0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)authKey, (String)"authKey");
                    return new Pair<byte[], Long>(authKey, serverSalt);
                }
                if (result instanceof DhGenRetry) {
                    newNonceHash = CryptoUtils.substring(CryptoUtils.SHA1(newNonce, {2}, authAuxHash), 4, 16);
                    if (!Arrays.equals(result.getNewNonceHash(), newNonceHash)) {
                        throw (Throwable)new SecurityException();
                    }
                } else if (result instanceof DhGenFailure) {
                    newNonceHash = CryptoUtils.substring(CryptoUtils.SHA1(newNonce, {3}, authAuxHash), 4, 16);
                    if (!Arrays.equals(result.getNewNonceHash(), newNonceHash)) {
                        throw (Throwable)new SecurityException();
                    }
                    throw (Throwable)new AuthorizationException();
                }
                if (i == n2) break;
                ++i;
            }
        }
        throw (Throwable)new AuthorizationException();
    }

    private final AuthResult createKey(boolean tmpKey) throws IOException, FingerprintNotFoundException {
        AuthKey authKey;
        Log.Companion.d$default(Log.Companion, TAG, "Attempting to create a " + (tmpKey ? "temporary " : "permanent") + " Authorization Key", 0, 4, null);
        byte[] nonce = RandomUtils.Companion.randomInt128();
        ResPQ resPQ = (ResPQ)((Object)this.executeMethod(new ReqPQ(nonce)));
        Log.Companion.d$default(Log.Companion, TAG, "Got resPQ with " + resPQ.getFingerprints().size() + " fingerprints", 0, 4, null);
        Log.Companion.d$default(Log.Companion, TAG, "Step1 done", 0, 4, null);
        Key publicKey2 = (Key)Arrays.stream((Object[])Key.AVAILABLE_KEYS).filter(new Predicate<? super T>(resPQ){
            final /* synthetic */ ResPQ $resPQ;

            public final boolean test(Key k) {
                return this.$resPQ.getFingerprints().contains((Object)k.getFingerprint());
            }
            {
                this.$resPQ = resPQ;
            }
        }).findFirst().orElseThrow(new Supplier<? extends X>(resPQ){
            final /* synthetic */ ResPQ $resPQ;

            @NotNull
            public final FingerprintNotFoundException get() {
                return new FingerprintNotFoundException(CollectionsKt.joinToString$default((Iterable)((Iterable)this.$resPQ.getFingerprints()), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            }
            {
                this.$resPQ = resPQ;
            }
        });
        Log.Companion.d$default(Log.Companion, TAG, "Step2 done", 0, 4, null);
        SolvedPQ solvedPQ = PQSolver.Companion.solve(new BigInteger(1, resPQ.getPq()));
        Log.Companion.d$default(Log.Companion, TAG, "Step3 done", 0, 4, null);
        Key key = publicKey2;
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"publicKey");
        Pair<ReqDhParams, byte[]> pair = this.createStep4Request(resPQ, solvedPQ, key, tmpKey);
        ReqDhParams reqDhParams = pair.getFirst();
        byte[] newNonce = pair.getSecond();
        Log.Companion.d$default(Log.Companion, TAG, "Step4 request created", 0, 4, null);
        long start2 = System.nanoTime();
        ServerDhParams dhParams = (ServerDhParams)((Object)this.executeMethod(reqDhParams));
        long step4Duration = (System.nanoTime() - start2) / (long)1000000;
        Log.Companion.d$default(Log.Companion, TAG, "Step4 done", 0, 4, null);
        if (dhParams instanceof ServerDhFailure) {
            if (Arrays.equals(((ServerDhFailure)dhParams).getNewNonceHash(), CryptoUtils.SHA1(newNonce))) {
                throw (Throwable)new AuthorizationException("Received " + dhParams.toString());
            }
            throw (Throwable)new SecurityException("Received " + dhParams.toString() + " with incorrect hash");
        }
        ServerDhParams serverDhParams = dhParams;
        if (serverDhParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.github.badoualy.telegram.mtproto.tl.auth.ServerDhOk");
        }
        ServerDhOk serverDhParams2 = (ServerDhOk)serverDhParams;
        Log.Companion.d$default(Log.Companion, TAG, "Step5 done", 0, 4, null);
        Pair<byte[], Long> keySaltPair = this.lastStep(resPQ, newNonce, serverDhParams2, step4Duration);
        Log.Companion.d$default(Log.Companion, TAG, "Step6 to 9 done", 0, 4, null);
        if (!tmpKey) {
            authKey = new AuthKey(keySaltPair.getFirst());
        } else {
            MTProtoConnection mTProtoConnection = connection;
            if (mTProtoConnection == null) {
                Intrinsics.throwNpe();
            }
            authKey = new TempAuthKey(keySaltPair.getFirst(), (int)TimeOverlord.INSTANCE.getServerTime(mTProtoConnection.getDataCenter()) + tmpKeyExpireDelay);
        }
        AuthKey authKey2 = authKey;
        long l = ((Number)keySaltPair.getSecond()).longValue();
        MTProtoConnection mTProtoConnection = connection;
        if (mTProtoConnection == null) {
            Intrinsics.throwNpe();
        }
        return new AuthResult(authKey2, l, mTProtoConnection);
    }

    private AuthKeyCreation() {
        INSTANCE = this;
        TAG = TAG;
        AUTH_ATTEMPT_COUNT = 5;
        AUTH_RETRY_COUNT = 5;
        TEMPORARY_KEY_DEFAULT_EXPIRE_DELAY = 86400;
        authContext = TlAuthContext.INSTANCE;
        tmpKeyExpireDelay = TEMPORARY_KEY_DEFAULT_EXPIRE_DELAY;
    }

    static {
        new AuthKeyCreation();
    }
}

