/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.mtproto.auth;

import com.github.badoualy.telegram.mtproto.secure.CryptoUtils;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/github/badoualy/telegram/mtproto/auth/AuthKey;", "", "key", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "", "([B)V", "getKey", "()[B", "keyId", "kotlin.jvm.PlatformType", "getKeyId", "getKeyIdAsLong", "", "mtproto-compileKotlin"})
public class AuthKey {
    private final byte[] keyId;
    @NotNull
    private final byte[] key;

    public final byte[] getKeyId() {
        return this.keyId;
    }

    public final long getKeyIdAsLong() {
        return new BigInteger(this.keyId).longValueExact();
    }

    @NotNull
    public final byte[] getKey() {
        return this.key;
    }

    public AuthKey(@NotNull byte[] key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.key = key;
        if (this.key.length != 256) {
            throw (Throwable)new RuntimeException("AuthKey must be 256 Bytes found " + this.key.length + " bytes");
        }
        this.keyId = CryptoUtils.substring(CryptoUtils.SHA1(this.key), 12, 8);
    }

    public AuthKey(@NotNull ByteBuffer key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        byte[] byArray = key.array();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"key.array()");
        this(byArray);
    }
}

