/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.mtproto;

import com.github.badoualy.telegram.mtproto.transport.MTProtoConnection;
import com.github.badoualy.telegram.mtproto.util.Log;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import rx.Observable;
import rx.Subscriber;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\tH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0016J2\u0010\u001e\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00180\u0018 \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00180\u0018\u0018\u00010\u001f0\u001f2\u0006\u0010\u001c\u001a\u00020\tJ\u000e\u0010 \u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\t0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u000e*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u00180\u00170\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/github/badoualy/telegram/mtproto/MTProtoWatchdog;", "Ljava/lang/Runnable;", "()V", "SELECT_TIMEOUT_DELAY", "", "TAG", "", "connectionList", "Ljava/util/ArrayList;", "Lcom/github/badoualy/telegram/mtproto/transport/MTProtoConnection;", "dirty", "", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "keyMap", "Ljava/util/HashMap;", "Ljava/nio/channels/SelectionKey;", "pool", "running", "selector", "Ljava/nio/channels/Selector;", "subscriberMap", "Lrx/Subscriber;", "", "cleanUp", "", "readMessage", "connection", "run", "start", "Lrx/Observable;", "stop", "mtproto-compileKotlin"})
public final class MTProtoWatchdog
implements Runnable {
    private static final String TAG = "MTProtoWatchdog";
    private static final long SELECT_TIMEOUT_DELAY = 10000L;
    private static final Selector selector;
    private static final HashMap<SelectionKey, MTProtoConnection> keyMap;
    private static final ArrayList<MTProtoConnection> connectionList;
    private static final HashMap<MTProtoConnection, Subscriber<? super byte[]>> subscriberMap;
    private static final ExecutorService executor;
    private static final ExecutorService pool;
    private static boolean dirty;
    private static boolean running;
    public static final MTProtoWatchdog INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        while (true) {
            Object element$iv;
            Iterator $receiver$iv$iv;
            Iterable $receiver$iv;
            MTProtoWatchdog lock$iv;
            if (dirty) {
                lock$iv = this;
                synchronized (lock$iv) {
                    void destination$iv$iv;
                    $receiver$iv = connectionList;
                    Iterable iterable = $receiver$iv;
                    Collection collection = new ArrayList();
                    Iterator iterator = $receiver$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv$iv = iterator.next();
                        MTProtoConnection it = (MTProtoConnection)element$iv$iv;
                        if (keyMap.containsValue(it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv.iterator();
                    while ($receiver$iv$iv.hasNext()) {
                        element$iv = $receiver$iv$iv.next();
                        MTProtoConnection it = (MTProtoConnection)element$iv;
                        Selector selector = MTProtoWatchdog.selector;
                        Intrinsics.checkExpressionValueIsNotNull((Object)selector, (String)"selector");
                        keyMap.put(it.register(selector), it);
                    }
                    dirty = false;
                    $receiver$iv = Unit.INSTANCE;
                }
            }
            if (selector.select(SELECT_TIMEOUT_DELAY) > 0) {
                lock$iv = this;
                synchronized (lock$iv) {
                    $receiver$iv = selector.selectedKeys();
                    $receiver$iv$iv = $receiver$iv.iterator();
                    while ($receiver$iv$iv.hasNext()) {
                        element$iv = $receiver$iv$iv.next();
                        SelectionKey key = (SelectionKey)element$iv;
                        key.interestOps(0);
                        MTProtoConnection connection = keyMap.get(key);
                        if (connection == null) continue;
                        pool.execute(new Runnable(connection, key){
                            final /* synthetic */ MTProtoConnection $connection;
                            final /* synthetic */ SelectionKey $key;

                            public final void run() {
                                if (!this.$connection.isOpen()) {
                                    return;
                                }
                                boolean wentGood = MTProtoWatchdog.access$readMessage(MTProtoWatchdog.INSTANCE, this.$connection);
                                if (wentGood && this.$key.isValid()) {
                                    this.$key.interestOps(1);
                                    MTProtoWatchdog.access$getSelector$p(MTProtoWatchdog.INSTANCE).wakeup();
                                } else if (!wentGood) {
                                    MTProtoWatchdog.INSTANCE.stop(this.$connection);
                                }
                            }
                            {
                                this.$connection = mTProtoConnection;
                                this.$key = selectionKey;
                            }
                        });
                    }
                    $receiver$iv = Unit.INSTANCE;
                }
                selector.selectedKeys().clear();
            }
            if (!connectionList.isEmpty()) continue;
            lock$iv = this;
            synchronized (lock$iv) {
                if (connectionList.isEmpty()) {
                    running = false;
                    Log.Companion.d$default(Log.Companion, TAG, "Stopping watchdog...", 0, 4, null);
                    return;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    private final boolean readMessage(MTProtoConnection connection) {
        Subscriber<? super byte[]> subscriber = subscriberMap.get(connection);
        if (subscriber == null || subscriber.isUnsubscribed() || !connectionList.contains(connection)) {
            Log.Companion.e$default(Log.Companion, TAG + connection.getId(), "Subscribed already unsubscribed, dropping", null, 0, 12, null);
            return false;
        }
        try {
            byte[] message = connection.readMessage();
            Log.Companion.d$default(Log.Companion, TAG + connection.getId(), "New message of length: " + message.length, 0, 4, null);
            subscriber.onNext((Object)message);
        }
        catch (IOException e) {
            if (!subscriber.isUnsubscribed()) {
                Log.Companion.e$default(Log.Companion, TAG + connection.getId(), "Sending exception to subscriber", null, 0, 12, null);
                subscriber.onError((Throwable)e);
            }
            return false;
        }
        return true;
    }

    public final Observable<byte[]> start(@NotNull MTProtoConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(connection){
            final /* synthetic */ MTProtoConnection $connection;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void call(Subscriber<? super byte[]> s) {
                MTProtoWatchdog lock$iv = MTProtoWatchdog.INSTANCE;
                synchronized (lock$iv) {
                    MTProtoWatchdog.access$getConnectionList$p(MTProtoWatchdog.INSTANCE).add(this.$connection);
                    MTProtoWatchdog.access$getSubscriberMap$p(MTProtoWatchdog.INSTANCE).put(this.$connection, s);
                    MTProtoWatchdog.access$setDirty$p(MTProtoWatchdog.INSTANCE, true);
                    if (!MTProtoWatchdog.access$getRunning$p(MTProtoWatchdog.INSTANCE)) {
                        MTProtoWatchdog.access$setRunning$p(MTProtoWatchdog.INSTANCE, true);
                        MTProtoWatchdog.access$getExecutor$p(MTProtoWatchdog.INSTANCE).execute(MTProtoWatchdog.INSTANCE);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                MTProtoWatchdog.access$getSelector$p(MTProtoWatchdog.INSTANCE).wakeup();
            }
            {
                this.$connection = mTProtoConnection;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(@NotNull MTProtoConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        MTProtoWatchdog lock$iv = this;
        synchronized (lock$iv) {
            Unit unit;
            Subscriber<? super byte[]> subscriber;
            connectionList.remove(connection);
            Subscriber<? super byte[]> subscriber2 = subscriber = subscriberMap.remove(connection);
            if (subscriber2 != null) {
                subscriber2.unsubscribe();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            SelectionKey key = connection.unregister();
            if (key != null) {
                keyMap.remove(key);
            }
            Unit unit2 = Unit.INSTANCE;
        }
    }

    public final void cleanUp() {
        executor.shutdownNow();
        pool.shutdownNow();
    }

    private MTProtoWatchdog() {
        INSTANCE = this;
        TAG = TAG;
        SELECT_TIMEOUT_DELAY = (long)10 * 1000L;
        selector = Selector.open();
        keyMap = new HashMap();
        connectionList = new ArrayList();
        subscriberMap = new HashMap();
        executor = Executors.newSingleThreadExecutor();
        pool = Executors.newCachedThreadPool();
    }

    static {
        new MTProtoWatchdog();
    }

    public static final /* synthetic */ boolean access$readMessage(MTProtoWatchdog $this, @NotNull MTProtoConnection connection) {
        return $this.readMessage(connection);
    }

    public static final /* synthetic */ Selector access$getSelector$p(MTProtoWatchdog $this) {
        MTProtoWatchdog mTProtoWatchdog = $this;
        return selector;
    }

    @NotNull
    public static final /* synthetic */ ArrayList access$getConnectionList$p(MTProtoWatchdog $this) {
        MTProtoWatchdog mTProtoWatchdog = $this;
        return connectionList;
    }

    @NotNull
    public static final /* synthetic */ HashMap access$getSubscriberMap$p(MTProtoWatchdog $this) {
        MTProtoWatchdog mTProtoWatchdog = $this;
        return subscriberMap;
    }

    public static final /* synthetic */ boolean access$getDirty$p(MTProtoWatchdog $this) {
        MTProtoWatchdog mTProtoWatchdog = $this;
        return dirty;
    }

    public static final /* synthetic */ void access$setDirty$p(MTProtoWatchdog $this, boolean bl) {
        MTProtoWatchdog mTProtoWatchdog = $this;
        dirty = bl;
    }

    public static final /* synthetic */ boolean access$getRunning$p(MTProtoWatchdog $this) {
        MTProtoWatchdog mTProtoWatchdog = $this;
        return running;
    }

    public static final /* synthetic */ void access$setRunning$p(MTProtoWatchdog $this, boolean bl) {
        MTProtoWatchdog mTProtoWatchdog = $this;
        running = bl;
    }

    public static final /* synthetic */ ExecutorService access$getExecutor$p(MTProtoWatchdog $this) {
        MTProtoWatchdog mTProtoWatchdog = $this;
        return executor;
    }
}

