/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.mtproto;

import com.github.badoualy.telegram.mtproto.ApiCallback;
import com.github.badoualy.telegram.mtproto.DataCenter;
import com.github.badoualy.telegram.mtproto.MTProtoWatchdog;
import com.github.badoualy.telegram.mtproto.auth.AuthKey;
import com.github.badoualy.telegram.mtproto.auth.AuthResult;
import com.github.badoualy.telegram.mtproto.secure.EncryptedMessage;
import com.github.badoualy.telegram.mtproto.secure.MTProtoMessageEncryption;
import com.github.badoualy.telegram.mtproto.secure.RandomUtils;
import com.github.badoualy.telegram.mtproto.time.MTProtoTimer;
import com.github.badoualy.telegram.mtproto.time.TimeOverlord;
import com.github.badoualy.telegram.mtproto.tl.MTBadMessage;
import com.github.badoualy.telegram.mtproto.tl.MTBadMessageNotification;
import com.github.badoualy.telegram.mtproto.tl.MTBadServerSalt;
import com.github.badoualy.telegram.mtproto.tl.MTFutureSalts;
import com.github.badoualy.telegram.mtproto.tl.MTMessage;
import com.github.badoualy.telegram.mtproto.tl.MTMessageDetailedInfo;
import com.github.badoualy.telegram.mtproto.tl.MTMessagesContainer;
import com.github.badoualy.telegram.mtproto.tl.MTMsgsAck;
import com.github.badoualy.telegram.mtproto.tl.MTNeedResendMessage;
import com.github.badoualy.telegram.mtproto.tl.MTNewMessageDetailedInfo;
import com.github.badoualy.telegram.mtproto.tl.MTNewSessionCreated;
import com.github.badoualy.telegram.mtproto.tl.MTProtoContext;
import com.github.badoualy.telegram.mtproto.tl.MTRpcError;
import com.github.badoualy.telegram.mtproto.tl.MTRpcResult;
import com.github.badoualy.telegram.mtproto.transport.MTProtoConnection;
import com.github.badoualy.telegram.mtproto.transport.MTProtoTcpConnection;
import com.github.badoualy.telegram.mtproto.util.Log;
import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.api.TLAbsUpdates;
import com.github.badoualy.telegram.tl.api.TLApiContext;
import com.github.badoualy.telegram.tl.api.request.TLRequestHelpGetNearestDc;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import com.github.badoualy.telegram.tl.exception.DeserializationException;
import com.github.badoualy.telegram.tl.exception.RpcErrorException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;
import rx.schedulers.Schedulers;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0016\n\u0002\b\u0004\u0018\u0000 e2\u00020\u0001:\u0001eB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B+\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\rJ\u0006\u00108\u001a\u000209J\u0010\u0010:\u001a\u0002072\u0006\u0010;\u001a\u00020.H\u0003J.\u0010<\u001a\b\u0012\u0004\u0012\u0002H>0=\"\b\b\u0000\u0010>*\u0002072\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H>0(2\u0006\u0010@\u001a\u00020\fH\u0007J5\u0010A\u001a\n \u0015*\u0004\u0018\u0001H>H>\"\b\b\u0000\u0010>*\u0002072\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H>0(2\u0006\u0010@\u001a\u00020\fH\u0007\u00a2\u0006\u0002\u0010BJ\b\u0010C\u001a\u00020\fH\u0002J\u0010\u0010D\u001a\u00020\u000f2\u0006\u0010;\u001a\u000207H\u0002J\u0018\u0010D\u001a\u00020\u000f2\u000e\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u0002070FH\u0002J\u0013\u0010G\u001a\b\u0012\u0004\u0012\u00020.0HH\u0002\u00a2\u0006\u0002\u0010IJ\u0018\u0010J\u001a\u0002092\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020.H\u0003J\u0010\u0010N\u001a\u0002092\u0006\u0010;\u001a\u00020.H\u0003J\u0010\u0010O\u001a\u0002092\u0006\u0010P\u001a\u00020QH\u0003J\b\u0010R\u001a\u000209H\u0002J\u0010\u0010S\u001a\u00020T2\u0006\u0010;\u001a\u000207H\u0002J\u0018\u0010S\u001a\u00020T2\u000e\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u0002070FH\u0002J\u001a\u0010U\u001a\u0002092\u0006\u0010V\u001a\u00020\u000f2\b\b\u0002\u0010W\u001a\u00020TH\u0002J\u0010\u0010X\u001a\u0002092\u0006\u0010Y\u001a\u00020/H\u0002J\u0006\u0010Z\u001a\u000209J\u0010\u0010[\u001a\u0002092\u0006\u0010\\\u001a\u00020/H\u0003J\u0010\u0010]\u001a\u0002092\u0006\u0010;\u001a\u00020.H\u0003J\u0010\u0010^\u001a\u0002092\u0006\u0010_\u001a\u00020\fH\u0003J\u0010\u0010`\u001a\u0002092\u0006\u0010a\u001a\u00020bH\u0003J\u0006\u0010c\u001a\u000209J\b\u0010d\u001a\u000209H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020.0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u00100\u001a\u0004\u0018\u00010/2\b\u0010\u0016\u001a\u0004\u0018\u00010/@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R \u00105\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u000207060'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lcom/github/badoualy/telegram/mtproto/MTProtoHandler;", "", "authResult", "Lcom/github/badoualy/telegram/mtproto/auth/AuthResult;", "apiCallback", "Lcom/github/badoualy/telegram/mtproto/ApiCallback;", "(Lcom/github/badoualy/telegram/mtproto/auth/AuthResult;Lcom/github/badoualy/telegram/mtproto/ApiCallback;)V", "dataCenter", "Lcom/github/badoualy/telegram/mtproto/DataCenter;", "authKey", "Lcom/github/badoualy/telegram/mtproto/auth/AuthKey;", "salt", "", "(Lcom/github/badoualy/telegram/mtproto/DataCenter;Lcom/github/badoualy/telegram/mtproto/auth/AuthKey;Ljava/lang/Long;Lcom/github/badoualy/telegram/mtproto/ApiCallback;)V", "ACK_BUFFER_SIZE", "", "ACK_BUFFER_TIMEOUT", "TAG", "", "apiContext", "Lcom/github/badoualy/telegram/tl/api/TLApiContext;", "kotlin.jvm.PlatformType", "<set-?>", "getAuthKey", "()Lcom/github/badoualy/telegram/mtproto/auth/AuthKey;", "setAuthKey", "(Lcom/github/badoualy/telegram/mtproto/auth/AuthKey;)V", "bufferId", "bufferTimeoutTask", "Ljava/util/TimerTask;", "connection", "Lcom/github/badoualy/telegram/mtproto/transport/MTProtoConnection;", "crMessageSent", "lastMessageId", "messageToAckList", "Ljava/util/ArrayList;", "mtProtoContext", "Lcom/github/badoualy/telegram/mtproto/tl/MTProtoContext;", "requestMap", "Ljava/util/Hashtable;", "Lcom/github/badoualy/telegram/tl/core/TLMethod;", "getSalt", "()J", "setSalt", "(J)V", "sentMessageList", "Lcom/github/badoualy/telegram/mtproto/tl/MTMessage;", "", "sessionId", "getSessionId", "()[B", "setSessionId", "([B)V", "subscriberMap", "Lrx/Subscriber;", "Lcom/github/badoualy/telegram/tl/core/TLObject;", "close", "", "deserializeMessageContent", "message", "executeMethod", "Lrx/Observable;", "T", "method", "timeout", "executeMethodSync", "(Lcom/github/badoualy/telegram/tl/core/TLMethod;J)Lcom/github/badoualy/telegram/tl/core/TLObject;", "generateMessageId", "generateSeqNo", "clazz", "Ljava/lang/Class;", "getExtraToSend", "", "()[Lcom/github/badoualy/telegram/mtproto/tl/MTMessage;", "handleBadMessage", "badMessage", "Lcom/github/badoualy/telegram/mtproto/tl/MTBadMessageNotification;", "container", "handleMessage", "handleResult", "result", "Lcom/github/badoualy/telegram/mtproto/tl/MTRpcResult;", "init", "isContentRelated", "", "onBufferTimeout", "id", "flush", "onMessageReceived", "bytes", "resetConnection", "sendData", "data", "sendMessage", "sendMessageAck", "messageId", "sendMessagesAck", "messagesId", "", "startWatchdog", "stopWatchdog", "Companion", "mtproto-compileKotlin"})
public final class MTProtoHandler {
    private String TAG;
    private final int ACK_BUFFER_SIZE = 15;
    private final long ACK_BUFFER_TIMEOUT = 150000L;
    private final MTProtoContext mtProtoContext;
    private final TLApiContext apiContext;
    private MTProtoConnection connection;
    @Nullable
    private AuthKey authKey;
    @Nullable
    private byte[] sessionId;
    private long salt;
    private final Hashtable<Long, Subscriber<TLObject>> subscriberMap;
    private final Hashtable<Long, TLMethod<?>> requestMap;
    private final ArrayList<MTMessage> sentMessageList;
    private ArrayList<Long> messageToAckList;
    private int crMessageSent;
    private long lastMessageId;
    private TimerTask bufferTimeoutTask;
    private int bufferId;
    private final ApiCallback apiCallback;
    private static final ExecutorService updatePool;
    public static final Companion Companion;

    @Nullable
    public final AuthKey getAuthKey() {
        return this.authKey;
    }

    private final void setAuthKey(AuthKey authKey) {
        this.authKey = authKey;
    }

    @Nullable
    public final byte[] getSessionId() {
        return this.sessionId;
    }

    private final void setSessionId(byte[] byArray) {
        this.sessionId = byArray;
    }

    public final long getSalt() {
        return this.salt;
    }

    private final void setSalt(long l) {
        this.salt = l;
    }

    private final void init() {
        this.sessionId = RandomUtils.Companion.randomSessionId();
        this.TAG = "MTProtoHandler#" + new BigInteger(this.sessionId).longValue();
        Log.Companion.d$default(Log.Companion, this.TAG, "New session id created", 0, 4, null);
        this.lastMessageId = 0L;
        this.crMessageSent = 0;
    }

    public final void startWatchdog() {
        MTProtoConnection mTProtoConnection = this.connection;
        if (mTProtoConnection == null) {
            Intrinsics.throwNpe();
        }
        MTProtoWatchdog.INSTANCE.start(mTProtoConnection).observeOn(Schedulers.computation()).doOnError((Action1)new Action1<Throwable>(this){
            final /* synthetic */ MTProtoHandler this$0;

            /*
             * WARNING - void declaration
             */
            public final void call(Throwable it) {
                Subscriber singleSubscriber;
                Object v0;
                void $receiver$iv$iv;
                Log.Companion.e$default(Log.Companion, MTProtoHandler.access$getTAG$p(this.this$0), "doOnError()", it, 0, 8, null);
                Map $receiver$iv = MTProtoHandler.access$getSubscriberMap$p(this.this$0);
                Iterable iterable = $receiver$iv.entrySet();
                Iterator<T> iterator$iv$iv = $receiver$iv$iv.iterator();
                if (!iterator$iv$iv.hasNext()) {
                    v0 = null;
                } else {
                    T maxElem$iv$iv = iterator$iv$iv.next();
                    Map.Entry it2 = (Map.Entry)maxElem$iv$iv;
                    Comparable maxValue$iv$iv = (Long)it2.getKey();
                    while (iterator$iv$iv.hasNext()) {
                        T e$iv$iv = iterator$iv$iv.next();
                        it2 = (Map.Entry)e$iv$iv;
                        Comparable v$iv$iv = (Long)it2.getKey();
                        if (maxValue$iv$iv.compareTo(v$iv$iv) >= 0) continue;
                        maxElem$iv$iv = e$iv$iv;
                        maxValue$iv$iv = v$iv$iv;
                    }
                    v0 = maxElem$iv$iv;
                }
                Map.Entry entry = v0;
                Object object = singleSubscriber = entry != null ? (Subscriber)entry.getValue() : null;
                if (singleSubscriber != null) {
                    Log.Companion.d$default(Log.Companion, MTProtoHandler.access$getTAG$p(this.this$0), "Found a single subscriber, sending timeout", 0, 4, null);
                    singleSubscriber.onError((Throwable)new TimeoutException());
                } else {
                    Log.Companion.d$default(Log.Companion, MTProtoHandler.access$getTAG$p(this.this$0), "Reset connection", 0, 4, null);
                    this.this$0.resetConnection();
                }
            }
            {
                this.this$0 = mTProtoHandler;
            }
        }).doOnNext(new Action1<? super T>(this){
            final /* synthetic */ MTProtoHandler this$0;

            public final void call(byte[] it) {
                Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                MTProtoHandler.access$onMessageReceived(this.this$0, it);
            }
            {
                this.this$0 = mTProtoHandler;
            }
        }).subscribe();
    }

    private final void stopWatchdog() {
        MTProtoConnection mTProtoConnection = this.connection;
        if (mTProtoConnection == null) {
            Intrinsics.throwNpe();
        }
        MTProtoWatchdog.INSTANCE.stop(mTProtoConnection);
    }

    public final void resetConnection() {
        Log.Companion.e$default(Log.Companion, this.TAG, "Reset connection...", null, 0, 12, null);
        TimerTask timerTask = this.bufferTimeoutTask;
        Boolean bl = timerTask != null ? Boolean.valueOf(timerTask.cancel()) : null;
        this.onBufferTimeout(this.bufferId, false);
        this.close();
        this.init();
        long l = new BigInteger(this.sessionId).longValue();
        MTProtoConnection mTProtoConnection = this.connection;
        if (mTProtoConnection == null) {
            Intrinsics.throwNpe();
        }
        String string = mTProtoConnection.getIp();
        MTProtoConnection mTProtoConnection2 = this.connection;
        if (mTProtoConnection2 == null) {
            Intrinsics.throwNpe();
        }
        this.connection = new MTProtoTcpConnection(l, string, mTProtoConnection2.getPort(), false, 8, null);
        this.startWatchdog();
        this.executeMethod((TLMethod)new TLRequestHelpGetNearestDc(), 5L);
    }

    public final void close() {
        TimerTask timerTask = this.bufferTimeoutTask;
        Boolean bl = timerTask != null ? Boolean.valueOf(timerTask.cancel()) : null;
        MTProtoHandler.onBufferTimeout$default(this, this.bufferId, false, 2, null);
        try {
            this.stopWatchdog();
            MTProtoConnection mTProtoConnection = this.connection;
            if (mTProtoConnection == null) {
                Intrinsics.throwNpe();
            }
            mTProtoConnection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.subscriberMap.clear();
        this.requestMap.clear();
        this.sentMessageList.clear();
        this.messageToAckList.clear();
    }

    public final <T extends TLObject> T executeMethodSync(@NotNull TLMethod<T> method, long timeout) throws IOException {
        Intrinsics.checkParameterIsNotNull(method, (String)"method");
        return (T)((TLObject)this.executeMethod(method, timeout).toBlocking().first());
    }

    @NotNull
    public final <T extends TLObject> Observable<T> executeMethod(@NotNull TLMethod<T> method, long timeout) throws IOException {
        Intrinsics.checkParameterIsNotNull(method, (String)"method");
        Observable observable2 = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(this, method){
            final /* synthetic */ MTProtoHandler this$0;
            final /* synthetic */ TLMethod $method;

            /*
             * WARNING - void declaration
             */
            public final void call(Subscriber<? super T> subscriber) {
                Log.Companion.d$default(Log.Companion, MTProtoHandler.access$getTAG$p(this.this$0), "executeMethod " + this.$method.toString(), 0, 4, null);
                try {
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    MTMessage[] extra = MTProtoHandler.access$getExtraToSend(this.this$0);
                    long msgId = MTProtoHandler.access$generateMessageId(this.this$0);
                    int n = MTProtoHandler.access$generateSeqNo(this.this$0, (TLObject)this.$method);
                    byte[] byArray = this.$method.serialize();
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"method.serialize()");
                    MTMessage methodMessage = new MTMessage(msgId, n, byArray, 0, 8, null);
                    Log.Companion.d$default(Log.Companion, MTProtoHandler.access$getTAG$p(this.this$0), "Sending method with msgId " + methodMessage.getMessageId() + " and seqNo " + methodMessage.getSeqNo(), 0, 4, null);
                    Object[] objectArray = (Object[])extra;
                    void var7_7 = $receiver$iv;
                    if (!(((void)$receiver$iv$iv).length == 0)) {
                        MTMessagesContainer container = new MTMessagesContainer();
                        CollectionsKt.addAll((Collection)container.getMessages(), (Object[])((Object[])extra));
                        container.getMessages().add(methodMessage);
                        long l = MTProtoHandler.access$generateMessageId(this.this$0);
                        int n2 = MTProtoHandler.access$generateSeqNo(this.this$0, container);
                        byte[] byArray2 = container.serialize();
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"container.serialize()");
                        MTProtoHandler.access$sendMessage(this.this$0, new MTMessage(l, n2, byArray2, 0, 8, null));
                    } else {
                        MTProtoHandler.access$sendMessage(this.this$0, methodMessage);
                    }
                    Subscriber<? super T> subscriber2 = subscriber;
                    if (subscriber2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type rx.Subscriber<com.github.badoualy.telegram.tl.core.TLObject>");
                    }
                    Subscriber<? super T> s = subscriber2;
                    MTProtoHandler.access$getSubscriberMap$p(this.this$0).put(msgId, s);
                    MTProtoHandler.access$getRequestMap$p(this.this$0).put(msgId, this.$method);
                }
                catch (IOException e) {
                    subscriber.onError((Throwable)e);
                }
            }
            {
                this.this$0 = mTProtoHandler;
                this.$method = tLMethod;
            }
        });
        Observable observable3 = observable2.timeout(timeout, TimeUnit.MILLISECONDS);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable3, (String)"observable.timeout(timeout, TimeUnit.MILLISECONDS)");
        return observable3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void sendMessageAck(long messageId) throws IOException {
        Object flush;
        Ref.IntRef id;
        Object startTimer;
        Object list;
        void lock$iv;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Ref.BooleanRef booleanRef2 = new Ref.BooleanRef();
        booleanRef2.element = false;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = -1;
        ArrayList<Long> arrayList = this.messageToAckList;
        synchronized (lock$iv) {
            list.element = this.messageToAckList;
            ArrayList arrayList2 = (ArrayList)list.element;
            if (arrayList2 == null) {
                Intrinsics.throwNpe();
            }
            arrayList2.add(messageId);
            Log.Companion.d$default(Log.Companion, this.TAG, "Adding msgId " + messageId + " to bufferId " + this.bufferId, 0, 4, null);
            id.element = this.bufferId;
            ArrayList arrayList3 = (ArrayList)list.element;
            if (arrayList3 == null) {
                Intrinsics.throwNpe();
            }
            if (arrayList3.size() == 1) {
                startTimer.element = true;
            } else {
                ArrayList arrayList4 = (ArrayList)list.element;
                if (arrayList4 == null) {
                    Intrinsics.throwNpe();
                }
                if (arrayList4.size() < this.ACK_BUFFER_SIZE) {
                    return;
                }
                this.messageToAckList = new ArrayList(this.ACK_BUFFER_SIZE);
                int n = this.bufferId;
                this.bufferId = n + 1;
                flush.element = true;
            }
            Unit unit = Unit.INSTANCE;
        }
        if (startTimer.element) {
            try {
                this.bufferTimeoutTask = MTProtoTimer.INSTANCE.schedule(this.ACK_BUFFER_TIMEOUT, (Function1<? super TimerTask, Unit>)((Function1)new Function1<TimerTask, Unit>(this, id){
                    final /* synthetic */ MTProtoHandler this$0;
                    final /* synthetic */ Ref.IntRef $id;

                    public final void invoke(TimerTask $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        MTProtoHandler.onBufferTimeout$default(this.this$0, this.$id.element, false, 2, null);
                    }
                    {
                        this.this$0 = mTProtoHandler;
                        this.$id = intRef;
                        super(1);
                    }
                }));
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        if (flush.element) {
            TimerTask timerTask = this.bufferTimeoutTask;
            Boolean bl = timerTask != null ? Boolean.valueOf(timerTask.cancel()) : null;
            this.bufferTimeoutTask = null;
            ArrayList arrayList5 = (ArrayList)list.element;
            if (arrayList5 == null) {
                Intrinsics.throwNpe();
            }
            this.sendMessagesAck(CollectionsKt.toLongArray((Collection)arrayList5));
        }
        id = null;
        list = null;
        startTimer = null;
        flush = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void onBufferTimeout(int id, boolean flush) {
        Object list;
        void lock$iv;
        MTProtoConnection mTProtoConnection = this.connection;
        if (!(mTProtoConnection != null ? mTProtoConnection.isOpen() : false)) {
            return;
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        ArrayList<Long> arrayList = this.messageToAckList;
        synchronized (lock$iv) {
            if (id != this.bufferId) {
                return;
            }
            list.element = this.messageToAckList;
            this.messageToAckList = new ArrayList(this.ACK_BUFFER_SIZE);
            int n = this.bufferId;
            this.bufferId = n + 1;
            int n2 = n;
        }
        if (flush) {
            ArrayList arrayList2 = (ArrayList)list.element;
            if (arrayList2 == null) {
                Intrinsics.throwNpe();
            }
            this.sendMessagesAck(CollectionsKt.toLongArray((Collection)arrayList2));
        }
        list = null;
    }

    static /* bridge */ /* synthetic */ void onBufferTimeout$default(MTProtoHandler mTProtoHandler, int n, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onBufferTimeout");
        }
        if ((n2 & 2) != 0) {
            bl = true;
        }
        mTProtoHandler.onBufferTimeout(n, bl);
    }

    private final void sendMessagesAck(long[] messagesId) throws IOException {
        long[] $receiver$iv = messagesId;
        if ($receiver$iv.length == 0) {
            return;
        }
        MTMsgsAck ackMessage = new MTMsgsAck(messagesId);
        long ackMessageId = this.generateMessageId();
        Log.Companion.d$default(Log.Companion, this.TAG, "Send ack for messages " + ArraysKt.joinToString$default((long[])messagesId, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " with ackMsgId " + ackMessageId, 0, 4, null);
        int n = this.generateSeqNo(ackMessage);
        byte[] byArray = ackMessage.serialize();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ackMessage.serialize()");
        this.sendMessage(new MTMessage(ackMessageId, n, byArray, 0, 8, null));
    }

    private final void sendMessage(MTMessage message) throws IOException {
        Log.Companion.d$default(Log.Companion, this.TAG, "Sending message with msgId " + message.getMessageId() + " and seqNo " + message.getSeqNo(), 0, 4, null);
        AuthKey authKey = this.authKey;
        if (authKey == null) {
            Intrinsics.throwNpe();
        }
        if (this.sessionId == null) {
            Intrinsics.throwNpe();
        }
        EncryptedMessage encryptedMessage = MTProtoMessageEncryption.Companion.encrypt(authKey, this.sessionId, this.salt, message);
        this.sendData(encryptedMessage.getData());
        this.sentMessageList.add(message);
    }

    private final void sendData(byte[] data) throws IOException {
        MTProtoConnection mTProtoConnection = this.connection;
        if (mTProtoConnection == null) {
            Intrinsics.throwNpe();
        }
        mTProtoConnection.writeMessage(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final MTMessage[] getExtraToSend() {
        void toAckList;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        ArrayList<Long> lock$iv = this.messageToAckList;
        synchronized (lock$iv) {
            toAckList.element = this.messageToAckList;
            Collection $receiver$iv2 = this.messageToAckList;
            if (!$receiver$iv2.isEmpty()) {
                this.messageToAckList = new ArrayList(this.ACK_BUFFER_SIZE);
                int $receiver$iv2 = this.bufferId;
                this.bufferId = $receiver$iv2 + 1;
                TimerTask timerTask = this.bufferTimeoutTask;
                Boolean bl = timerTask != null ? Boolean.valueOf(timerTask.cancel()) : null;
                this.bufferTimeoutTask = null;
            }
            Unit unit = Unit.INSTANCE;
        }
        ArrayList arrayList = (ArrayList)toAckList.element;
        if ((arrayList != null ? arrayList.size() : 0) > 0) {
            void elements$iv;
            ArrayList arrayList2 = (ArrayList)toAckList.element;
            if (arrayList2 == null) {
                Intrinsics.throwNpe();
            }
            MTMsgsAck ack = new MTMsgsAck(CollectionsKt.toLongArray((Collection)arrayList2));
            long l = this.generateMessageId();
            int n = this.generateSeqNo(ack);
            byte[] byArray = ack.serialize();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ack.serialize()");
            MTMessage ackMessage = new MTMessage(l, n, byArray, 0, 8, null);
            StringBuilder stringBuilder = new StringBuilder().append("Adding extra: ack for messages ");
            ArrayList arrayList3 = (ArrayList)toAckList.element;
            if (arrayList3 == null) {
                Intrinsics.throwNpe();
            }
            Log.Companion.d$default(Log.Companion, this.TAG, stringBuilder.append(CollectionsKt.joinToString$default((Iterable)arrayList3, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).append(" with msgId ").append(ackMessage.getMessageId()).append(" and seqNo ").append(ackMessage.getSeqNo()).toString(), 0, 4, null);
            MTMessage[] $i$f$isNotEmpty = new MTMessage[]{ackMessage};
            return (MTMessage[])((Object[])elements$iv);
        }
        return (MTMessage[])((Object[])new MTMessage[0]);
    }

    private final boolean isContentRelated(Class<? extends TLObject> clazz) {
        return !StringsKt.startsWith$default((String)clazz.getSimpleName(), (String)"MT", (boolean)false, (int)2, null);
    }

    private final boolean isContentRelated(TLObject message) {
        return this.isContentRelated(message.getClass());
    }

    /*
     * WARNING - void declaration
     */
    private final int generateSeqNo(Class<? extends TLObject> clazz) {
        int n;
        if (this.isContentRelated(clazz)) {
            void var2_2;
            int seqNo = this.crMessageSent * 2 + 1;
            int n2 = this.crMessageSent;
            this.crMessageSent = n2 + 1;
            n = var2_2;
        } else {
            n = this.crMessageSent * 2;
        }
        return n;
    }

    private final int generateSeqNo(TLObject message) {
        return this.generateSeqNo(message.getClass());
    }

    private final long generateMessageId() {
        MTProtoConnection mTProtoConnection = this.connection;
        if (mTProtoConnection == null) {
            Intrinsics.throwNpe();
        }
        this.lastMessageId = Math.max(TimeOverlord.INSTANCE.generateMessageId(mTProtoConnection.getDataCenter()), this.lastMessageId + (long)4);
        return this.lastMessageId;
    }

    /*
     * WARNING - void declaration
     */
    private final void onMessageReceived(byte[] bytes) {
        Object message;
        block11: {
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = new MTMessage(0L, 0, null, 0, 15, null);
            try {
                if (bytes.length == 4) {
                    throw (Throwable)new RpcErrorException(StreamUtils.readInt((byte[])bytes), "INVALID_AUTH_KEY");
                }
                AuthKey authKey = this.authKey;
                if (authKey == null) {
                    Intrinsics.throwNpe();
                }
                if (this.sessionId == null) {
                    Intrinsics.throwNpe();
                }
                message.element = MTProtoMessageEncryption.Companion.decrypt(authKey, this.sessionId, bytes);
                Log.Companion.d$default(Log.Companion, this.TAG, "Received msg " + ((MTMessage)((Object)message.element)).getMessageId() + " with seqNo " + ((MTMessage)((Object)message.element)).getSeqNo(), 0, 4, null);
                int n = StreamUtils.readInt((byte[])((MTMessage)((Object)message.element)).getPayload());
                if (n == MTMessagesContainer.CONSTRUCTOR_ID) {
                    Object v1;
                    MTMessagesContainer container;
                    block10: {
                        void $receiver$iv;
                        Log.Companion.d$default(Log.Companion, this.TAG, "Message is a container", 0, 4, null);
                        container = (MTMessagesContainer)this.mtProtoContext.deserializeMessage(((MTMessage)((Object)message.element)).getPayload(), MTMessagesContainer.class, MTMessagesContainer.CONSTRUCTOR_ID);
                        Log.Companion.d$default(Log.Companion, this.TAG, "Container has " + container.getMessages().size() + " items", 0, 4, null);
                        Iterable iterable = container.getMessages();
                        for (Object element$iv : $receiver$iv) {
                            MTMessage m = (MTMessage)((Object)element$iv);
                            if (!(m.getMessageId() >= ((MTMessage)((Object)message.element)).getMessageId())) continue;
                            v1 = element$iv;
                            break block10;
                        }
                        v1 = null;
                    }
                    if (v1 != null) {
                        throw (Throwable)new SecurityException("Message contained in container has a same or greater msgId than container, ignoring whole container");
                    }
                    Iterator<Object> iterator = container.getMessages().iterator();
                    while (iterator.hasNext()) {
                        MTMessage msg;
                        MTMessage mTMessage = msg = (MTMessage)((Object)iterator.next());
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)mTMessage), (String)"msg");
                        this.handleMessage(mTMessage);
                    }
                    break block11;
                }
                this.handleMessage((MTMessage)((Object)message.element));
            }
            catch (IOException e) {
                void $receiver$iv;
                Log.Companion.e$default(Log.Companion, this.TAG, "Hex dump " + StreamUtils.toHexString((byte[])((MTMessage)((Object)message.element)).getPayload()), null, 0, 12, null);
                Throwable container = e;
                void v3 = $receiver$iv;
                if (v3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                }
                ((Throwable)v3).printStackTrace();
            }
        }
        message = null;
    }

    private final TLObject deserializeMessageContent(MTMessage message) throws DeserializationException, IOException {
        int classId = StreamUtils.readInt((byte[])message.getPayload());
        if (this.mtProtoContext.isSupportedObject(classId)) {
            TLObject tLObject = this.mtProtoContext.deserializeMessage(message.getPayload());
            Intrinsics.checkExpressionValueIsNotNull((Object)tLObject, (String)"mtProtoContext.deserializeMessage(message.payload)");
            return tLObject;
        }
        TLObject tLObject = this.apiContext.deserializeMessage(message.getPayload());
        Intrinsics.checkExpressionValueIsNotNull((Object)tLObject, (String)"apiContext.deserializeMessage(message.payload)");
        return tLObject;
    }

    /*
     * WARNING - void declaration
     */
    private final void handleMessage(MTMessage message) throws IOException {
        TLObject messageContent = this.deserializeMessageContent(message);
        Log.Companion.d$default(Log.Companion, this.TAG, "handle " + messageContent.toString(), 0, 4, null);
        TLObject tLObject = messageContent;
        if (tLObject instanceof MTMsgsAck) {
            Log.Companion.d$default(Log.Companion, this.TAG, "Received ack for " + StringUtils.join((Iterable)((Iterable)((MTMsgsAck)messageContent).getMessages()), (String)", "), 0, 4, null);
        } else if (tLObject instanceof MTRpcResult) {
            this.handleResult((MTRpcResult)messageContent);
            this.sendMessageAck(message.getMessageId());
        } else if (tLObject instanceof TLAbsUpdates) {
            Companion.getUpdatePool().execute(new Runnable(this, messageContent){
                final /* synthetic */ MTProtoHandler this$0;
                final /* synthetic */ TLObject $messageContent;

                public final void run() {
                    Unit unit;
                    ApiCallback apiCallback = MTProtoHandler.access$getApiCallback$p(this.this$0);
                    if (apiCallback != null) {
                        apiCallback.onUpdates((TLAbsUpdates)this.$messageContent);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                }
                {
                    this.this$0 = mTProtoHandler;
                    this.$messageContent = tLObject;
                }
            });
            this.sendMessageAck(message.getMessageId());
        } else if (tLObject instanceof MTNewSessionCreated) {
            this.sendMessageAck(message.getMessageId());
        } else if (tLObject instanceof MTBadMessageNotification) {
            this.handleBadMessage((MTBadMessageNotification)messageContent, message);
        } else if (tLObject instanceof MTBadServerSalt) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            Unit unit;
            Log.Companion.e$default(Log.Companion, this.TAG, ((MTBadServerSalt)messageContent).toPrettyString(), null, 0, 12, null);
            this.salt = ((MTBadServerSalt)messageContent).getNewSalt();
            ApiCallback apiCallback = this.apiCallback;
            if (apiCallback != null) {
                apiCallback.onSalt(this.salt);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Iterable iterable = this.sentMessageList;
            void var6_5 = $receiver$iv;
            Collection collection = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                MTMessage it = (MTMessage)((Object)element$iv$iv);
                if (!(it.getMessageId() == ((MTBadServerSalt)messageContent).getBadMsgId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            MTMessage sentMessage = (MTMessage)((Object)CollectionsKt.firstOrNull((List)((List)destination$iv$iv)));
            if (sentMessage != null) {
                Log.Companion.d$default(Log.Companion, this.TAG, "Re-sending message " + ((MTBadServerSalt)messageContent).getBadMsgId() + " with new salt", 0, 4, null);
                this.sendMessage(sentMessage);
            } else {
                Log.Companion.e$default(Log.Companion, this.TAG, "Couldn't find sentMessage in history with msgId " + ((MTBadServerSalt)messageContent).getBadMsgId() + ", can't re-send with good salt", null, 0, 12, null);
            }
        } else if (!(tLObject instanceof MTNeedResendMessage || tLObject instanceof MTNewMessageDetailedInfo || tLObject instanceof MTMessageDetailedInfo || tLObject instanceof MTFutureSalts)) {
            throw (Throwable)new IllegalStateException("Unsupported case " + messageContent.getClass().getSimpleName() + " " + messageContent.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleBadMessage(MTBadMessageNotification badMessage, MTMessage container) throws IOException {
        Log.Companion.e$default(Log.Companion, this.TAG, badMessage.toPrettyString(), null, 0, 12, null);
        int n = badMessage.getErrorCode();
        if (n == MTBadMessage.ERROR_MSG_ID_TOO_LOW || n == MTBadMessage.ERROR_MSG_ID_TOO_HIGH) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            this.lastMessageId = 0L;
            MTProtoConnection mTProtoConnection = this.connection;
            if (mTProtoConnection == null) {
                Intrinsics.throwNpe();
            }
            TimeOverlord.INSTANCE.synchronizeTime(mTProtoConnection.getDataCenter(), container.getMessageId());
            Iterable iterable = this.sentMessageList;
            void var6_5 = $receiver$iv;
            Collection collection = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                MTMessage it = (MTMessage)((Object)element$iv$iv);
                if (!(it.getMessageId() == badMessage.getBadMsgId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            MTMessage sentMessage = (MTMessage)((Object)CollectionsKt.firstOrNull((List)((List)destination$iv$iv)));
            if (sentMessage != null) {
                Subscriber<TLObject> subscriber = this.subscriberMap.remove(sentMessage.getMessageId());
                TLMethod<?> request = this.requestMap.remove(sentMessage.getMessageId());
                sentMessage.setMessageId(this.generateMessageId());
                this.subscriberMap.put(sentMessage.getMessageId(), subscriber);
                this.requestMap.put(sentMessage.getMessageId(), request);
                Log.Companion.d$default(Log.Companion, this.TAG, "Re-sending message " + badMessage.getBadMsgId() + " with new msgId " + sentMessage.getMessageId(), 0, 4, null);
                this.sendMessage(sentMessage);
            } else {
                Log.Companion.e$default(Log.Companion, this.TAG, "Couldn't find sentMessage in history with msgId " + badMessage.getBadMsgId() + ", can't re-send with good msgid", null, 0, 12, null);
            }
        } else if (n != MTBadMessage.ERROR_MSG_ID_MODULO && n != MTBadMessage.ERROR_SEQNO_TOO_LOW && n != MTBadMessage.ERROR_SEQNO_TOO_HIGH && n != MTBadMessage.ERROR_SEQNO_EXPECTED_EVEN && n != MTBadMessage.ERROR_SEQNO_EXPECTED_ODD) {
            Log.Companion.e$default(Log.Companion, this.TAG, "Unknown error code: " + badMessage.toPrettyString(), null, 0, 12, null);
        }
    }

    private final void handleResult(MTRpcResult result) throws IOException {
        Unit unit;
        TLMethod tLMethod;
        Subscriber subscriber;
        Subscriber subscriber2;
        Log.Companion.d$default(Log.Companion, this.TAG, "Got result for msgId " + result.getMessageId(), 0, 4, null);
        if (this.subscriberMap.containsKey(result.getMessageId())) {
            Subscriber subscriber3 = this.subscriberMap.remove(result.getMessageId());
            if (subscriber3 == null) {
                Intrinsics.throwNpe();
            }
            subscriber2 = subscriber3;
        } else {
            Log.Companion.e$default(Log.Companion, this.TAG, "No subscriber found for msgId " + result.getMessageId(), null, 0, 12, null);
            subscriber2 = subscriber = (Subscriber)null;
        }
        if (this.requestMap.containsKey(result.getMessageId())) {
            TLMethod tLMethod2 = this.requestMap.remove(result.getMessageId());
            if (tLMethod2 == null) {
                Intrinsics.throwNpe();
            }
            tLMethod = tLMethod2;
        } else {
            Log.Companion.e$default(Log.Companion, this.TAG, "No request object found for msgId " + result.getMessageId(), null, 0, 12, null);
            tLMethod = null;
        }
        TLMethod request = tLMethod;
        int classId = StreamUtils.readInt((byte[])result.getContent());
        Log.Companion.d$default(Log.Companion, this.TAG, "Response is a " + classId, 0, 4, null);
        if (this.mtProtoContext.isSupportedObject(classId)) {
            TLObject resultContent = this.mtProtoContext.deserializeMessage(result.getContent());
            if (resultContent instanceof MTRpcError) {
                Unit unit2;
                Log.Companion.e$default(Log.Companion, this.TAG, "rpcError " + ((MTRpcError)resultContent).getErrorCode() + ": " + ((MTRpcError)resultContent).getMessage(), null, 0, 12, null);
                Subscriber subscriber4 = subscriber;
                if (subscriber4 != null) {
                    subscriber4.onError((Throwable)new RpcErrorException(((MTRpcError)resultContent).getErrorCode(), ((MTRpcError)resultContent).getErrorTag()));
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
            } else {
                Log.Companion.e$default(Log.Companion, this.TAG, "Unsupported content " + result.toString(), null, 0, 12, null);
            }
        } else {
            Unit unit3;
            TLObject response = request != null ? request.deserializeResponse(result.getContent(), (TLContext)this.apiContext) : this.apiContext.deserializeMessage(result.getContent());
            Subscriber subscriber5 = subscriber;
            if (subscriber5 != null) {
                subscriber5.onNext((Object)response);
                unit3 = Unit.INSTANCE;
            } else {
                unit3 = null;
            }
        }
        Subscriber subscriber6 = subscriber;
        if (subscriber6 != null) {
            subscriber6.onCompleted();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    public MTProtoHandler(@NotNull AuthResult authResult, @Nullable ApiCallback apiCallback) {
        Intrinsics.checkParameterIsNotNull((Object)authResult, (String)"authResult");
        this.TAG = "MTProtoHandler";
        this.ACK_BUFFER_SIZE = 15;
        this.ACK_BUFFER_TIMEOUT = 150000L;
        this.mtProtoContext = MTProtoContext.INSTANCE;
        this.apiContext = TLApiContext.getInstance();
        this.subscriberMap = new Hashtable(10);
        this.requestMap = new Hashtable(10);
        this.sentMessageList = new ArrayList(10);
        this.messageToAckList = new ArrayList(this.ACK_BUFFER_SIZE);
        this.init();
        this.connection = authResult.getConnection();
        this.authKey = authResult.getAuthKey();
        this.salt = authResult.getServerSalt();
        this.apiCallback = apiCallback;
    }

    public MTProtoHandler(@NotNull DataCenter dataCenter, @NotNull AuthKey authKey, @Nullable Long salt, @Nullable ApiCallback apiCallback) {
        Intrinsics.checkParameterIsNotNull((Object)dataCenter, (String)"dataCenter");
        Intrinsics.checkParameterIsNotNull((Object)authKey, (String)"authKey");
        this.TAG = "MTProtoHandler";
        this.ACK_BUFFER_SIZE = 15;
        this.ACK_BUFFER_TIMEOUT = 150000L;
        this.mtProtoContext = MTProtoContext.INSTANCE;
        this.apiContext = TLApiContext.getInstance();
        this.subscriberMap = new Hashtable(10);
        this.requestMap = new Hashtable(10);
        this.sentMessageList = new ArrayList(10);
        this.messageToAckList = new ArrayList(this.ACK_BUFFER_SIZE);
        this.init();
        this.connection = new MTProtoTcpConnection(new BigInteger(this.sessionId).longValue(), dataCenter.getIp(), dataCenter.getPort(), false, 8, null);
        this.authKey = authKey;
        Long l = salt;
        this.salt = l != null ? ((Number)l).longValue() : 0L;
        this.apiCallback = apiCallback;
    }

    static {
        Companion = new Companion(null);
        updatePool = Executors.newFixedThreadPool(8);
    }

    @NotNull
    public static final /* synthetic */ String access$getTAG$p(MTProtoHandler $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ void access$setTAG$p(MTProtoHandler $this, @NotNull String string) {
        $this.TAG = string;
    }

    @NotNull
    public static final /* synthetic */ Hashtable access$getSubscriberMap$p(MTProtoHandler $this) {
        return $this.subscriberMap;
    }

    public static final /* synthetic */ void access$onMessageReceived(MTProtoHandler $this, @NotNull byte[] bytes) {
        $this.onMessageReceived(bytes);
    }

    @NotNull
    public static final /* synthetic */ MTMessage[] access$getExtraToSend(MTProtoHandler $this) {
        return $this.getExtraToSend();
    }

    public static final /* synthetic */ long access$generateMessageId(MTProtoHandler $this) {
        return $this.generateMessageId();
    }

    public static final /* synthetic */ int access$generateSeqNo(MTProtoHandler $this, @NotNull TLObject message) {
        return $this.generateSeqNo(message);
    }

    public static final /* synthetic */ void access$sendMessage(MTProtoHandler $this, @NotNull MTMessage message) {
        $this.sendMessage(message);
    }

    @NotNull
    public static final /* synthetic */ Hashtable access$getRequestMap$p(MTProtoHandler $this) {
        return $this.requestMap;
    }

    @Nullable
    public static final /* synthetic */ ApiCallback access$getApiCallback$p(MTProtoHandler $this) {
        return $this.apiCallback;
    }

    @JvmStatic
    public static final void cleanUp() {
        Companion.cleanUp();
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/github/badoualy/telegram/mtproto/MTProtoHandler$Companion;", "", "()V", "updatePool", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "getUpdatePool", "()Ljava/util/concurrent/ExecutorService;", "cleanUp", "", "mtproto-compileKotlin"})
    public static final class Companion {
        public final ExecutorService getUpdatePool() {
            return updatePool;
        }

        @JvmStatic
        public final void cleanUp() {
            MTProtoWatchdog.INSTANCE.cleanUp();
            MTProtoTimer.INSTANCE.shutdown();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

