/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.api;

import com.github.badoualy.telegram.api.Kotlogram;
import com.github.badoualy.telegram.api.TelegramApiStorage;
import com.github.badoualy.telegram.api.TelegramApp;
import com.github.badoualy.telegram.api.TelegramClient;
import com.github.badoualy.telegram.api.UpdateCallback;
import com.github.badoualy.telegram.mtproto.ApiCallback;
import com.github.badoualy.telegram.mtproto.DataCenter;
import com.github.badoualy.telegram.mtproto.MTProtoHandler;
import com.github.badoualy.telegram.mtproto.auth.AuthKey;
import com.github.badoualy.telegram.mtproto.auth.AuthKeyCreation;
import com.github.badoualy.telegram.mtproto.auth.AuthResult;
import com.github.badoualy.telegram.mtproto.exception.SecurityException;
import com.github.badoualy.telegram.mtproto.util.Log;
import com.github.badoualy.telegram.tl.api.TLAbsChat;
import com.github.badoualy.telegram.tl.api.TLAbsInputPeer;
import com.github.badoualy.telegram.tl.api.TLAbsReplyMarkup;
import com.github.badoualy.telegram.tl.api.TLAbsUpdates;
import com.github.badoualy.telegram.tl.api.TLAbsUser;
import com.github.badoualy.telegram.tl.api.TLNearestDc;
import com.github.badoualy.telegram.tl.api.TLUpdateShort;
import com.github.badoualy.telegram.tl.api.TLUpdateShortChatMessage;
import com.github.badoualy.telegram.tl.api.TLUpdateShortMessage;
import com.github.badoualy.telegram.tl.api.TLUpdateShortSentMessage;
import com.github.badoualy.telegram.tl.api.TLUpdates;
import com.github.badoualy.telegram.tl.api.TLUpdatesCombined;
import com.github.badoualy.telegram.tl.api.TLUpdatesTooLong;
import com.github.badoualy.telegram.tl.api.TelegramApiWrapper;
import com.github.badoualy.telegram.tl.api.auth.TLAbsSentCode;
import com.github.badoualy.telegram.tl.api.auth.TLExportedAuthorization;
import com.github.badoualy.telegram.tl.api.request.TLRequestAuthImportAuthorization;
import com.github.badoualy.telegram.tl.api.request.TLRequestHelpGetNearestDc;
import com.github.badoualy.telegram.tl.api.request.TLRequestInitConnection;
import com.github.badoualy.telegram.tl.api.request.TLRequestInvokeWithLayer;
import com.github.badoualy.telegram.tl.api.request.TLRequestUpdatesGetState;
import com.github.badoualy.telegram.tl.api.upload.TLFile;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import com.github.badoualy.telegram.tl.core.TLVector;
import com.github.badoualy.telegram.tl.exception.RpcErrorException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B)\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ \u0010 \u001a\n \"*\u0004\u0018\u00010!0!2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%H\u0017J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0017H\u0016J\u0010\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020+H\u0003J%\u0010,\u001a\u0002H-\"\b\b\u0000\u0010-*\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H-00H\u0017\u00a2\u0006\u0002\u00101J7\u0010,\u001a\u0002H-\"\b\b\u0000\u0010-*\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H-002\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u00102\u001a\u00020%H\u0003\u00a2\u0006\u0002\u00103J-\u0010,\u001a\u0002H-\"\b\b\u0000\u0010-*\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H-002\u0006\u00104\u001a\u00020%H\u0017\u00a2\u0006\u0002\u00105J\b\u0010\u0016\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020\u00192\u0006\u00104\u001a\u00020%H\u0003J\u0012\u00108\u001a\u00020'2\b\b\u0002\u00109\u001a\u00020\u0017H\u0002J-\u0010:\u001a\u0002H-\"\b\b\u0000\u0010-*\u00020.2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H-00H\u0003\u00a2\u0006\u0002\u0010;J-\u0010:\u001a\n \"*\u0004\u0018\u0001H-H-\"\b\b\u0000\u0010-*\u00020.2\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H-00H\u0017\u00a2\u0006\u0002\u00101J(\u0010=\u001a\n \"*\u0004\u0018\u00010>0>2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020\u001dH\u0017J\u0010\u0010C\u001a\u00020'2\u0006\u00104\u001a\u00020%H\u0002J\u0010\u0010D\u001a\u00020'2\u0006\u0010E\u001a\u00020\u001dH\u0016J\u0010\u0010F\u001a\u00020'2\u0006\u0010G\u001a\u00020>H\u0016J\u0010\u0010H\u001a\u00020'2\u0006\u0010I\u001a\u00020\u001dH\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006J"}, d2={"Lcom/github/badoualy/telegram/api/DefaultTelegramClient;", "Lcom/github/badoualy/telegram/tl/api/TelegramApiWrapper;", "Lcom/github/badoualy/telegram/api/TelegramClient;", "Lcom/github/badoualy/telegram/mtproto/ApiCallback;", "application", "Lcom/github/badoualy/telegram/api/TelegramApp;", "apiStorage", "Lcom/github/badoualy/telegram/api/TelegramApiStorage;", "preferredDataCenter", "Lcom/github/badoualy/telegram/mtproto/DataCenter;", "updateCallback", "Lcom/github/badoualy/telegram/api/UpdateCallback;", "(Lcom/github/badoualy/telegram/api/TelegramApp;Lcom/github/badoualy/telegram/api/TelegramApiStorage;Lcom/github/badoualy/telegram/mtproto/DataCenter;Lcom/github/badoualy/telegram/api/UpdateCallback;)V", "TAG", "", "getApiStorage", "()Lcom/github/badoualy/telegram/api/TelegramApiStorage;", "getApplication", "()Lcom/github/badoualy/telegram/api/TelegramApp;", "authKey", "Lcom/github/badoualy/telegram/mtproto/auth/AuthKey;", "dataCenter", "generateAuthKey", "", "mtProtoHandler", "Lcom/github/badoualy/telegram/mtproto/MTProtoHandler;", "getPreferredDataCenter", "()Lcom/github/badoualy/telegram/mtproto/DataCenter;", "timeoutDuration", "", "getUpdateCallback", "()Lcom/github/badoualy/telegram/api/UpdateCallback;", "authSendCode", "Lcom/github/badoualy/telegram/tl/api/auth/TLAbsSentCode;", "kotlin.jvm.PlatformType", "phoneNumber", "smsType", "", "close", "", "cleanUp", "ensureNearestDc", "nearestDc", "Lcom/github/badoualy/telegram/tl/api/TLNearestDc;", "executeRpcQuery", "T", "Lcom/github/badoualy/telegram/tl/core/TLObject;", "method", "Lcom/github/badoualy/telegram/tl/core/TLMethod;", "(Lcom/github/badoualy/telegram/tl/core/TLMethod;)Lcom/github/badoualy/telegram/tl/core/TLObject;", "attemptCount", "(Lcom/github/badoualy/telegram/tl/core/TLMethod;Lcom/github/badoualy/telegram/mtproto/MTProtoHandler;I)Lcom/github/badoualy/telegram/tl/core/TLObject;", "dcId", "(Lcom/github/badoualy/telegram/tl/core/TLMethod;I)Lcom/github/badoualy/telegram/tl/core/TLObject;", "Lcom/github/badoualy/telegram/mtproto/auth/AuthResult;", "getExportedMTProtoHandler", "init", "checkNearestDc", "initConnection", "(Lcom/github/badoualy/telegram/mtproto/MTProtoHandler;Lcom/github/badoualy/telegram/tl/core/TLMethod;)Lcom/github/badoualy/telegram/tl/core/TLObject;", "query", "messagesSendMessage", "Lcom/github/badoualy/telegram/tl/api/TLAbsUpdates;", "peer", "Lcom/github/badoualy/telegram/tl/api/TLAbsInputPeer;", "message", "randomId", "migrate", "onSalt", "salt", "onUpdates", "update", "setTimeout", "timeout", "api-compileKotlin"})
public final class DefaultTelegramClient
extends TelegramApiWrapper
implements TelegramClient,
ApiCallback {
    private final String TAG = "TelegramClient";
    private MTProtoHandler mtProtoHandler;
    private AuthKey authKey;
    private DataCenter dataCenter;
    private long timeoutDuration;
    private boolean generateAuthKey;
    @NotNull
    private final TelegramApp application;
    @NotNull
    private final TelegramApiStorage apiStorage;
    @NotNull
    private final DataCenter preferredDataCenter;
    @Nullable
    private final UpdateCallback updateCallback;

    private final void init(boolean checkNearestDc) {
        block17: {
            MTProtoHandler mTProtoHandler;
            if (this.generateAuthKey) {
                mTProtoHandler = new MTProtoHandler(this.generateAuthKey(), (ApiCallback)this);
            } else {
                DataCenter dataCenter = this.dataCenter;
                if (dataCenter == null) {
                    Intrinsics.throwNpe();
                }
                AuthKey authKey = this.authKey;
                if (authKey == null) {
                    Intrinsics.throwNpe();
                }
                mTProtoHandler = new MTProtoHandler(dataCenter, authKey, this.apiStorage.loadServerSalt(), (ApiCallback)this);
            }
            MTProtoHandler mTProtoHandler2 = this.mtProtoHandler = mTProtoHandler;
            if (mTProtoHandler2 == null) {
                Intrinsics.throwNpe();
            }
            mTProtoHandler2.startWatchdog();
            try {
                block18: {
                    if (checkNearestDc) {
                        MTProtoHandler mTProtoHandler3 = this.mtProtoHandler;
                        if (mTProtoHandler3 == null) {
                            Intrinsics.throwNpe();
                        }
                        TLNearestDc tLNearestDc = (TLNearestDc)this.initConnection(mTProtoHandler3, (TLMethod)new TLRequestHelpGetNearestDc());
                        Intrinsics.checkExpressionValueIsNotNull((Object)tLNearestDc, (String)"initConnection(mtProtoHa\u2026equestHelpGetNearestDc())");
                        this.ensureNearestDc(tLNearestDc);
                        break block17;
                    }
                    if (!this.generateAuthKey) {
                        try {
                            MTProtoHandler mTProtoHandler4 = this.mtProtoHandler;
                            if (mTProtoHandler4 == null) {
                                Intrinsics.throwNpe();
                            }
                            this.initConnection(mTProtoHandler4, (TLMethod)new TLRequestUpdatesGetState());
                            return;
                        }
                        catch (RpcErrorException e) {
                            if (e.getCode() == 401) break block18;
                            throw (Throwable)e;
                        }
                    }
                }
                MTProtoHandler mTProtoHandler5 = this.mtProtoHandler;
                if (mTProtoHandler5 == null) {
                    Intrinsics.throwNpe();
                }
                this.initConnection(mTProtoHandler5, (TLMethod)new TLRequestHelpGetNearestDc());
            }
            catch (Exception e) {
                Unit unit;
                MTProtoHandler mTProtoHandler6 = this.mtProtoHandler;
                if (mTProtoHandler6 != null) {
                    mTProtoHandler6.close();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (e instanceof RpcErrorException && ((RpcErrorException)((Object)e)).getCode() == -404) {
                    throw (Throwable)new SecurityException("Your authorization key is invalid (error " + ((RpcErrorException)((Object)e)).getCode() + ")");
                }
                throw (Throwable)e;
            }
        }
    }

    static /* bridge */ /* synthetic */ void init$default(DefaultTelegramClient defaultTelegramClient, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: init");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        defaultTelegramClient.init(bl);
    }

    private final AuthResult generateAuthKey() {
        DataCenter dataCenter = this.dataCenter;
        if (dataCenter == null) {
            Intrinsics.throwNpe();
        }
        AuthResult authResult = AuthKeyCreation.createAuthKey((DataCenter)dataCenter);
        if (authResult == null) {
            throw (Throwable)new RuntimeException("Couldn't generate authorization key");
        }
        AuthResult authResult2 = authResult;
        AuthKey authKey = this.authKey = authResult2.getAuthKey();
        if (authKey == null) {
            Intrinsics.throwNpe();
        }
        this.apiStorage.saveAuthKey(authKey);
        DataCenter dataCenter2 = this.dataCenter;
        if (dataCenter2 == null) {
            Intrinsics.throwNpe();
        }
        this.apiStorage.saveDc(dataCenter2);
        return authResult2;
    }

    private final <T extends TLObject> T initConnection(MTProtoHandler mtProtoHandler, TLMethod<T> method) throws RpcErrorException, IOException {
        TLObject result;
        TLRequestInitConnection initConnectionRequest = new TLRequestInitConnection(this.application.getApiId(), this.application.getDeviceModel(), this.application.getSystemVersion(), this.application.getAppVersion(), this.application.getLangCode(), method);
        TLObject tLObject = result = DefaultTelegramClient.executeRpcQuery$default(this, (TLMethod)new TLRequestInvokeWithLayer(Kotlogram.INSTANCE.getAPI_LAYER(), (TLMethod)initConnectionRequest), mtProtoHandler, 0, 4, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)tLObject, (String)"result");
        return (T)tLObject;
    }

    private final void ensureNearestDc(TLNearestDc nearestDc) throws RpcErrorException, IOException {
        if (nearestDc.getThisDc() != nearestDc.getNearestDc()) {
            if (!this.generateAuthKey) {
                Unit unit;
                MTProtoHandler mTProtoHandler = this.mtProtoHandler;
                if (mTProtoHandler != null) {
                    mTProtoHandler.close();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                throw (Throwable)new RuntimeException("You tried to connect to an incorrect data center (DC" + nearestDc.getThisDc() + ") with an authorization key in storage, please connect to the nearest (DC" + nearestDc.getNearestDc() + ")");
            }
            this.migrate(nearestDc.getNearestDc());
        } else {
            Log.Companion.d$default((Log.Companion)Log.Companion, (String)this.TAG, (String)("Connected to the nearest DC" + nearestDc.getThisDc()), (int)0, (int)4, null);
        }
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeoutDuration = timeout;
    }

    @Override
    public void close() {
        this.close(true);
    }

    @Override
    public void close(boolean cleanUp) {
        block5: {
            MTProtoHandler mTProtoHandler;
            block4: {
                mTProtoHandler = this.mtProtoHandler;
                if (mTProtoHandler == null) break block4;
                mTProtoHandler.close();
                mTProtoHandler = Unit.INSTANCE;
                if (mTProtoHandler != null) break block5;
            }
            mTProtoHandler = Unit.INSTANCE;
        }
        if (cleanUp) {
            Kotlogram.cleanUp();
        }
    }

    @Override
    @NotNull
    public <T extends TLObject> T executeRpcQuery(@NotNull TLMethod<T> method) throws RpcErrorException, IOException {
        Intrinsics.checkParameterIsNotNull(method, (String)"method");
        MTProtoHandler mTProtoHandler = this.mtProtoHandler;
        if (mTProtoHandler == null) {
            Intrinsics.throwNpe();
        }
        return (T)DefaultTelegramClient.executeRpcQuery$default(this, method, mTProtoHandler, 0, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T extends TLObject> T executeRpcQuery(@NotNull TLMethod<T> method, int dcId) throws RpcErrorException, IOException {
        Intrinsics.checkParameterIsNotNull(method, (String)"method");
        if (Kotlogram.getDcById(dcId).equals((Object)this.dataCenter)) {
            return this.executeRpcQuery(method);
        }
        MTProtoHandler migratedHandler = this.getExportedMTProtoHandler(dcId);
        try {
            TLObject tLObject = DefaultTelegramClient.executeRpcQuery$default(this, method, migratedHandler, 0, 4, null);
            return (T)tLObject;
        }
        finally {
            migratedHandler.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <T extends TLObject> T executeRpcQuery(TLMethod<T> method, MTProtoHandler mtProtoHandler, int attemptCount) throws RpcErrorException, IOException {
        try {
            TLObject tLObject = mtProtoHandler.executeMethodSync(method, this.timeoutDuration);
            Intrinsics.checkExpressionValueIsNotNull((Object)tLObject, (String)"mtProtoHandler.executeMe\u2026(method, timeoutDuration)");
            return (T)tLObject;
        }
        catch (RuntimeException exception) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof RpcErrorException) {
                Throwable throwable2 = exception.getCause();
                if (throwable2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.github.badoualy.telegram.tl.exception.RpcErrorException");
                }
                RpcErrorException rpcException = (RpcErrorException)throwable2;
                if (rpcException.getCode() == 303) {
                    Log.Companion.e$default((Log.Companion)Log.Companion, (String)this.TAG, (String)("Received DC error: " + rpcException.toString()), null, (int)0, (int)12, null);
                    if (StringsKt.startsWith$default((String)rpcException.getTag(), (String)"PHONE_MIGRATE_", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)rpcException.getTag(), (String)"NETWORK_MIGRATE_", (boolean)false, (int)2, null)) {
                        void $receiver$iv;
                        String string = StringsKt.removePrefix((String)StringsKt.removePrefix((String)rpcException.getTag(), (CharSequence)"PHONE_MIGRATE_"), (CharSequence)"NETWORK_MIGRATE_");
                        DefaultTelegramClient defaultTelegramClient = this;
                        int n = Integer.parseInt((String)$receiver$iv);
                        defaultTelegramClient.migrate(n);
                        return this.executeRpcQuery(method);
                    }
                    if (StringsKt.startsWith$default((String)rpcException.getTag(), (String)"FILE_MIGRATE_", (boolean)false, (int)2, null)) {
                        void $receiver$iv;
                        String $i$f$toInt = StringsKt.removePrefix((String)rpcException.getTag(), (CharSequence)"FILE_MIGRATE_");
                        DefaultTelegramClient defaultTelegramClient = this;
                        int n = Integer.parseInt((String)$receiver$iv);
                        MTProtoHandler migratedHandler = defaultTelegramClient.getExportedMTProtoHandler(n);
                        try {
                            TLObject tLObject = DefaultTelegramClient.executeRpcQuery$default(this, method, migratedHandler, 0, 4, null);
                            return (T)tLObject;
                        }
                        finally {
                            migratedHandler.close();
                        }
                    }
                }
                throw (Throwable)new RpcErrorException(rpcException.getCode(), rpcException.getMessage());
            }
            if (throwable instanceof TimeoutException || throwable instanceof ClosedChannelException) {
                if (attemptCount < 2) {
                    Log.Companion.e$default((Log.Companion)Log.Companion, (String)this.TAG, (String)"Attempting MtProtoHandler reset after failure", null, (int)0, (int)12, null);
                    mtProtoHandler.resetConnection();
                    T result = this.executeRpcQuery(method, mtProtoHandler, attemptCount + 1);
                    Log.Companion.d$default((Log.Companion)Log.Companion, (String)this.TAG, (String)"Reset worked", (int)0, (int)4, null);
                    return result;
                }
                throw (Throwable)new TimeoutException("Request timed out");
            }
            if (throwable instanceof IOException) {
                Throwable throwable3 = exception.getCause();
                if (throwable3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.io.IOException");
                }
                throw (Throwable)((IOException)throwable3);
            }
            throw (Throwable)exception;
        }
    }

    static /* bridge */ /* synthetic */ TLObject executeRpcQuery$default(DefaultTelegramClient defaultTelegramClient, TLMethod tLMethod, MTProtoHandler mTProtoHandler, int n, int n2, Object object) throws RpcErrorException, IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: executeRpcQuery");
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return defaultTelegramClient.executeRpcQuery(tLMethod, mTProtoHandler, n);
    }

    @Override
    public TLAbsSentCode authSendCode(@NotNull String phoneNumber, int smsType) throws RpcErrorException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)phoneNumber, (String)"phoneNumber");
        return super.authSendCode(phoneNumber, smsType, this.application.getApiId(), this.application.getApiHash(), this.application.getLangCode());
    }

    @Override
    public <T extends TLObject> T initConnection(@NotNull TLMethod<T> query) throws RpcErrorException, IOException {
        Intrinsics.checkParameterIsNotNull(query, (String)"query");
        return this.executeRpcQuery((TLMethod)new TLRequestInitConnection(this.application.getApiId(), this.application.getDeviceModel(), this.application.getSystemVersion(), this.application.getAppVersion(), this.application.getLangCode(), query));
    }

    @Override
    public TLAbsUpdates messagesSendMessage(@NotNull TLAbsInputPeer peer, @NotNull String message, long randomId) throws RpcErrorException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)peer, (String)"peer");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        return super.messagesSendMessage(true, false, peer, (Integer)null, message, randomId, (TLAbsReplyMarkup)null, (TLVector)null);
    }

    private final void migrate(int dcId) {
        Unit unit;
        Log.Companion.d$default((Log.Companion)Log.Companion, (String)this.TAG, (String)("Migrating to DC" + dcId), (int)0, (int)4, null);
        MTProtoHandler mTProtoHandler = this.mtProtoHandler;
        if (mTProtoHandler != null) {
            mTProtoHandler.close();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        this.authKey = null;
        this.dataCenter = Kotlogram.getDcById(dcId);
        this.apiStorage.deleteAuthKey();
        this.apiStorage.deleteDc();
        this.generateAuthKey = true;
        this.init(false);
    }

    private final MTProtoHandler getExportedMTProtoHandler(int dcId) throws RpcErrorException, IOException {
        Log.Companion.d$default((Log.Companion)Log.Companion, (String)this.TAG, (String)("Creating handler on DC" + dcId), (int)0, (int)4, null);
        DataCenter dc = Kotlogram.getDcById(dcId);
        TLExportedAuthorization exportedAuthorization = this.authExportAuthorization(dcId);
        AuthResult authResult = AuthKeyCreation.createAuthKey((DataCenter)dc);
        if (authResult == null) {
            throw (Throwable)new IOException("Couldn't create authorization key on DC" + dcId);
        }
        AuthResult authResult2 = authResult;
        MTProtoHandler mtProtoHandler = new MTProtoHandler(authResult2, (ApiCallback)null);
        mtProtoHandler.startWatchdog();
        this.initConnection(mtProtoHandler, (TLMethod)new TLRequestAuthImportAuthorization(exportedAuthorization.getId(), exportedAuthorization.getBytes()));
        return mtProtoHandler;
    }

    public void onUpdates(@NotNull TLAbsUpdates update) {
        Intrinsics.checkParameterIsNotNull((Object)update, (String)"update");
        TLAbsUpdates tLAbsUpdates = update;
        if (tLAbsUpdates instanceof TLUpdates) {
            Unit unit;
            UpdateCallback updateCallback = this.updateCallback;
            if (updateCallback != null) {
                updateCallback.onUpdates(this, (TLUpdates)update);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else if (tLAbsUpdates instanceof TLUpdatesCombined) {
            Unit unit;
            UpdateCallback updateCallback = this.updateCallback;
            if (updateCallback != null) {
                updateCallback.onUpdatesCombined(this, (TLUpdatesCombined)update);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else if (tLAbsUpdates instanceof TLUpdateShort) {
            Unit unit;
            UpdateCallback updateCallback = this.updateCallback;
            if (updateCallback != null) {
                updateCallback.onUpdateShort(this, (TLUpdateShort)update);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else if (tLAbsUpdates instanceof TLUpdateShortChatMessage) {
            Unit unit;
            UpdateCallback updateCallback = this.updateCallback;
            if (updateCallback != null) {
                updateCallback.onShortChatMessage(this, (TLUpdateShortChatMessage)update);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else if (tLAbsUpdates instanceof TLUpdateShortMessage) {
            Unit unit;
            UpdateCallback updateCallback = this.updateCallback;
            if (updateCallback != null) {
                updateCallback.onShortMessage(this, (TLUpdateShortMessage)update);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else if (tLAbsUpdates instanceof TLUpdateShortSentMessage) {
            Unit unit;
            UpdateCallback updateCallback = this.updateCallback;
            if (updateCallback != null) {
                updateCallback.onShortSentMessage(this, (TLUpdateShortSentMessage)update);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else if (tLAbsUpdates instanceof TLUpdatesTooLong) {
            Unit unit;
            UpdateCallback updateCallback = this.updateCallback;
            if (updateCallback != null) {
                updateCallback.onUpdateTooLong(this);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
    }

    public void onSalt(long salt) {
        this.apiStorage.saveServerSalt(salt);
    }

    @NotNull
    public final TelegramApp getApplication() {
        return this.application;
    }

    @NotNull
    public final TelegramApiStorage getApiStorage() {
        return this.apiStorage;
    }

    @NotNull
    public final DataCenter getPreferredDataCenter() {
        return this.preferredDataCenter;
    }

    @Nullable
    public final UpdateCallback getUpdateCallback() {
        return this.updateCallback;
    }

    public DefaultTelegramClient(@NotNull TelegramApp application, @NotNull TelegramApiStorage apiStorage, @NotNull DataCenter preferredDataCenter, @Nullable UpdateCallback updateCallback) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)apiStorage, (String)"apiStorage");
        Intrinsics.checkParameterIsNotNull((Object)preferredDataCenter, (String)"preferredDataCenter");
        this.application = application;
        this.apiStorage = apiStorage;
        this.preferredDataCenter = preferredDataCenter;
        this.updateCallback = updateCallback;
        this.TAG = "TelegramClient";
        this.timeoutDuration = 5000L;
        this.authKey = this.apiStorage.loadAuthKey();
        this.dataCenter = this.apiStorage.loadDc();
        boolean bl = this.generateAuthKey = this.authKey == null;
        if (this.dataCenter == null) {
            if (!this.generateAuthKey) {
                this.apiStorage.deleteAuthKey();
                throw (Throwable)new RuntimeException("Found an authorization key in storage, but the DC configuration was not found, deleting authorization key");
            }
            Log.Companion.d$default((Log.Companion)Log.Companion, (String)this.TAG, (String)("No data center found in storage, using preferred " + this.preferredDataCenter.toString()), (int)0, (int)4, null);
            this.dataCenter = this.preferredDataCenter;
        }
        this.init(this.generateAuthKey);
        StringBuilder stringBuilder = new StringBuilder().append("Client ready with MTProto#");
        MTProtoHandler mTProtoHandler = this.mtProtoHandler;
        if (mTProtoHandler == null) {
            Intrinsics.throwNpe();
        }
        Log.Companion.d$default((Log.Companion)Log.Companion, (String)this.TAG, (String)stringBuilder.append(new BigInteger(mTProtoHandler.getSessionId()).longValue()).toString(), (int)0, (int)4, null);
    }

    @Override
    @Nullable
    public TLFile getUserPhoto(@NotNull TLAbsUser user, boolean big) throws RpcErrorException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        return TelegramClient.DefaultImpls.getUserPhoto(this, user, big);
    }

    @Override
    @Nullable
    public TLFile getChatPhoto(@NotNull TLAbsChat chat, boolean big) throws RpcErrorException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)chat, (String)"chat");
        return TelegramClient.DefaultImpls.getChatPhoto(this, chat, big);
    }
}

